/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.vod;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.gensee.entity.DocInfo;
import com.gensee.entity.PageInfo;
import com.gensee.fastsdk.core.VodPlayerImp;
import com.gensee.fastsdk.entity.ChapterInfo;
import com.gensee.fastsdk.ui.holder.BaseHolder;
import com.gensee.fastsdk.ui.view.xlistview.XListView;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.fastsdk.util.ResManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class VodChapterHolder
extends BaseHolder
implements VodPlayerImp.OnVodChapterListener {
    private XListView lvChapterList;
    private ChapterListAdapter chapterListAdapter;
    private LinearLayout lyChapterTitle;
    private VodPlayerImp mVodPlayerImp;
    private List<ChapterInfo> chapterList;
    private LinearLayout lyChapterNo;
    private LinearLayout lyChapterList;

    public VodChapterHolder(View rootView, Object value) {
        super(rootView, value);
    }

    @Override
    protected void initData(Object value) {
    }

    @Override
    protected void initComp(Object value) {
        this.chapterList = new ArrayList<ChapterInfo>();
        this.chapterListAdapter = new ChapterListAdapter();
        if (null != value) {
            this.mVodPlayerImp = (VodPlayerImp)value;
        }
        this.lvChapterList = (XListView)this.findViewById(ResManager.getId("vod_chapter_xlv"));
        this.lvChapterList.setPullLoadEnable(false);
        this.lvChapterList.setPullRefreshEnable(false);
        this.lvChapterList.setHeaderDividersEnabled(false);
        this.lvChapterList.setFooterDividersEnabled(false);
        this.lvChapterList.setAdapter((ListAdapter)this.chapterListAdapter);
        this.lyChapterTitle = (LinearLayout)this.findViewById(ResManager.getId("chapter_title_ly"));
        this.lvChapterList.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                if (null != VodChapterHolder.this.mVodPlayerImp) {
                    int nPosition = position - 1;
                    if (nPosition < 0) {
                        nPosition = 0;
                    }
                    VodChapterHolder.this.setSelectedPosition(nPosition);
                    VodChapterHolder.this.mVodPlayerImp.selectVodChapter(((ChapterInfo)VodChapterHolder.this.chapterList.get(nPosition)).getPageTimeStamp());
                }
            }
        });
        this.lyChapterNo = (LinearLayout)this.findViewById(ResManager.getId("chapter_no_ly"));
        this.lyChapterNo.setVisibility(0);
        this.lyChapterList = (LinearLayout)this.findViewById(ResManager.getId("chapt_list_ly"));
        this.lyChapterList.setVisibility(8);
    }

    public void setSelectedPosition(int selectedPosition) {
        if (null != this.chapterListAdapter) {
            this.chapterListAdapter.setSelectedPosition(selectedPosition);
            this.chapterListAdapter.notifyDataSetChanged();
            this.lvChapterList.setSelection(selectedPosition);
        }
    }

    public void notifyChapterList(List<ChapterInfo> pageList) {
        if (pageList.size() > 0 && this.lyChapterTitle.getVisibility() != 0) {
            this.lyChapterTitle.setVisibility(0);
        }
        if (null != this.chapterListAdapter) {
            Collections.sort(pageList);
            this.chapterListAdapter.notifyData(pageList);
            this.chapterListAdapter.setSelectedPosition(-1);
            this.chapterListAdapter.notifyDataSetChanged();
        }
    }

    public void onClick(View v) {
    }

    @Override
    public void onVodChapterData(final List<DocInfo> docs) {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (null != docs && docs.size() > 0) {
                    VodChapterHolder.this.lyChapterNo.setVisibility(8);
                    VodChapterHolder.this.lyChapterList.setVisibility(0);
                }
                VodChapterHolder.this.updateChapter(docs);
            }
        });
    }

    @Override
    public void onVodChapterPosition(final int nCurPosition) {
        this.post(new Runnable(){

            @Override
            public void run() {
                int position = nCurPosition;
                int nSize = VodChapterHolder.this.chapterList.size();
                for (int i = 0; i < nSize; ++i) {
                    ChapterInfo chapterInfo = (ChapterInfo)VodChapterHolder.this.chapterList.get(i);
                    if (chapterInfo.getPageTimeStamp() != position) continue;
                    VodChapterHolder.this.setSelectedPosition(i);
                    break;
                }
            }
        });
    }

    private void updateChapter(List<DocInfo> docInfoList) {
        this.chapterList.clear();
        if (null != docInfoList) {
            for (DocInfo docInfo : docInfoList) {
                List pageInfoList = docInfo.getPages();
                if (null == pageInfoList || pageInfoList.size() <= 0) continue;
                for (PageInfo pageInfo : pageInfoList) {
                    ChapterInfo chapterInfo = new ChapterInfo();
                    chapterInfo.setDocId(docInfo.getDocId());
                    chapterInfo.setDocName(docInfo.getDocName());
                    chapterInfo.setDocPageNum(docInfo.getPageNum());
                    chapterInfo.setDocType(docInfo.getType());
                    chapterInfo.setPageTimeStamp(pageInfo.getTimeStamp());
                    chapterInfo.setPageTitle(pageInfo.getTitle());
                    this.chapterList.add(chapterInfo);
                }
            }
        }
        this.notifyChapterList(this.chapterList);
    }

    public static interface IVodChapter {
        public void selectVodChapter(int var1);
    }

    private class ChapterListAdapter
    extends BaseAdapter {
        private List<ChapterInfo> pageList = new ArrayList<ChapterInfo>();
        private int selectedPosition = 0;

        public void setSelectedPosition(int position) {
            this.selectedPosition = position;
        }

        public void notifyData(List<ChapterInfo> pageList) {
            this.pageList.clear();
            this.pageList.addAll(pageList);
        }

        public int getCount() {
            return this.pageList.size();
        }

        public Object getItem(int position) {
            return this.pageList.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder viewHolder = null;
            if (null == convertView) {
                convertView = LayoutInflater.from((Context)GenseeUtils.getActivityFromView((View)parent)).inflate(ResManager.getLayoutId("fs_chapter_item_ly"), null);
                viewHolder = new ViewHolder(convertView);
                convertView.setTag((Object)viewHolder);
            } else {
                viewHolder = (ViewHolder)convertView.getTag();
            }
            viewHolder.init((ChapterInfo)this.getItem(position), position);
            return convertView;
        }

        private class ViewHolder {
            private TextView tvChapterIndex;
            private TextView tvChapterTitle;
            private TextView tvChapterTime;
            private LinearLayout lyChapter;

            private String getChapterTime(long time) {
                return String.format("%02d", time / 3600000L) + ":" + String.format("%02d", time % 3600000L / 60000L) + ":" + String.format("%02d", time % 3600000L % 60000L / 1000L);
            }

            public ViewHolder(View view) {
                this.tvChapterIndex = (TextView)view.findViewById(ResManager.getId("chapter_index"));
                this.tvChapterTitle = (TextView)view.findViewById(ResManager.getId("chapter_title"));
                this.tvChapterTime = (TextView)view.findViewById(ResManager.getId("chapter_time"));
                this.lyChapter = (LinearLayout)view.findViewById(ResManager.getId("chapter_ly"));
            }

            public void init(ChapterInfo chapterInfo, int position) {
                this.tvChapterIndex.setText((CharSequence)(position + 1 + ""));
                this.tvChapterTime.setText((CharSequence)this.getChapterTime(chapterInfo.getPageTimeStamp()));
                this.tvChapterTitle.setText((CharSequence)chapterInfo.getPageTitle());
                this.tvChapterIndex.setTextColor(VodChapterHolder.this.getContext().getResources().getColor(ResManager.getColorId("fs_chapter_color")));
                this.tvChapterTitle.setTextColor(VodChapterHolder.this.getContext().getResources().getColor(ResManager.getColorId("fs_chapter_color")));
                this.tvChapterTime.setTextColor(VodChapterHolder.this.getContext().getResources().getColor(ResManager.getColorId("fs_chapter_time_default")));
                if (ChapterListAdapter.this.selectedPosition == position) {
                    this.tvChapterIndex.setTextColor(VodChapterHolder.this.getContext().getResources().getColor(ResManager.getColorId("fs_chapter_cur_color")));
                    this.tvChapterTitle.setTextColor(VodChapterHolder.this.getContext().getResources().getColor(ResManager.getColorId("fs_chapter_cur_color")));
                    this.tvChapterTime.setTextColor(VodChapterHolder.this.getContext().getResources().getColor(ResManager.getColorId("fs_chapter_cur_color")));
                }
            }
        }
    }
}

