/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.portrait;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.gensee.common.ServiceType;
import com.gensee.fastsdk.core.PlayerLive;
import com.gensee.fastsdk.entity.GSMoreItem;
import com.gensee.fastsdk.ui.BaseActivity;
import com.gensee.fastsdk.ui.BaseFragment;
import com.gensee.fastsdk.ui.BaseWatchActivity;
import com.gensee.fastsdk.ui.holder.RewardHolder;
import com.gensee.fastsdk.ui.holder.chat.SimpleChatHolder;
import com.gensee.fastsdk.ui.holder.idc.IdcWhiteHolder;
import com.gensee.fastsdk.ui.view.CustomInputDialog;
import com.gensee.fastsdk.ui.view.RewardDanmaku;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.fastsdk.util.PreferUtil;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.media.IVideoIndication;
import com.gensee.media.RenderMode;
import com.gensee.utils.GenseeLog;
import com.gensee.view.GSVideoViewEx;
import master.flame.danmaku.controller.IDanmakuView;

public class WatchFragment
extends BaseFragment
implements View.OnClickListener {
    private GSVideoViewEx mVideoView;
    private View defView;
    private RelativeLayout videoLayout;
    private ImageView ivChat;
    private ImageView ivExit;
    private ImageView ivNet;
    private ImageView ivBugReport;
    private RelativeLayout rlControl;
    private RelativeLayout rlChat;
    private TextView tvTitle;
    private TextView tvTopState;
    private IdcWhiteHolder idcWhiteHolder;
    private ImageView iv_audioView;
    private TextView tvAudio;
    private RelativeLayout rlAudio;
    private RelativeLayout rlAudioContainer;
    private boolean isPlaying;
    private int currentSponsorSum;
    private View viewCover;
    protected RewardHolder rewardHolder;
    private ImageView ivSponsor;
    private String subject;

    public RewardHolder getRewardHolder() {
        return this.rewardHolder;
    }

    @Override
    protected void updateTitle(String title) {
        this.subject = title;
        if (!TextUtils.isEmpty((CharSequence)title) && null != this.tvTitle) {
            title = GenseeUtils.formatText(title, 10);
            this.tvTitle.setText((CharSequence)title);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(ResManager.getLayoutId("fs_gs_fragment_watch"), container, false);
        this.defView = view.findViewById(ResManager.getId("gs_relDef"));
        this.mVideoView = (GSVideoViewEx)view.findViewById(ResManager.getId("gs_videoView"));
        this.mVideoView.setRenderMode(RenderMode.RM_FILL_CENTER_CROP);
        ((BaseWatchActivity)this.getActivity()).setVideoView((IVideoIndication)this.mVideoView);
        this.videoLayout = (RelativeLayout)view.findViewById(ResManager.getId("gs_rlVideoLayout"));
        this.rlChat = (RelativeLayout)view.findViewById(ResManager.getId("gs_rl_chat"));
        this.ivChat = (ImageView)view.findViewById(ResManager.getId("gs_iv_chat"));
        this.ivBugReport = (ImageView)view.findViewById(ResManager.getId("gs_iv_bugReport"));
        this.ivNet = (ImageView)view.findViewById(ResManager.getId("gs_iv_net"));
        this.ivExit = (ImageView)view.findViewById(ResManager.getId("gs_gs_iv_exit"));
        this.rlControl = (RelativeLayout)view.findViewById(ResManager.getId("gs_rl_control"));
        this.tvTitle = (TextView)view.findViewById(ResManager.getId("gs_tv_title"));
        this.tvTopState = (TextView)view.findViewById(ResManager.getId("gs_tv_topState"));
        this.iv_audioView = (ImageView)view.findViewById(ResManager.getId("gs_iv_audioView"));
        this.tvAudio = (TextView)view.findViewById(ResManager.getId("gs_tv_audio"));
        this.rlAudio = (RelativeLayout)view.findViewById(ResManager.getId("gs_rl_audio"));
        this.rlAudioContainer = (RelativeLayout)view.findViewById(ResManager.getId("gs_rl_audio_container"));
        this.danmakuView = (IDanmakuView)view.findViewById(ResManager.getId("gs_danmukuView"));
        this.danmaku = new RewardDanmaku((Context)this.getActivity(), this.danmakuView);
        this.ivSponsor = (ImageView)view.findViewById(ResManager.getId("gs_iv_sponsor"));
        this.ivSponsor.setOnClickListener((View.OnClickListener)this);
        this.rewardHolder = new RewardHolder(view.findViewById(ResManager.getId("gs_reward_root_view")), null);
        ((BaseWatchActivity)this.getActivity()).setRewardHolder(this.rewardHolder);
        this.setDefView();
        this.idcWhiteHolder = new IdcWhiteHolder(view.findViewById(ResManager.getId("gs_ly_idc")), null);
        this.ivExit.setOnClickListener((View.OnClickListener)this);
        this.ivChat.setOnClickListener((View.OnClickListener)this);
        this.ivBugReport.setOnClickListener((View.OnClickListener)this);
        this.ivNet.setOnClickListener((View.OnClickListener)this);
        this.rlAudio.setOnClickListener((View.OnClickListener)this);
        this.rootView = view;
        this.mChatHolder = new SimpleChatHolder(this.rootView, ((BaseActivity)this.getActivity()).getChatImpl());
        ((BaseActivity)this.getActivity()).setSimpleChatHolder(this.mChatHolder);
        LinearLayout llExtraItems = (LinearLayout)view.findViewById(ResManager.getId("ll_extra_item"));
        this.addExtraItems(llExtraItems);
        return view;
    }

    private void addExtraItems(LinearLayout rootView) {
        if (null == PlayerLive.getIns().getExtraGSMoreItems()) {
            return;
        }
        for (int i = 0; i < PlayerLive.getIns().getExtraGSMoreItems().size(); ++i) {
            GSMoreItem GSMoreItem2 = PlayerLive.getIns().getExtraGSMoreItems().get(i);
            ImageView imageView = new ImageView((Context)this.getActivity());
            int ivId = GenseeUtils.generateViewId();
            imageView.setId(ivId);
            GSMoreItem2.setId(ivId);
            imageView.setBackgroundResource(ResManager.getDrawableId("fs_gs_cycle_gray_bg"));
            imageView.setImageDrawable(GSMoreItem2.getIcon());
            imageView.setOnClickListener((View.OnClickListener)this);
            int width = this.getResources().getDimensionPixelSize(ResManager.getDimenId("fs_gs_ic_width"));
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(width, width);
            int marginTop = this.getResources().getDimensionPixelSize(ResManager.getDimenId("fs_gs_ic_margin"));
            lp.setMargins(0, marginTop, 0, 0);
            rootView.addView((View)imageView, (ViewGroup.LayoutParams)lp);
        }
    }

    public void showRewardBtn(boolean isShow) {
        if (null != this.ivSponsor) {
            this.ivSponsor.setVisibility(isShow ? 0 : 8);
        }
    }

    protected void onJoinSuccess() {
        GenseeLog.e((String)"*****", (String)"WatchFragment-join-success");
        this.showControlView(true);
    }

    public void onVideoStart() {
        this.mVideoView.renderDefault();
        this.showDefView(false);
        this.showAudioView(false);
        this.showVideoView(true);
        this.iv_audioView.setVisibility(4);
        this.isPlaying = true;
    }

    public void onVideoOver() {
        this.showAudioView(true);
        this.isPlaying = false;
    }

    public void showVideoView(boolean isShow) {
        this.videoLayout.setVisibility(isShow ? 0 : 4);
        this.mVideoView.setVisibility(isShow ? 0 : 8);
    }

    private void setDefView() {
        RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.defView.getLayoutParams();
        lp.height = this.getHeight(1.3333334f);
        this.defView.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    public void showDefView(boolean isShow) {
        if (this.defView != null) {
            this.defView.setVisibility(isShow ? 0 : 4);
        }
    }

    public void showAudioView(boolean isShow) {
        if (this.iv_audioView != null) {
            this.iv_audioView.setVisibility(isShow ? 0 : 8);
        }
        if (!isShow) {
            return;
        }
        RelativeLayout.LayoutParams lp2 = (RelativeLayout.LayoutParams)this.iv_audioView.getLayoutParams();
        lp2.height = this.getHeight(1.3333334f);
        this.iv_audioView.setLayoutParams((ViewGroup.LayoutParams)lp2);
        this.mVideoView.setVisibility(8);
    }

    public void showControlView(boolean isShow) {
        if (this.rlControl != null) {
            this.rlControl.setVisibility(isShow ? 0 : 8);
        }
    }

    public void adjustReceiverUI(float aspectRatio) {
        GenseeLog.i((String)this.TAG, (String)("adjustReceiverUI aspectRatio:" + aspectRatio));
        RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.videoLayout.getLayoutParams();
        RelativeLayout.LayoutParams lp3 = (RelativeLayout.LayoutParams)this.mVideoView.getLayoutParams();
        if (1.0f < aspectRatio) {
            lp.height = this.getHeight(1.3333334f);
            lp3.height = aspectRatio >= 1.3333334f ? this.getHeight(aspectRatio) : -1;
            lp.addRule(3, ResManager.getId("gs_tv_title"));
        } else {
            lp.height = -1;
            lp.addRule(3, 0);
            lp3.height = -1;
        }
        this.videoLayout.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.mVideoView.setLayoutParams((ViewGroup.LayoutParams)lp3);
    }

    private int getHeight(float rate) {
        DisplayMetrics dm = new DisplayMetrics();
        this.getActivity().getWindowManager().getDefaultDisplay().getMetrics(dm);
        int screenWidth = dm.widthPixels;
        return (int)((float)screenWidth / rate);
    }

    public void onClick(View v) {
        if (v.getId() == ResManager.getId("gs_iv_chat")) {
            CustomInputDialog.Builder builder = new CustomInputDialog.Builder((Context)this.getActivity());
            CustomInputDialog dialog = builder.create();
            dialog.show();
        } else if (v.getId() == ResManager.getId("gs_gs_iv_exit")) {
            this.getActivity().onBackPressed();
        } else if (v.getId() == ResManager.getId("gs_iv_net")) {
            this.idcWhiteHolder.selectIdc(PlayerLive.getIns().getIdcList());
        } else if (v.getId() == ResManager.getId("gs_iv_bugReport")) {
            GenseeUtils.directSendLog((Context)this.getActivity(), PreferUtil.getIns().getInt("KEY_SERVICE_TYPE") == 1 ? ServiceType.TRAINING : ServiceType.WEBCAST, false);
        } else if (v.getId() == ResManager.getId("gs_rl_audio")) {
            this.rlAudio.setVisibility(8);
            ((BaseWatchActivity)this.getActivity()).closeMic(false);
        } else if (v.getId() == ResManager.getId("gs_iv_sponsor")) {
            this.rewardHolder.show(true);
            this.rewardHolder.init();
        } else {
            for (int i = 0; i < PlayerLive.getIns().getExtraGSMoreItems().size(); ++i) {
                GSMoreItem GSMoreItem2 = PlayerLive.getIns().getExtraGSMoreItems().get(i);
                if (GSMoreItem2.getId() != v.getId()) continue;
                GSMoreItem2.getIGSItemClickEvent().itemEvent(v, this.subject, PlayerLive.getIns().getInitParam().getLiveId());
            }
        }
    }

    public void receiveState(int state) {
        if (this.tvTopState == null) {
            return;
        }
        this.tvTopState.setVisibility(0);
        if (state == 0) {
            this.tvTopState.setText(ResManager.getStringId("fs_gs_cast_status_notstart"));
        } else if (state == 1) {
            this.showDefView(false);
            this.videoLayout.setVisibility(0);
            if (!this.isPlaying) {
                this.showAudioView(true);
            }
            this.tvTopState.setText(ResManager.getStringId("fs_gs_cast_status_ing"));
        } else if (state == 2) {
            this.tvTopState.setText(ResManager.getStringId("fs_gs_cast_status_pause"));
            this.videoLayout.setVisibility(4);
            this.showDefView(true);
            this.showAudioView(false);
        } else if (state == 3) {
            this.tvTopState.setText(ResManager.getStringId("fs_gs_cast_status_end"));
        }
    }

    public void onPause() {
        super.onPause();
    }

    public void audioOpenUI() {
        this.rlAudio.setEnabled(true);
        this.rlAudio.setVisibility(0);
        this.tvAudio.setText(ResManager.getStringId("fs_gs_mic_hang_up"));
    }

    public void audioCloseUI() {
        this.rlAudio.setVisibility(8);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (null != this.rewardHolder) {
            this.rewardHolder.onDestroy();
        }
    }
}

