/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.WindowManager;
import android.widget.TextView;
import java.util.Timer;
import java.util.TimerTask;

public class AutoScrollTextView
extends TextView {
    private float textLength = 0.0f;
    private float tx = 0.0f;
    private float ty = 0.0f;
    private Paint paint = null;
    private String text = "";
    private boolean bInit = false;
    private Timer timer;
    private static final int SCROLL_TIME = 6000;
    private static final int PER_SCROLL_TIME = 25;
    private float perMoveLenght = 0.0f;
    private int haveScrollTime = 0;
    private int nScrollCount = 0;
    private int nTimerCount = 0;
    private int nWidth = 0;
    private OnAutoScrollTextViewListener onAutoScrollTextViewListener;

    public void setOnAutoScrollTextViewListener(OnAutoScrollTextViewListener onAutoScrollTextViewListener) {
        this.onAutoScrollTextViewListener = onAutoScrollTextViewListener;
    }

    public AutoScrollTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void initScrollTextView(WindowManager windowManager, String text, int color2) {
        if ("".equals(text)) {
            return;
        }
        this.paint = this.getPaint();
        this.paint.setColor(color2);
        this.text = text;
        this.bInit = true;
        if (null != this.timer) {
            this.timer.cancel();
            this.timer = null;
        }
        this.perMoveLenght = 0.0f;
        this.haveScrollTime = 0;
        this.nScrollCount = 0;
        this.textLength = this.paint.measureText(text);
        this.ty = this.getTextSize() + (float)this.getPaddingTop();
        this.nTimerCount = 0;
        this.nWidth = 0;
        this.tx = 0.0f;
        this.startTimer();
        this.invalidate();
    }

    private void startTimer() {
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                AutoScrollTextView.this.post(new Runnable(){

                    @Override
                    public void run() {
                        AutoScrollTextView.this.countTx();
                    }
                });
            }
        }, 2000L, 25L);
    }

    protected void onDraw(Canvas canvas) {
        if (this.bInit) {
            this.nWidth = this.getWidth();
            this.bInit = false;
            int moveLength = (int)this.textLength;
            this.perMoveLenght = this.paint.measureText("000000") / 1000.0f * 25.0f;
        }
        canvas.drawText(this.text, this.tx, this.ty, this.paint);
        super.onDraw(canvas);
    }

    private void countTx() {
        this.tx -= this.perMoveLenght;
        ++this.nTimerCount;
        this.invalidate();
        if (this.tx + this.textLength <= 0.0f) {
            ++this.nScrollCount;
            if (this.nScrollCount >= 2) {
                this.close();
            } else {
                this.haveScrollTime = 0;
                this.nTimerCount = 0;
                this.tx = 0.0f;
                this.invalidate();
                this._close();
                this.startTimer();
            }
        }
    }

    private void _close() {
        if (null != this.timer) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private void close() {
        this._close();
        if (null != this.onAutoScrollTextViewListener) {
            this.onAutoScrollTextViewListener.scrollClose();
        }
    }

    public static interface OnAutoScrollTextViewListener {
        public void scrollClose();
    }
}

