/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.view;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.LinearLayout;
import com.gensee.utils.GenseeLog;

public class ResizeLayout
extends LinearLayout {
    private OnResizeListener mListener;
    private int oldH = 0;

    public void setOnResizeListener(OnResizeListener l) {
        this.mListener = l;
    }

    public ResizeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int newH;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        GenseeLog.d((String)"onMeasure", (String)("onMeasure width=" + this.getMeasuredWidth() + " height=" + this.getMeasuredHeight()));
        if (this.mListener != null && (newH = this.getMeasuredHeight()) != this.oldH && Math.abs(newH - this.oldH) > 100) {
            if (this.oldH > 0) {
                this.mListener.OnResize(newH, this.oldH);
            }
            this.oldH = newH;
        }
    }

    public static interface OnResizeListener {
        public void OnResize(int var1, int var2);
    }
}

