/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.view;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.PopupWindow;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.fastsdk.util.ResManager;

public class VodPopMore
extends PopupWindow
implements View.OnClickListener {
    private OnMoreItemClick itemClick;
    private View share;
    private float density = 0.0f;

    public void onClick(View v) {
        if (this.itemClick == null) {
            return;
        }
        if (v.getId() == ResManager.getId("txtShare")) {
            this.itemClick.onItemShare();
        } else if (v.getId() == ResManager.getId("txtDiagnose")) {
            this.itemClick.onItemSendErrorMsg();
        }
        this.dismiss();
    }

    public VodPopMore(Context context) {
        super(context);
    }

    public VodPopMore(Context context, OnMoreItemClick itemClick) {
        this(context);
        this.itemClick = itemClick;
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        View view = inflater.inflate(ResManager.getLayoutId("fs_vod_pop_more_layout"), null);
        this.share = view.findViewById(ResManager.getId("txtShare"));
        this.share.setOnClickListener((View.OnClickListener)this);
        view.findViewById(ResManager.getId("txtDiagnose")).setOnClickListener((View.OnClickListener)this);
        this.setContentView(view);
        this.setWidth(-2);
        this.setHeight(-2);
        this.setBackgroundDrawable(context.getResources().getDrawable(ResManager.getColorId("fs_gs_transparent")));
        this.setOutsideTouchable(false);
        this.setFocusable(true);
    }

    public void showWindow(View anchor, boolean isCasting) {
        this.showAsDropDown(anchor, anchor.getWidth() - this.getWidth(), (int)(-11.5 * (double)this.getDensity((Context)GenseeUtils.getActivityFromView(anchor))));
    }

    private float getDensity(Context context) {
        if (this.density == 0.0f) {
            this.density = context.getResources().getDisplayMetrics().density;
        }
        return this.density;
    }

    public static interface OnMoreItemClick {
        public void onItemShare();

        public void onItemSendErrorMsg();
    }
}

