/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.ext.latex;

import android.graphics.Paint;
import android.graphics.Rect;
import androidx.annotation.ColorInt;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.markwon.core.MarkwonTheme;
import io.noties.markwon.ext.latex.JLatexAsyncDrawableSpan;
import io.noties.markwon.ext.latex.JLatextAsyncDrawable;
import io.noties.markwon.image.AsyncDrawable;

class JLatexInlineAsyncDrawableSpan
extends JLatexAsyncDrawableSpan {
    private final AsyncDrawable drawable;

    JLatexInlineAsyncDrawableSpan(@NonNull MarkwonTheme theme, @NonNull JLatextAsyncDrawable drawable, @ColorInt int color) {
        super(theme, drawable, color);
        this.drawable = drawable;
    }

    public int getSize(@NonNull Paint paint, CharSequence text, @IntRange(from=0L) int start, @IntRange(from=0L) int end, @Nullable Paint.FontMetricsInt fm) {
        int size;
        if (this.drawable.hasResult()) {
            Rect rect = this.drawable.getBounds();
            size = rect.right;
            if (fm != null) {
                this.adjustFontMetrics(rect, fm);
            }
        } else {
            size = (int)(paint.measureText(text, start, end) + 0.5f);
        }
        return size;
    }

    private void adjustFontMetrics(@NonNull Rect spanRect, @NonNull Paint.FontMetricsInt fm) {
        int lineHeight = fm.bottom - fm.top;
        int spanHeight = spanRect.height();
        if (lineHeight >= spanHeight) {
            return;
        }
        int safeAreaBottom = fm.bottom - fm.descent;
        int safeAreaTop = fm.top - fm.ascent;
        int half = (spanHeight - lineHeight) / 2;
        fm.ascent -= half;
        fm.descent += half;
        fm.top = fm.ascent + safeAreaTop;
        fm.bottom = fm.descent + safeAreaBottom;
    }
}

