/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.ext.latex;

import androidx.annotation.NonNull;
import io.noties.markwon.ext.latex.JLatexMathBlock;
import io.noties.markwon.ext.latex.LatexParseStyle;
import org.commonmark.internal.util.Parsing;
import org.commonmark.node.Block;
import org.commonmark.parser.block.AbstractBlockParser;
import org.commonmark.parser.block.BlockContinue;
import org.commonmark.parser.block.ParserState;

class JLatexMathBlockParser
extends AbstractBlockParser {
    @LatexParseStyle
    private final int parseStyle;
    private static final char SPACE = ' ';
    private final JLatexMathBlock block = new JLatexMathBlock();
    private final StringBuilder builder = new StringBuilder();
    private final int startSignCount;
    private boolean isParseEnded = false;

    JLatexMathBlockParser(int startSignCount) {
        this.startSignCount = startSignCount;
        this.parseStyle = 2;
    }

    JLatexMathBlockParser(int startSignCount, @LatexParseStyle int parseStyle) {
        this.startSignCount = startSignCount;
        this.parseStyle = parseStyle;
    }

    public Block getBlock() {
        return this.block;
    }

    public BlockContinue tryContinue(ParserState parserState) {
        int nextNonSpaceIndex = parserState.getNextNonSpaceIndex();
        CharSequence line = parserState.getLine();
        int length = line.length();
        this.isParseEnded = false;
        if (parserState.getIndent() < Parsing.CODE_BLOCK_INDENT) {
            int consumed;
            int signsMultiple;
            if (this.parseStyle == 1) {
                signsMultiple = 1;
                consumed = JLatexMathBlockParser.consume('$', line, nextNonSpaceIndex, length);
            } else {
                signsMultiple = 2;
                consumed = JLatexMathBlockParser.consume(JLatexMathBlockParser.getSymbolByStyle(this.parseStyle, false), line, nextNonSpaceIndex, length);
            }
            if (consumed == this.startSignCount && Parsing.skip((char)' ', (CharSequence)line, (int)(nextNonSpaceIndex + this.startSignCount * signsMultiple), (int)length) == length) {
                this.isParseEnded = true;
                return BlockContinue.finished();
            }
        }
        return BlockContinue.atIndex((int)parserState.getIndex());
    }

    public void addLine(CharSequence line) {
        this.builder.append(line);
        this.builder.append('\n');
    }

    public void closeBlock() {
        this.block.latex(this.builder.toString(), this.isParseEnded);
    }

    static int consume(String s, @NonNull CharSequence line, int start, int end) {
        int lengthS = s.length();
        if (line.length() >= lengthS) {
            for (int i = 0; i < lengthS; ++i) {
                if (s.charAt(i) == line.charAt(i)) continue;
                return 0;
            }
            return 1;
        }
        return 0;
    }

    static int consume(char c, @NonNull CharSequence line, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (c == line.charAt(i)) continue;
            return i - start;
        }
        return end - start;
    }

    static String getSymbolByStyle(int style, boolean start) {
        if (style == 1) {
            return "$";
        }
        if (start) {
            return "\\[";
        }
        return "\\]";
    }
}

