/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.ext.latex;

import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.text.Spanned;
import android.util.Log;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.VisibleForTesting;
import io.noties.markwon.AbstractMarkwonPlugin;
import io.noties.markwon.MarkwonConfiguration;
import io.noties.markwon.MarkwonPlugin;
import io.noties.markwon.MarkwonVisitor;
import io.noties.markwon.ext.latex.JLatexAsyncDrawableSpan;
import io.noties.markwon.ext.latex.JLatexBlockImageSizeResolver;
import io.noties.markwon.ext.latex.JLatexBlockParserFactory;
import io.noties.markwon.ext.latex.JLatexInlineAsyncDrawableSpan;
import io.noties.markwon.ext.latex.JLatexMathBlock;
import io.noties.markwon.ext.latex.JLatexMathBlockParserLegacy;
import io.noties.markwon.ext.latex.JLatexMathInlineProcessor;
import io.noties.markwon.ext.latex.JLatexMathNode;
import io.noties.markwon.ext.latex.JLatexMathTheme;
import io.noties.markwon.ext.latex.JLatextAsyncDrawable;
import io.noties.markwon.ext.latex.LatexParseStyle;
import io.noties.markwon.image.AsyncDrawable;
import io.noties.markwon.image.AsyncDrawableLoader;
import io.noties.markwon.image.AsyncDrawableScheduler;
import io.noties.markwon.image.DrawableUtils;
import io.noties.markwon.image.ImageSizeResolver;
import io.noties.markwon.inlineparser.InlineProcessor;
import io.noties.markwon.inlineparser.MarkwonInlineParserPlugin;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.parser.block.BlockParserFactory;
import ru.noties.jlatexmath.JLatexMathDrawable;

public class JLatexMathPlugin
extends AbstractMarkwonPlugin {
    @VisibleForTesting
    final Config config;
    private final JLatexAsyncDrawableLoader jLatexAsyncDrawableLoader;
    private final JLatexBlockImageSizeResolver jLatexBlockImageSizeResolver;
    private final ImageSizeResolver inlineImageSizeResolver;
    private final HashMap<String, JLatextAsyncDrawable> cachedInlineMap = new HashMap();
    private final HashMap<String, JLatextAsyncDrawable> cachedBlockMap = new HashMap();

    @NonNull
    public static JLatexMathPlugin create(float textSize) {
        return new JLatexMathPlugin(JLatexMathPlugin.builder(textSize).build());
    }

    @NonNull
    public static JLatexMathPlugin create(@Px float inlineTextSize, @Px float blockTextSize) {
        return new JLatexMathPlugin(JLatexMathPlugin.builder(inlineTextSize, blockTextSize).build());
    }

    @NonNull
    public static JLatexMathPlugin create(@NonNull Config config) {
        return new JLatexMathPlugin(config);
    }

    @NonNull
    public static JLatexMathPlugin create(@Px float textSize, @NonNull BuilderConfigure builderConfigure) {
        Builder builder = JLatexMathPlugin.builder(textSize);
        builderConfigure.configureBuilder(builder);
        return new JLatexMathPlugin(builder.build());
    }

    @NonNull
    public static JLatexMathPlugin create(@Px float inlineTextSize, @Px float blockTextSize, @NonNull BuilderConfigure builderConfigure) {
        Builder builder = JLatexMathPlugin.builder(inlineTextSize, blockTextSize);
        builderConfigure.configureBuilder(builder);
        return new JLatexMathPlugin(builder.build());
    }

    @NonNull
    public static Builder builder(@Px float textSize) {
        return new Builder(JLatexMathTheme.builder(textSize));
    }

    @NonNull
    public static Builder builder(@Px float inlineTextSize, @Px float blockTextSize) {
        return new Builder(JLatexMathTheme.builder(inlineTextSize, blockTextSize));
    }

    JLatexMathPlugin(@NonNull Config config) {
        this.config = config;
        this.jLatexAsyncDrawableLoader = new JLatexAsyncDrawableLoader(config);
        this.jLatexBlockImageSizeResolver = new JLatexBlockImageSizeResolver(config.theme.blockFitCanvas());
        this.inlineImageSizeResolver = new InlineImageSizeResolver();
    }

    public void configure(@NonNull MarkwonPlugin.Registry registry) {
        if (this.config.inlinesEnabled) {
            ((MarkwonInlineParserPlugin)registry.require(MarkwonInlineParserPlugin.class)).factoryBuilder().addInlineProcessor((InlineProcessor)new JLatexMathInlineProcessor(this.config.inlineStyle));
        }
    }

    public void configureParser(@NonNull Parser.Builder builder) {
        if (this.config.blocksEnabled) {
            if (this.config.blocksLegacy) {
                builder.customBlockParserFactory((BlockParserFactory)new JLatexMathBlockParserLegacy.Factory());
            } else {
                builder.customBlockParserFactory((BlockParserFactory)new JLatexBlockParserFactory(this.config.blockStyle));
            }
        }
    }

    public void configureVisitor(@NonNull MarkwonVisitor.Builder builder) {
        this.addBlockVisitor(builder);
        this.addInlineVisitor(builder);
    }

    private void addBlockVisitor(@NonNull MarkwonVisitor.Builder builder) {
        if (!this.config.blocksEnabled) {
            return;
        }
        builder.on(JLatexMathBlock.class, (MarkwonVisitor.NodeVisitor)new MarkwonVisitor.NodeVisitor<JLatexMathBlock>(){

            public void visit(@NonNull MarkwonVisitor visitor, @NonNull JLatexMathBlock jLatexMathBlock) {
                visitor.blockStart((Node)jLatexMathBlock);
                String latex = jLatexMathBlock.latex();
                int length = visitor.length();
                visitor.builder().append(JLatexMathPlugin.prepareLatexTextPlaceholder(latex));
                MarkwonConfiguration configuration = visitor.configuration();
                JLatextAsyncDrawable drawable = null;
                boolean isBlockComplete = jLatexMathBlock.isComplete();
                if (isBlockComplete && JLatexMathPlugin.this.cachedBlockMap.containsKey(latex)) {
                    drawable = (JLatextAsyncDrawable)((Object)JLatexMathPlugin.this.cachedBlockMap.get(latex));
                }
                if (drawable == null) {
                    drawable = new JLatextAsyncDrawable(latex, JLatexMathPlugin.this.jLatexAsyncDrawableLoader, JLatexMathPlugin.this.jLatexBlockImageSizeResolver, null, true, isBlockComplete);
                    if (isBlockComplete) {
                        JLatexMathPlugin.this.cachedBlockMap.put(latex, drawable);
                    }
                }
                JLatexAsyncDrawableSpan span = new JLatexAsyncDrawableSpan(configuration.theme(), drawable, JLatexMathPlugin.this.config.theme.blockTextColor());
                visitor.setSpans(length, (Object)span);
                visitor.blockEnd((Node)jLatexMathBlock);
            }
        });
    }

    private void addInlineVisitor(@NonNull MarkwonVisitor.Builder builder) {
        if (!this.config.inlinesEnabled) {
            return;
        }
        builder.on(JLatexMathNode.class, (MarkwonVisitor.NodeVisitor)new MarkwonVisitor.NodeVisitor<JLatexMathNode>(){

            public void visit(@NonNull MarkwonVisitor visitor, @NonNull JLatexMathNode jLatexMathNode) {
                String latex = jLatexMathNode.latex();
                int length = visitor.length();
                visitor.builder().append(JLatexMathPlugin.prepareLatexTextPlaceholder(latex));
                MarkwonConfiguration configuration = visitor.configuration();
                JLatextAsyncDrawable drawable = null;
                if (JLatexMathPlugin.this.cachedInlineMap.containsKey(latex)) {
                    drawable = (JLatextAsyncDrawable)((Object)JLatexMathPlugin.this.cachedInlineMap.get(latex));
                }
                if (drawable == null) {
                    drawable = new JLatextAsyncDrawable(latex, JLatexMathPlugin.this.jLatexAsyncDrawableLoader, JLatexMathPlugin.this.inlineImageSizeResolver, null, false, true);
                    JLatexMathPlugin.this.cachedInlineMap.put(latex, drawable);
                }
                JLatexInlineAsyncDrawableSpan span = new JLatexInlineAsyncDrawableSpan(configuration.theme(), drawable, JLatexMathPlugin.this.config.theme.inlineTextColor());
                visitor.setSpans(length, (Object)span);
            }
        });
    }

    public void beforeSetText(@NonNull TextView textView, @NonNull Spanned markdown) {
        AsyncDrawableScheduler.unschedule((TextView)textView);
    }

    public void afterSetText(@NonNull TextView textView) {
        AsyncDrawableScheduler.schedule((TextView)textView);
    }

    @VisibleForTesting
    @NonNull
    static String prepareLatexTextPlaceholder(@NonNull String latex) {
        return latex.replace('\n', ' ').trim();
    }

    static class JLatexAsyncDrawableLoader
    extends AsyncDrawableLoader {
        private final Config config;
        private final Handler handler = new Handler(Looper.getMainLooper());
        private final ConcurrentHashMap<AsyncDrawable, Future<?>> cache = new ConcurrentHashMap(3);

        JLatexAsyncDrawableLoader(@NonNull Config config) {
            this.config = config;
        }

        public void load(@NonNull AsyncDrawable drawable) {
            Future<?> future = this.cache.get(drawable);
            boolean isLatex = drawable instanceof JLatextAsyncDrawable;
            if (!isLatex) {
                return;
            }
            if (!((JLatextAsyncDrawable)drawable).isComplete()) {
                return;
            }
            final JLatextAsyncDrawable tempDrawable = (JLatextAsyncDrawable)drawable;
            if (future == null) {
                this.cache.put(tempDrawable, this.config.executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        block3: {
                            try {
                                JLatexMathDrawable jLatexMathDrawable = tempDrawable.isBlock() ? this.createBlockDrawable(tempDrawable) : this.createInlineDrawable(tempDrawable);
                                this.setResult(tempDrawable, (Drawable)jLatexMathDrawable);
                            }
                            catch (Throwable t) {
                                ErrorHandler errorHandler = ((JLatexAsyncDrawableLoader)this).config.errorHandler;
                                if (errorHandler == null) {
                                    Log.e((String)"JLatexMathPlugin", (String)("Error displaying latex: `" + tempDrawable.getDestination() + "`"), (Throwable)t);
                                }
                                Drawable errorDrawable = errorHandler.handleError(tempDrawable.getDestination(), t);
                                if (errorDrawable == null) break block3;
                                DrawableUtils.applyIntrinsicBoundsIfEmpty((Drawable)errorDrawable);
                                this.setResult(tempDrawable, errorDrawable);
                            }
                        }
                    }
                }));
            }
        }

        public void cancel(@NonNull AsyncDrawable drawable) {
            Future<?> future = this.cache.remove(drawable);
            if (future != null) {
                future.cancel(true);
            }
            this.handler.removeCallbacksAndMessages((Object)drawable);
        }

        @Nullable
        public Drawable placeholder(@NonNull AsyncDrawable drawable) {
            return null;
        }

        @NonNull
        private JLatexMathDrawable createBlockDrawable(@NonNull JLatextAsyncDrawable drawable) {
            String latex = drawable.getDestination();
            JLatexMathTheme theme = this.config.theme;
            JLatexMathTheme.BackgroundProvider backgroundProvider = theme.blockBackgroundProvider();
            JLatexMathTheme.Padding padding = theme.blockPadding();
            int color = theme.blockTextColor();
            JLatexMathDrawable.Builder builder = JLatexMathDrawable.builder((String)latex).textSize(theme.blockTextSize()).align(theme.blockHorizontalAlignment());
            if (backgroundProvider != null) {
                builder.background(backgroundProvider.provide());
            }
            if (padding != null) {
                builder.padding(padding.left, padding.top, padding.right, padding.bottom);
            }
            if (color != 0) {
                builder.color(color);
            }
            return builder.build();
        }

        @NonNull
        private JLatexMathDrawable createInlineDrawable(@NonNull JLatextAsyncDrawable drawable) {
            String latex = drawable.getDestination();
            JLatexMathTheme theme = this.config.theme;
            JLatexMathTheme.BackgroundProvider backgroundProvider = theme.inlineBackgroundProvider();
            JLatexMathTheme.Padding padding = theme.inlinePadding();
            int color = theme.inlineTextColor();
            JLatexMathDrawable.Builder builder = JLatexMathDrawable.builder((String)latex).textSize(theme.inlineTextSize());
            if (backgroundProvider != null) {
                builder.background(backgroundProvider.provide());
            }
            if (padding != null) {
                builder.padding(padding.left, padding.top, padding.right, padding.bottom);
            }
            if (color != 0) {
                builder.color(color);
            }
            return builder.build();
        }

        private void setResult(final @NonNull AsyncDrawable drawable, final @NonNull Drawable result) {
            this.handler.postAtTime(new Runnable(){

                @Override
                public void run() {
                    if (cache.remove(drawable) != null && drawable.isAttached()) {
                        drawable.setResult(result);
                    }
                }
            }, (Object)drawable, SystemClock.uptimeMillis());
        }
    }

    public static class Builder {
        private final JLatexMathTheme.Builder theme;
        private boolean blocksEnabled = true;
        private boolean blocksLegacy;
        private boolean inlinesEnabled;
        private ErrorHandler errorHandler;
        private ExecutorService executorService;
        @LatexParseStyle
        private int inlineStyle = 2;
        @LatexParseStyle
        private int blockStyle = 2;

        Builder(@NonNull JLatexMathTheme.Builder builder) {
            this.theme = builder;
        }

        @NonNull
        public JLatexMathTheme.Builder theme() {
            return this.theme;
        }

        @NonNull
        public Builder blocksEnabled(boolean blocksEnabled) {
            this.blocksEnabled = blocksEnabled;
            return this;
        }

        @NonNull
        public Builder blocksLegacy(boolean blocksLegacy) {
            this.blocksLegacy = blocksLegacy;
            return this;
        }

        @NonNull
        public Builder inlinesEnabled(boolean inlinesEnabled) {
            this.inlinesEnabled = inlinesEnabled;
            return this;
        }

        public Builder inlineStyle(@LatexParseStyle int style) {
            this.inlineStyle = style;
            return this;
        }

        public Builder blockStyle(@LatexParseStyle int style) {
            this.blockStyle = style;
            return this;
        }

        @NonNull
        public Builder errorHandler(@Nullable ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        @NonNull
        public Builder executorService(@NonNull ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @NonNull
        public Config build() {
            return new Config(this);
        }
    }

    @VisibleForTesting
    static class Config {
        final JLatexMathTheme theme;
        final boolean blocksEnabled;
        final boolean blocksLegacy;
        final boolean inlinesEnabled;
        final ErrorHandler errorHandler;
        final ExecutorService executorService;
        @LatexParseStyle
        final int inlineStyle;
        @LatexParseStyle
        final int blockStyle;

        Config(@NonNull Builder builder) {
            this.theme = builder.theme.build();
            this.blocksEnabled = builder.blocksEnabled;
            this.blocksLegacy = builder.blocksLegacy;
            this.inlinesEnabled = builder.inlinesEnabled;
            this.errorHandler = builder.errorHandler;
            this.inlineStyle = builder.inlineStyle;
            this.blockStyle = builder.blockStyle;
            ExecutorService executorService = builder.executorService;
            if (executorService == null) {
                executorService = Executors.newCachedThreadPool();
            }
            this.executorService = executorService;
        }
    }

    public static interface BuilderConfigure {
        public void configureBuilder(@NonNull Builder var1);
    }

    private static class InlineImageSizeResolver
    extends ImageSizeResolver {
        private InlineImageSizeResolver() {
        }

        @NonNull
        public Rect resolveImageSize(@NonNull AsyncDrawable drawable) {
            Rect imageBounds = drawable.getResult().getBounds();
            int canvasWidth = drawable.getLastKnownCanvasWidth();
            int w = imageBounds.width();
            if (w > canvasWidth) {
                float ratio = (float)w / (float)imageBounds.height();
                int h = (int)((float)canvasWidth / ratio + 0.5f);
                return new Rect(0, 0, canvasWidth, h);
            }
            return imageBounds;
        }
    }

    public static interface ErrorHandler {
        @Nullable
        public Drawable handleError(@NonNull String var1, @NonNull Throwable var2);
    }
}

