/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.ext.latex;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import io.noties.markwon.core.MarkwonTheme;
import io.noties.markwon.ext.latex.JLatextAsyncDrawable;
import io.noties.markwon.image.AsyncDrawable;
import io.noties.markwon.image.AsyncDrawableSpan;
import org.scilab.forge.jlatexmath.TeXIcon;
import ru.noties.jlatexmath.JLatexMathDrawable;
import ru.noties.jlatexmath.awt.Color;

public class JLatexAsyncDrawableSpan
extends AsyncDrawableSpan {
    private final JLatextAsyncDrawable drawable;
    private final int color;
    private boolean appliedTextColor;

    public JLatexAsyncDrawableSpan(@NonNull MarkwonTheme theme, @NonNull JLatextAsyncDrawable drawable, @ColorInt int color) {
        super(theme, (AsyncDrawable)drawable, 2, false);
        this.drawable = drawable;
        this.color = color;
        this.appliedTextColor = color != 0;
    }

    public void draw(@NonNull Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
        Drawable drawableResult;
        if (!this.appliedTextColor && this.drawable.hasResult() && (drawableResult = this.drawable.getResult()) instanceof JLatexMathDrawable) {
            JLatexMathDrawable result = (JLatexMathDrawable)drawableResult;
            TeXIcon icon = result.icon();
            icon.setForeground(new Color(paint.getColor()));
            this.appliedTextColor = true;
        }
        super.draw(canvas, text, start, end, x, top, y, bottom, paint);
    }

    @NonNull
    public JLatextAsyncDrawable drawable() {
        return this.drawable;
    }

    @ColorInt
    public int color() {
        return this.color;
    }
}

