/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.image;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.markwon.image.AsyncDrawableLoader;
import io.noties.markwon.image.AsyncDrawableLoaderImpl;
import io.noties.markwon.image.DefaultMediaDecoder;
import io.noties.markwon.image.ImagesPlugin;
import io.noties.markwon.image.MediaDecoder;
import io.noties.markwon.image.SchemeHandler;
import io.noties.markwon.image.data.DataUriSchemeHandler;
import io.noties.markwon.image.gif.GifMediaDecoder;
import io.noties.markwon.image.gif.GifSupport;
import io.noties.markwon.image.network.NetworkSchemeHandler;
import io.noties.markwon.image.svg.SvgMediaDecoder;
import io.noties.markwon.image.svg.SvgSupport;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

class AsyncDrawableLoaderBuilder {
    ExecutorService executorService;
    final Map<String, SchemeHandler> schemeHandlers = new HashMap<String, SchemeHandler>(3);
    final Map<String, MediaDecoder> mediaDecoders = new HashMap<String, MediaDecoder>(3);
    MediaDecoder defaultMediaDecoder;
    ImagesPlugin.PlaceholderProvider placeholderProvider;
    ImagesPlugin.ErrorHandler errorHandler;
    boolean isBuilt;

    AsyncDrawableLoaderBuilder(boolean shouldHandleAsync) {
        this.addSchemeHandler(new DataUriSchemeHandler(shouldHandleAsync));
        this.addSchemeHandler(new NetworkSchemeHandler(shouldHandleAsync));
        if (SvgSupport.hasSvgSupport()) {
            this.addMediaDecoder(SvgMediaDecoder.create());
        }
        if (GifSupport.hasGifSupport()) {
            this.addMediaDecoder(GifMediaDecoder.create());
        }
        this.defaultMediaDecoder = DefaultMediaDecoder.create();
    }

    void executorService(@NonNull ExecutorService executorService) {
        this.checkState();
        this.executorService = executorService;
    }

    void addSchemeHandler(@NonNull SchemeHandler schemeHandler) {
        this.checkState();
        for (String scheme : schemeHandler.supportedSchemes()) {
            this.schemeHandlers.put(scheme, schemeHandler);
        }
    }

    void addMediaDecoder(@NonNull MediaDecoder mediaDecoder) {
        this.checkState();
        for (String type : mediaDecoder.supportedTypes()) {
            this.mediaDecoders.put(type, mediaDecoder);
        }
    }

    void defaultMediaDecoder(@Nullable MediaDecoder mediaDecoder) {
        this.checkState();
        this.defaultMediaDecoder = mediaDecoder;
    }

    void removeSchemeHandler(@NonNull String scheme) {
        this.checkState();
        this.schemeHandlers.remove(scheme);
    }

    void removeMediaDecoder(@NonNull String contentType) {
        this.checkState();
        this.mediaDecoders.remove(contentType);
    }

    void placeholderProvider(@NonNull ImagesPlugin.PlaceholderProvider placeholderDrawableProvider) {
        this.checkState();
        this.placeholderProvider = placeholderDrawableProvider;
    }

    void errorHandler(@NonNull ImagesPlugin.ErrorHandler errorHandler) {
        this.checkState();
        this.errorHandler = errorHandler;
    }

    @NonNull
    AsyncDrawableLoader build() {
        this.checkState();
        this.isBuilt = true;
        if (this.executorService == null) {
            this.executorService = Executors.newCachedThreadPool();
        }
        return new AsyncDrawableLoaderImpl(this);
    }

    private void checkState() {
        if (this.isBuilt) {
            throw new IllegalStateException("ImagesPlugin has already been configured and cannot be modified any further");
        }
    }
}

