/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.image;

import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.InputStream;

public abstract class ImageItem {
    @NonNull
    public static ImageItem withResult(@NonNull Drawable drawable) {
        return new WithResult(drawable);
    }

    @NonNull
    public static WithDecodingNeeded withDecodingNeeded(@Nullable String contentType, @NonNull InputStream inputStream) {
        return new WithDecodingNeeded(contentType, inputStream);
    }

    private ImageItem() {
    }

    public abstract boolean hasResult();

    public abstract boolean hasDecodingNeeded();

    @NonNull
    public abstract WithResult getAsWithResult();

    @NonNull
    public abstract WithDecodingNeeded getAsWithDecodingNeeded();

    public static class WithResult
    extends ImageItem {
        private final Drawable result;

        private WithResult(@NonNull Drawable drawable) {
            this.result = drawable;
        }

        @NonNull
        public Drawable result() {
            return this.result;
        }

        @Override
        public boolean hasResult() {
            return true;
        }

        @Override
        public boolean hasDecodingNeeded() {
            return false;
        }

        @Override
        @NonNull
        public WithResult getAsWithResult() {
            return this;
        }

        @Override
        @NonNull
        public WithDecodingNeeded getAsWithDecodingNeeded() {
            throw new IllegalStateException();
        }
    }

    public static class WithDecodingNeeded
    extends ImageItem {
        private final String contentType;
        private final InputStream inputStream;
        private Drawable cachedDrawable;
        private boolean isProcessing = true;

        private WithDecodingNeeded(@Nullable String contentType, @Nullable InputStream inputStream) {
            this.contentType = contentType;
            this.inputStream = inputStream;
        }

        public WithDecodingNeeded() {
            this.contentType = null;
            this.inputStream = null;
        }

        @Nullable
        public String contentType() {
            return this.contentType;
        }

        @Nullable
        public InputStream inputStream() {
            return this.inputStream;
        }

        @Override
        public boolean hasResult() {
            return false;
        }

        @Override
        public boolean hasDecodingNeeded() {
            return true;
        }

        @Override
        @NonNull
        public WithResult getAsWithResult() {
            throw new IllegalStateException();
        }

        @Override
        @NonNull
        public WithDecodingNeeded getAsWithDecodingNeeded() {
            return this;
        }

        @Nullable
        public Drawable getCachedDrawable() {
            return this.cachedDrawable;
        }

        public void setCachedDrawable(Drawable cachedDrawable) {
            this.cachedDrawable = cachedDrawable;
            this.isProcessing = false;
        }

        public boolean isProcessing() {
            return this.isProcessing;
        }

        public void setIsProcessing(boolean processing) {
            this.isProcessing = processing;
        }
    }
}

