/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.image.data;

import android.text.TextUtils;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.markwon.image.data.DataUri;

public abstract class DataUriDecoder {
    @Nullable
    public abstract byte[] decode(@NonNull DataUri var1) throws Throwable;

    @NonNull
    public static DataUriDecoder create() {
        return new Impl();
    }

    static class Impl
    extends DataUriDecoder {
        private static final String CHARSET = "UTF-8";

        Impl() {
        }

        @Override
        @Nullable
        public byte[] decode(@NonNull DataUri dataUri) throws Throwable {
            String data = dataUri.data();
            if (!TextUtils.isEmpty((CharSequence)data)) {
                if (dataUri.base64()) {
                    return Base64.decode((byte[])data.getBytes(CHARSET), (int)0);
                }
                return data.getBytes(CHARSET);
            }
            return null;
        }
    }
}

