/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.image.file;

import android.content.Context;
import android.content.res.AssetManager;
import android.net.Uri;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.markwon.image.ImageItem;
import io.noties.markwon.image.ImageLoadedNotifier;
import io.noties.markwon.image.SchemeHandler;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class FileSchemeHandler
extends SchemeHandler {
    public static final String SCHEME = "file";
    private static final String FILE_ANDROID_ASSETS = "android_asset";
    @Nullable
    private final AssetManager assetManager;

    @NonNull
    public static FileSchemeHandler createWithAssets(@NonNull AssetManager assetManager) {
        return new FileSchemeHandler(assetManager);
    }

    @NonNull
    public static FileSchemeHandler createWithAssets(@NonNull Context context) {
        return new FileSchemeHandler(context.getAssets());
    }

    @NonNull
    public static FileSchemeHandler create() {
        return new FileSchemeHandler(null);
    }

    FileSchemeHandler(@Nullable AssetManager assetManager) {
        this(assetManager, false);
    }

    FileSchemeHandler(@Nullable AssetManager assetManager, boolean shouldHandleAsync) {
        this.assetManager = assetManager;
        this.shouldHandleAsync = shouldHandleAsync;
    }

    @Override
    @NonNull
    public ImageItem handle(@NonNull String raw, @NonNull Uri uri, @Nullable ImageLoadedNotifier notifier) {
        InputStream inputStream;
        CharSequence path;
        List segments = uri.getPathSegments();
        if (segments == null || segments.isEmpty()) {
            throw new IllegalStateException("Invalid file path: " + raw);
        }
        boolean assets = FILE_ANDROID_ASSETS.equals(segments.get(0));
        String fileName = uri.getLastPathSegment();
        if (assets) {
            if (this.assetManager != null) {
                path = new StringBuilder();
                int size = segments.size();
                for (int i = 1; i < size; ++i) {
                    if (i != 1) {
                        ((StringBuilder)path).append('/');
                    }
                    ((StringBuilder)path).append((String)segments.get(i));
                }
                try {
                    inputStream = this.assetManager.open(((StringBuilder)path).toString());
                }
                catch (IOException e) {
                    throw new IllegalStateException("Exception obtaining asset file: " + raw + ", path: " + ((StringBuilder)path).toString(), e);
                }
            }
            throw new IllegalStateException("Supplied file path points to assets, but FileSchemeHandler was not supplied with AssetsManager. Use `#createWithAssets` factory method to create FileSchemeHandler that can handle android assets");
        }
        path = uri.getPath();
        if (TextUtils.isEmpty((CharSequence)path)) {
            throw new IllegalStateException("Invalid file path: " + raw + ", " + (String)path);
        }
        try {
            inputStream = new BufferedInputStream(new FileInputStream((String)path));
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("Exception reading file: " + raw, e);
        }
        String contentType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(MimeTypeMap.getFileExtensionFromUrl((String)fileName));
        return ImageItem.withDecodingNeeded(contentType, inputStream);
    }

    @Override
    @NonNull
    public Collection<String> supportedSchemes() {
        return Collections.singleton(SCHEME);
    }
}

