/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.inlineparser;

import io.noties.markwon.inlineparser.InlineProcessor;
import io.noties.markwon.inlineparser.MarkwonInlineParser;
import java.util.regex.Pattern;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Node;

public class BackslashInlineProcessor
extends InlineProcessor {
    private static final Pattern ESCAPABLE = MarkwonInlineParser.ESCAPABLE;

    @Override
    public char specialCharacter() {
        return '\\';
    }

    @Override
    protected Node parse() {
        HardLineBreak node;
        ++this.index;
        char nextChar = this.peek();
        if (nextChar == '(' || nextChar == ')' || nextChar == '[' || nextChar == ']') {
            return null;
        }
        if (nextChar == '\n') {
            node = new HardLineBreak();
            ++this.index;
        } else if (this.index < this.input.length() && ESCAPABLE.matcher(this.input.substring(this.index, this.index + 1)).matches()) {
            node = this.text(this.input, this.index, this.index + 1);
            ++this.index;
        } else {
            node = this.text("\\");
        }
        return node;
    }
}

