/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.inlineparser;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.markwon.inlineparser.AutolinkInlineProcessor;
import io.noties.markwon.inlineparser.BackslashInlineProcessor;
import io.noties.markwon.inlineparser.BackticksInlineProcessor;
import io.noties.markwon.inlineparser.BangInlineProcessor;
import io.noties.markwon.inlineparser.CloseBracketInlineProcessor;
import io.noties.markwon.inlineparser.EntityInlineProcessor;
import io.noties.markwon.inlineparser.HtmlInlineProcessor;
import io.noties.markwon.inlineparser.InlineParserUtils;
import io.noties.markwon.inlineparser.InlineProcessor;
import io.noties.markwon.inlineparser.MarkwonInlineParserContext;
import io.noties.markwon.inlineparser.NewLineInlineProcessor;
import io.noties.markwon.inlineparser.OpenBracketInlineProcessor;
import io.noties.markwon.inlineparser.StaggeredDelimiterProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.commonmark.internal.Bracket;
import org.commonmark.internal.Delimiter;
import org.commonmark.internal.inline.AsteriskDelimiterProcessor;
import org.commonmark.internal.inline.UnderscoreDelimiterProcessor;
import org.commonmark.internal.util.Escaping;
import org.commonmark.internal.util.LinkScanner;
import org.commonmark.node.LinkReferenceDefinition;
import org.commonmark.node.Node;
import org.commonmark.node.Text;
import org.commonmark.parser.InlineParser;
import org.commonmark.parser.InlineParserContext;
import org.commonmark.parser.InlineParserFactory;
import org.commonmark.parser.delimiter.DelimiterProcessor;
import org.commonmark.parser.delimiter.DelimiterRun;

public class MarkwonInlineParser
implements InlineParser,
MarkwonInlineParserContext {
    private static final String ASCII_PUNCTUATION = "!\"#\\$%&'\\(\\)\\*\\+,\\-\\./:;<=>\\?@\\[\\\\\\]\\^_`\\{\\|\\}~";
    private static final Pattern PUNCTUATION = Pattern.compile("^[!\"#\\$%&'\\(\\)\\*\\+,\\-\\./:;<=>\\?@\\[\\\\\\]\\^_`\\{\\|\\}~\\p{Pc}\\p{Pd}\\p{Pe}\\p{Pf}\\p{Pi}\\p{Po}\\p{Ps}]");
    private static final Pattern SPNL = Pattern.compile("^ *(?:\n *)?");
    private static final Pattern UNICODE_WHITESPACE_CHAR = Pattern.compile("^[\\p{Zs}\t\r\n\f]");
    static final Pattern ESCAPABLE = Pattern.compile("^[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]");
    static final Pattern WHITESPACE = Pattern.compile("\\s+");
    private final InlineParserContext inlineParserContext;
    private final boolean referencesEnabled;
    private final BitSet specialCharacters;
    private final Map<Character, List<InlineProcessor>> inlineProcessors;
    private final Map<Character, DelimiterProcessor> delimiterProcessors;
    private Node block;
    private String input;
    private int index;
    private Delimiter lastDelimiter;
    private Bracket lastBracket;

    @NonNull
    public static FactoryBuilder factoryBuilder() {
        return new FactoryBuilderImpl().includeDefaults();
    }

    @NonNull
    public static FactoryBuilderNoDefaults factoryBuilderNoDefaults() {
        return new FactoryBuilderImpl();
    }

    public MarkwonInlineParser(@NonNull InlineParserContext inlineParserContext, boolean referencesEnabled, @NonNull List<InlineProcessor> inlineProcessors, @NonNull List<DelimiterProcessor> delimiterProcessors) {
        this.inlineParserContext = inlineParserContext;
        this.referencesEnabled = referencesEnabled;
        this.inlineProcessors = MarkwonInlineParser.calculateInlines(inlineProcessors);
        this.delimiterProcessors = MarkwonInlineParser.calculateDelimiterProcessors(delimiterProcessors);
        this.specialCharacters = MarkwonInlineParser.calculateSpecialCharacters(this.inlineProcessors.keySet(), this.delimiterProcessors.keySet());
    }

    @NonNull
    private static Map<Character, List<InlineProcessor>> calculateInlines(@NonNull List<InlineProcessor> inlines) {
        HashMap<Character, List<InlineProcessor>> map = new HashMap<Character, List<InlineProcessor>>(inlines.size());
        for (InlineProcessor inlineProcessor : inlines) {
            char character = inlineProcessor.specialCharacter();
            ArrayList<InlineProcessor> list = (ArrayList<InlineProcessor>)map.get(Character.valueOf(character));
            if (list == null) {
                list = new ArrayList<InlineProcessor>(1);
                map.put(Character.valueOf(character), list);
            }
            list.add(inlineProcessor);
        }
        return map;
    }

    @NonNull
    private static BitSet calculateSpecialCharacters(Set<Character> inlineCharacters, Set<Character> delimiterCharacters) {
        BitSet bitSet = new BitSet();
        for (Character c : inlineCharacters) {
            bitSet.set(c.charValue());
        }
        for (Character c : delimiterCharacters) {
            bitSet.set(c.charValue());
        }
        return bitSet;
    }

    private static Map<Character, DelimiterProcessor> calculateDelimiterProcessors(List<DelimiterProcessor> delimiterProcessors) {
        HashMap<Character, DelimiterProcessor> map = new HashMap<Character, DelimiterProcessor>();
        MarkwonInlineParser.addDelimiterProcessors(delimiterProcessors, map);
        return map;
    }

    private static void addDelimiterProcessors(Iterable<DelimiterProcessor> delimiterProcessors, Map<Character, DelimiterProcessor> map) {
        for (DelimiterProcessor delimiterProcessor : delimiterProcessors) {
            char closing;
            char opening = delimiterProcessor.getOpeningCharacter();
            if (opening == (closing = delimiterProcessor.getClosingCharacter())) {
                DelimiterProcessor old = map.get(Character.valueOf(opening));
                if (old != null && old.getOpeningCharacter() == old.getClosingCharacter()) {
                    StaggeredDelimiterProcessor s;
                    if (old instanceof StaggeredDelimiterProcessor) {
                        s = (StaggeredDelimiterProcessor)old;
                    } else {
                        s = new StaggeredDelimiterProcessor(opening);
                        s.add(old);
                    }
                    s.add(delimiterProcessor);
                    map.put(Character.valueOf(opening), s);
                    continue;
                }
                MarkwonInlineParser.addDelimiterProcessorForChar(opening, delimiterProcessor, map);
                continue;
            }
            MarkwonInlineParser.addDelimiterProcessorForChar(opening, delimiterProcessor, map);
            MarkwonInlineParser.addDelimiterProcessorForChar(closing, delimiterProcessor, map);
        }
    }

    private static void addDelimiterProcessorForChar(char delimiterChar, DelimiterProcessor toAdd, Map<Character, DelimiterProcessor> delimiterProcessors) {
        DelimiterProcessor existing = delimiterProcessors.put(Character.valueOf(delimiterChar), toAdd);
        if (existing != null) {
            throw new IllegalArgumentException("Delimiter processor conflict with delimiter char '" + delimiterChar + "'");
        }
    }

    public void parse(String content, Node block) {
        Node node;
        this.reset(content.trim());
        this.block = block;
        while ((node = this.parseInline()) != null) {
            block.appendChild(node);
        }
        this.processDelimiters(null);
        InlineParserUtils.mergeChildTextNodes(block);
    }

    private void reset(String content) {
        this.input = content;
        this.index = 0;
        this.lastDelimiter = null;
        this.lastBracket = null;
    }

    @Nullable
    private Node parseInline() {
        char c = this.peek();
        if (c == '\u0000') {
            return null;
        }
        Node node = null;
        List<InlineProcessor> inlines = this.inlineProcessors.get(Character.valueOf(c));
        if (inlines != null) {
            InlineProcessor inline;
            int startIndex = this.index;
            Iterator<InlineProcessor> iterator = inlines.iterator();
            while (iterator.hasNext() && (node = (inline = iterator.next()).parse(this)) == null) {
                this.index = startIndex;
            }
        } else {
            DelimiterProcessor delimiterProcessor = this.delimiterProcessors.get(Character.valueOf(c));
            node = delimiterProcessor != null ? this.parseDelimiters(delimiterProcessor, c) : this.parseString();
        }
        if (node != null) {
            return node;
        }
        ++this.index;
        String literal = String.valueOf(c);
        return this.text(literal);
    }

    @Override
    @Nullable
    public String match(@NonNull Pattern re) {
        if (this.index >= this.input.length()) {
            return null;
        }
        Matcher matcher = re.matcher(this.input);
        matcher.region(this.index, this.input.length());
        boolean m = matcher.find();
        if (m) {
            this.index = matcher.end();
            return matcher.group();
        }
        return null;
    }

    @Override
    @NonNull
    public Text text(@NonNull String text) {
        return new Text(text);
    }

    @Override
    @NonNull
    public Text text(@NonNull String text, int beginIndex, int endIndex) {
        return new Text(text.substring(beginIndex, endIndex));
    }

    @Override
    @Nullable
    public LinkReferenceDefinition getLinkReferenceDefinition(String label) {
        return this.referencesEnabled ? this.inlineParserContext.getLinkReferenceDefinition(label) : null;
    }

    @Override
    public char peek() {
        if (this.index < this.input.length()) {
            return this.input.charAt(this.index);
        }
        return '\u0000';
    }

    @Override
    @NonNull
    public Node block() {
        return this.block;
    }

    @Override
    @NonNull
    public String input() {
        return this.input;
    }

    @Override
    public int index() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public Bracket lastBracket() {
        return this.lastBracket;
    }

    @Override
    public Delimiter lastDelimiter() {
        return this.lastDelimiter;
    }

    @Override
    public void addBracket(Bracket bracket) {
        if (this.lastBracket != null) {
            this.lastBracket.bracketAfter = true;
        }
        this.lastBracket = bracket;
    }

    @Override
    public void removeLastBracket() {
        this.lastBracket = this.lastBracket.previous;
    }

    @Override
    public void spnl() {
        this.match(SPNL);
    }

    @Nullable
    private Node parseDelimiters(DelimiterProcessor delimiterProcessor, char delimiterChar) {
        DelimiterData res = this.scanDelimiters(delimiterProcessor, delimiterChar);
        if (res == null) {
            return null;
        }
        int length = res.count;
        int startIndex = this.index;
        this.index += length;
        Text node = this.text(this.input, startIndex, this.index);
        this.lastDelimiter = new Delimiter(node, delimiterChar, res.canOpen, res.canClose, this.lastDelimiter);
        this.lastDelimiter.length = length;
        this.lastDelimiter.originalLength = length;
        if (this.lastDelimiter.previous != null) {
            this.lastDelimiter.previous.next = this.lastDelimiter;
        }
        return node;
    }

    @Override
    @Nullable
    public String parseLinkDestination() {
        int afterDest = LinkScanner.scanLinkDestination((CharSequence)this.input, (int)this.index);
        if (afterDest == -1) {
            return null;
        }
        String dest = this.peek() == '<' ? this.input.substring(this.index + 1, afterDest - 1) : this.input.substring(this.index, afterDest);
        this.index = afterDest;
        return Escaping.unescapeString((String)dest);
    }

    @Override
    @Nullable
    public String parseLinkTitle() {
        int afterTitle = LinkScanner.scanLinkTitle((CharSequence)this.input, (int)this.index);
        if (afterTitle == -1) {
            return null;
        }
        String title = this.input.substring(this.index + 1, afterTitle - 1);
        this.index = afterTitle;
        return Escaping.unescapeString((String)title);
    }

    @Override
    public int parseLinkLabel() {
        if (this.index >= this.input.length() || this.input.charAt(this.index) != '[') {
            return 0;
        }
        int startContent = this.index + 1;
        int endContent = LinkScanner.scanLinkLabelContent((CharSequence)this.input, (int)startContent);
        int contentLength = endContent - startContent;
        if (endContent == -1 || contentLength > 999) {
            return 0;
        }
        if (endContent >= this.input.length() || this.input.charAt(endContent) != ']') {
            return 0;
        }
        this.index = endContent + 1;
        return contentLength + 2;
    }

    private Node parseString() {
        int begin = this.index;
        int length = this.input.length();
        while (this.index != length && !this.specialCharacters.get(this.input.charAt(this.index))) {
            ++this.index;
        }
        if (begin != this.index) {
            return this.text(this.input, begin, this.index);
        }
        return null;
    }

    private DelimiterData scanDelimiters(DelimiterProcessor delimiterProcessor, char delimiterChar) {
        boolean canClose;
        boolean canOpen;
        boolean rightFlanking;
        int startIndex = this.index;
        int delimiterCount = 0;
        while (this.peek() == delimiterChar) {
            ++delimiterCount;
            ++this.index;
        }
        if (delimiterCount < delimiterProcessor.getMinLength()) {
            this.index = startIndex;
            return null;
        }
        String before = startIndex == 0 ? "\n" : this.input.substring(startIndex - 1, startIndex);
        char charAfter = this.peek();
        String after = charAfter == '\u0000' ? "\n" : String.valueOf(charAfter);
        boolean beforeIsPunctuation = PUNCTUATION.matcher(before).matches();
        boolean beforeIsWhitespace = UNICODE_WHITESPACE_CHAR.matcher(before).matches();
        boolean afterIsPunctuation = PUNCTUATION.matcher(after).matches();
        boolean afterIsWhitespace = UNICODE_WHITESPACE_CHAR.matcher(after).matches();
        boolean leftFlanking = !afterIsWhitespace && (!afterIsPunctuation || beforeIsWhitespace || beforeIsPunctuation);
        boolean bl = rightFlanking = !beforeIsWhitespace && (!beforeIsPunctuation || afterIsWhitespace || afterIsPunctuation);
        if (delimiterChar == '_') {
            canOpen = leftFlanking && (!rightFlanking || beforeIsPunctuation);
            canClose = rightFlanking && (!leftFlanking || afterIsPunctuation);
        } else {
            canOpen = leftFlanking && delimiterChar == delimiterProcessor.getOpeningCharacter();
            canClose = rightFlanking && delimiterChar == delimiterProcessor.getClosingCharacter();
        }
        this.index = startIndex;
        return new DelimiterData(delimiterCount, canOpen, canClose);
    }

    @Override
    public void processDelimiters(Delimiter stackBottom) {
        HashMap<Character, Delimiter> openersBottom = new HashMap<Character, Delimiter>();
        Delimiter closer = this.lastDelimiter;
        while (closer != null && closer.previous != stackBottom) {
            closer = closer.previous;
        }
        while (closer != null) {
            char delimiterChar = closer.delimiterChar;
            DelimiterProcessor delimiterProcessor = this.delimiterProcessors.get(Character.valueOf(delimiterChar));
            if (!closer.canClose || delimiterProcessor == null) {
                closer = closer.next;
                continue;
            }
            char openingDelimiterChar = delimiterProcessor.getOpeningCharacter();
            int useDelims = 0;
            boolean openerFound = false;
            boolean potentialOpenerFound = false;
            Delimiter opener = closer.previous;
            while (opener != null && opener != stackBottom && opener != openersBottom.get(Character.valueOf(delimiterChar))) {
                if (opener.canOpen && opener.delimiterChar == openingDelimiterChar) {
                    potentialOpenerFound = true;
                    useDelims = delimiterProcessor.getDelimiterUse((DelimiterRun)opener, (DelimiterRun)closer);
                    if (useDelims > 0) {
                        openerFound = true;
                        break;
                    }
                }
                opener = opener.previous;
            }
            if (!openerFound) {
                if (!potentialOpenerFound) {
                    openersBottom.put(Character.valueOf(delimiterChar), closer.previous);
                    if (!closer.canOpen) {
                        this.removeDelimiterKeepNode(closer);
                    }
                }
                closer = closer.next;
                continue;
            }
            Text openerNode = opener.node;
            Text closerNode = closer.node;
            opener.length -= useDelims;
            closer.length -= useDelims;
            openerNode.setLiteral(openerNode.getLiteral().substring(0, openerNode.getLiteral().length() - useDelims));
            closerNode.setLiteral(closerNode.getLiteral().substring(0, closerNode.getLiteral().length() - useDelims));
            this.removeDelimitersBetween(opener, closer);
            InlineParserUtils.mergeTextNodesBetweenExclusive((Node)openerNode, (Node)closerNode);
            delimiterProcessor.process(openerNode, closerNode, useDelims);
            if (opener.length == 0) {
                this.removeDelimiterAndNode(opener);
            }
            if (closer.length != 0) continue;
            Delimiter next = closer.next;
            this.removeDelimiterAndNode(closer);
            closer = next;
        }
        while (this.lastDelimiter != null && this.lastDelimiter != stackBottom) {
            this.removeDelimiterKeepNode(this.lastDelimiter);
        }
    }

    private void removeDelimitersBetween(Delimiter opener, Delimiter closer) {
        Delimiter delimiter = closer.previous;
        while (delimiter != null && delimiter != opener) {
            Delimiter previousDelimiter = delimiter.previous;
            this.removeDelimiterKeepNode(delimiter);
            delimiter = previousDelimiter;
        }
    }

    private void removeDelimiterAndNode(Delimiter delim) {
        Text node = delim.node;
        node.unlink();
        this.removeDelimiter(delim);
    }

    private void removeDelimiterKeepNode(Delimiter delim) {
        this.removeDelimiter(delim);
    }

    private void removeDelimiter(Delimiter delim) {
        if (delim.previous != null) {
            delim.previous.next = delim.next;
        }
        if (delim.next == null) {
            this.lastDelimiter = delim.previous;
        } else {
            delim.next.previous = delim.previous;
        }
    }

    static class FactoryBuilderImpl
    implements FactoryBuilder,
    FactoryBuilderNoDefaults {
        private final List<InlineProcessor> inlineProcessors = new ArrayList<InlineProcessor>(3);
        private final List<DelimiterProcessor> delimiterProcessors = new ArrayList<DelimiterProcessor>(3);
        private boolean referencesEnabled;

        FactoryBuilderImpl() {
        }

        @Override
        @NonNull
        public FactoryBuilder addInlineProcessor(@NonNull InlineProcessor processor) {
            this.inlineProcessors.add(processor);
            return this;
        }

        @Override
        @NonNull
        public FactoryBuilder addDelimiterProcessor(@NonNull DelimiterProcessor processor) {
            this.delimiterProcessors.add(processor);
            return this;
        }

        @Override
        @NonNull
        public FactoryBuilder referencesEnabled(boolean referencesEnabled) {
            this.referencesEnabled = referencesEnabled;
            return this;
        }

        @Override
        @NonNull
        public FactoryBuilder includeDefaults() {
            this.referencesEnabled = true;
            this.inlineProcessors.addAll(Arrays.asList(new AutolinkInlineProcessor(), new BackslashInlineProcessor(), new BackticksInlineProcessor(), new BangInlineProcessor(), new CloseBracketInlineProcessor(), new EntityInlineProcessor(), new HtmlInlineProcessor(), new NewLineInlineProcessor(), new OpenBracketInlineProcessor()));
            this.delimiterProcessors.addAll(Arrays.asList(new AsteriskDelimiterProcessor(), new UnderscoreDelimiterProcessor()));
            return this;
        }

        @Override
        @NonNull
        public FactoryBuilder excludeInlineProcessor(@NonNull Class<? extends InlineProcessor> type) {
            int size = this.inlineProcessors.size();
            for (int i = 0; i < size; ++i) {
                if (!type.equals(this.inlineProcessors.get(i).getClass())) continue;
                this.inlineProcessors.remove(i);
                break;
            }
            return this;
        }

        @Override
        @NonNull
        public FactoryBuilder excludeDelimiterProcessor(@NonNull Class<? extends DelimiterProcessor> type) {
            int size = this.delimiterProcessors.size();
            for (int i = 0; i < size; ++i) {
                if (!type.equals(this.delimiterProcessors.get(i).getClass())) continue;
                this.delimiterProcessors.remove(i);
                break;
            }
            return this;
        }

        @Override
        @NonNull
        public InlineParserFactory build() {
            return new InlineParserFactoryImpl(this.referencesEnabled, this.inlineProcessors, this.delimiterProcessors);
        }
    }

    public static interface FactoryBuilder {
        @NonNull
        public FactoryBuilder addInlineProcessor(@NonNull InlineProcessor var1);

        @NonNull
        public FactoryBuilder addDelimiterProcessor(@NonNull DelimiterProcessor var1);

        @NonNull
        public FactoryBuilder referencesEnabled(boolean var1);

        @NonNull
        public FactoryBuilder excludeInlineProcessor(@NonNull Class<? extends InlineProcessor> var1);

        @NonNull
        public FactoryBuilder excludeDelimiterProcessor(@NonNull Class<? extends DelimiterProcessor> var1);

        @NonNull
        public InlineParserFactory build();
    }

    private static class DelimiterData {
        final int count;
        final boolean canClose;
        final boolean canOpen;

        DelimiterData(int count, boolean canOpen, boolean canClose) {
            this.count = count;
            this.canOpen = canOpen;
            this.canClose = canClose;
        }
    }

    static class InlineParserFactoryImpl
    implements InlineParserFactory {
        private final boolean referencesEnabled;
        private final List<InlineProcessor> inlineProcessors;
        private final List<DelimiterProcessor> delimiterProcessors;

        InlineParserFactoryImpl(boolean referencesEnabled, @NonNull List<InlineProcessor> inlineProcessors, @NonNull List<DelimiterProcessor> delimiterProcessors) {
            this.referencesEnabled = referencesEnabled;
            this.inlineProcessors = inlineProcessors;
            this.delimiterProcessors = delimiterProcessors;
        }

        public InlineParser create(InlineParserContext inlineParserContext) {
            List<DelimiterProcessor> delimiterProcessors;
            int size;
            List customDelimiterProcessors = inlineParserContext.getCustomDelimiterProcessors();
            int n = size = customDelimiterProcessors != null ? customDelimiterProcessors.size() : 0;
            if (size > 0) {
                delimiterProcessors = new ArrayList<DelimiterProcessor>(size + this.delimiterProcessors.size());
                delimiterProcessors.addAll(this.delimiterProcessors);
                delimiterProcessors.addAll(customDelimiterProcessors);
            } else {
                delimiterProcessors = this.delimiterProcessors;
            }
            return new MarkwonInlineParser(inlineParserContext, this.referencesEnabled, this.inlineProcessors, delimiterProcessors);
        }
    }

    public static interface FactoryBuilderNoDefaults
    extends FactoryBuilder {
        @NonNull
        public FactoryBuilder includeDefaults();
    }
}

