/*
 * Decompiled with CFR 0.152.
 */
package me.nereo.multi_image_selector.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import java.util.ArrayList;
import java.util.List;
import me.nereo.multi_image_selector.R;
import me.nereo.multi_image_selector.bean.Folder;

public class FolderAdapter
extends BaseAdapter {
    private final RequestOptions mGlideOptions;
    private Context mContext;
    private LayoutInflater mInflater;
    private List<Folder> mFolders = new ArrayList<Folder>();
    int mImageSize;
    int lastSelected = 0;

    public FolderAdapter(Context context) {
        this.mContext = context;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mImageSize = this.mContext.getResources().getDimensionPixelOffset(R.dimen.mis_folder_cover_size);
        this.mGlideOptions = (RequestOptions)((RequestOptions)new RequestOptions().centerCrop()).placeholder(R.drawable.mis_default_error);
    }

    public void setData(List<Folder> folders) {
        if (folders != null && folders.size() > 0) {
            this.mFolders = folders;
        } else {
            this.mFolders.clear();
        }
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return this.mFolders.size() + 1;
    }

    public Folder getItem(int i) {
        if (i == 0) {
            return null;
        }
        return this.mFolders.get(i - 1);
    }

    public long getItemId(int i) {
        return i;
    }

    public View getView(int i, View view, ViewGroup viewGroup) {
        ViewHolder holder;
        if (view == null) {
            view = this.mInflater.inflate(R.layout.mis_list_item_folder, viewGroup, false);
            holder = new ViewHolder(view);
        } else {
            holder = (ViewHolder)view.getTag();
        }
        if (holder != null) {
            if (i == 0) {
                holder.name.setText(R.string.mis_folder_all);
                holder.path.setText((CharSequence)"/sdcard");
                holder.size.setText((CharSequence)String.format("%d%s", this.getTotalImageSize(), this.mContext.getResources().getString(R.string.mis_photo_unit)));
                if (this.mFolders.size() > 0) {
                    Folder f = this.mFolders.get(0);
                    if (f != null) {
                        Glide.with((Context)this.mContext).load(f.cover.path).apply((BaseRequestOptions)this.mGlideOptions).into(holder.cover);
                    } else {
                        holder.cover.setImageResource(R.drawable.mis_default_error);
                    }
                }
            } else {
                holder.bindData(this.getItem(i));
            }
            if (this.lastSelected == i) {
                holder.indicator.setVisibility(0);
            } else {
                holder.indicator.setVisibility(4);
            }
        }
        return view;
    }

    private int getTotalImageSize() {
        int result = 0;
        if (this.mFolders != null && this.mFolders.size() > 0) {
            for (Folder f : this.mFolders) {
                result += f.images.size();
            }
        }
        return result;
    }

    public void setSelectIndex(int i) {
        if (this.lastSelected == i) {
            return;
        }
        this.lastSelected = i;
        this.notifyDataSetChanged();
    }

    public int getSelectIndex() {
        return this.lastSelected;
    }

    class ViewHolder {
        ImageView cover;
        TextView name;
        TextView path;
        TextView size;
        ImageView indicator;

        ViewHolder(View view) {
            this.cover = (ImageView)view.findViewById(R.id.cover);
            this.name = (TextView)view.findViewById(R.id.name);
            this.path = (TextView)view.findViewById(R.id.path);
            this.size = (TextView)view.findViewById(R.id.size);
            this.indicator = (ImageView)view.findViewById(R.id.indicator);
            view.setTag((Object)this);
        }

        void bindData(Folder data) {
            if (data == null) {
                return;
            }
            this.name.setText((CharSequence)data.name);
            this.path.setText((CharSequence)data.path);
            if (data.images != null) {
                this.size.setText((CharSequence)String.format("%d%s", data.images.size(), FolderAdapter.this.mContext.getResources().getString(R.string.mis_photo_unit)));
            } else {
                this.size.setText((CharSequence)("*" + FolderAdapter.this.mContext.getResources().getString(R.string.mis_photo_unit)));
            }
            if (data.cover != null) {
                Glide.with((Context)FolderAdapter.this.mContext).load(data.cover.path).apply((BaseRequestOptions)FolderAdapter.this.mGlideOptions).into(this.cover);
            } else {
                this.cover.setImageResource(R.drawable.mis_default_error);
            }
        }
    }
}

