/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.ext.latex;

import androidx.annotation.Nullable;
import io.noties.markwon.ext.latex.JLatexMathNode;
import io.noties.markwon.ext.latex.LatexParseStyle;
import io.noties.markwon.inlineparser.InlineProcessor;
import java.util.regex.Pattern;
import org.commonmark.node.Node;

class JLatexMathInlineProcessor
extends InlineProcessor {
    @LatexParseStyle
    private final int parseStyle;
    private static final Pattern RE4StyleDollar = Pattern.compile("(?<!\\\\)(\\$+)(.+?)(?<!\\\\)\\1");
    private static final Pattern RE4StyleBracket = Pattern.compile("\\\\\\(([\\s\\S]+?)\\\\\\)|\\\\\\[([\\s\\S]+?)\\\\\\]");

    public JLatexMathInlineProcessor(@LatexParseStyle int parseStyle) {
        this.parseStyle = parseStyle;
    }

    public char specialCharacter() {
        return this.mapStyle2SpecialChar();
    }

    @Nullable
    protected Node parse() {
        String latex = this.match(this.mapStyle2Pattern());
        if (latex == null) {
            return null;
        }
        return new JLatexMathNode(latex.substring(2, latex.length() - 2));
    }

    private Pattern mapStyle2Pattern() {
        if (this.parseStyle == 1) {
            return RE4StyleDollar;
        }
        return RE4StyleBracket;
    }

    private char mapStyle2SpecialChar() {
        if (this.parseStyle == 2) {
            return '\\';
        }
        return '$';
    }
}

