/*
 * Decompiled with CFR 0.152.
 */
package com.codeages.eslivesdk;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.widget.PopupWindow;
import java.util.List;

public class KeyboardHeightProvider
extends PopupWindow
implements ViewTreeObserver.OnGlobalLayoutListener {
    private final Activity mActivity;
    private final View rootView;
    private HeightListener listener;
    private float density = 1.0f;

    public KeyboardHeightProvider(Activity activity) {
        super((Context)activity);
        this.mActivity = activity;
        this.rootView = new View((Context)activity);
        this.setContentView(this.rootView);
        this.rootView.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        this.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.setWidth(0);
        this.setHeight(-1);
        this.setSoftInputMode(16);
        this.setInputMethodMode(1);
        WindowManager wm = (WindowManager)this.mActivity.getSystemService("window");
        DisplayMetrics metrics = new DisplayMetrics();
        wm.getDefaultDisplay().getRealMetrics(metrics);
        this.density = metrics.density;
    }

    public KeyboardHeightProvider init() {
        if (this.mActivity != null && !this.mActivity.isFinishing() && !this.isShowing()) {
            View view = this.mActivity.getWindow().getDecorView();
            view.post(() -> this.showAtLocation(view, 0, 0, 0));
        }
        return this;
    }

    public KeyboardHeightProvider setHeightListener(HeightListener listener) {
        this.listener = listener;
        return this;
    }

    private int getScreenHeight() {
        Rect rect = new Rect();
        this.mActivity.getWindow().getDecorView().getWindowVisibleDisplayFrame(rect);
        return rect.height();
    }

    private List<Rect> getCutoutInfo() {
        if (Build.VERSION.SDK_INT >= 28) {
            try {
                WindowInsets windowInsets = this.mActivity.getWindow().getDecorView().getRootWindowInsets();
                if (windowInsets != null) {
                    return windowInsets.getDisplayCutout().getBoundingRects();
                }
                return null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void onGlobalLayout() {
        Rect rect = new Rect();
        this.rootView.getWindowVisibleDisplayFrame(rect);
        int keyboardHeight = this.getScreenHeight() - rect.height();
        if (this.listener != null) {
            this.listener.onHeightChanged(keyboardHeight, this.density, this.getCutoutInfo());
        }
    }

    public static interface HeightListener {
        public void onHeightChanged(int var1, float var2, List<Rect> var3);
    }
}

