/*
 * Decompiled with CFR 0.152.
 */
package com.codeages.eslivesdk;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Message;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.JsResult;
import android.webkit.PermissionRequest;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.widget.FrameLayout;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.widget.ContentLoadingProgressBar;
import com.blankj.utilcode.util.GsonUtils;
import com.codeages.eslivesdk.KeyboardHeightProvider;
import com.codeages.eslivesdk.LiveCloudHttpClient;
import com.codeages.eslivesdk.LiveCloudLogger;
import com.codeages.eslivesdk.LiveCloudUtils;
import com.codeages.eslivesdk.R;
import com.codeages.eslivesdk.ReplayWebView;
import com.codeages.eslivesdk.bean.CloudOptions;
import com.codeages.eslivesdk.server.HttpServerFactory;
import com.tencent.smtt.export.external.extension.interfaces.IX5WebChromeClientExtension;
import com.tencent.smtt.export.external.extension.interfaces.IX5WebViewExtension;
import com.tencent.smtt.export.external.interfaces.ConsoleMessage;
import com.tencent.smtt.export.external.interfaces.IX5WebViewBase;
import com.tencent.smtt.export.external.interfaces.JsPromptResult;
import com.tencent.smtt.export.external.interfaces.MediaAccessPermissionsCallback;
import com.tencent.smtt.export.external.interfaces.SslError;
import com.tencent.smtt.export.external.interfaces.SslErrorHandler;
import com.tencent.smtt.export.external.interfaces.WebResourceError;
import com.tencent.smtt.sdk.QbSdk;
import com.tencent.smtt.sdk.TbsListener;
import com.tencent.smtt.sdk.WebSettings;
import com.tencent.smtt.sdk.WebView;
import com.tencent.smtt.sdk.WebViewClient;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class LiveCloudActivity
extends AppCompatActivity {
    private static final String JSInterface = "LiveCloudBridge";
    protected WebView x5WebView;
    protected ReplayWebView nativeWebView;
    protected WebView x5DownloadView;
    protected String url = "";
    protected String logUrl = "";
    protected boolean isLive;
    private boolean disableX5;
    private boolean testUrl;
    private String optionsJsonStr;
    private boolean isVideoProtect;
    private String roomId = "0";
    private PermissionRequest nativeRequest;
    private MediaAccessPermissionsCallback permissionsCallback;
    private String permissionSite;
    private long permissionType;
    private final ActivityResultLauncher<String> requestPermissionLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.RequestPermission(), isGranted -> this.runOnUiThread(() -> {
        if (isGranted.booleanValue()) {
            if (this.nativeRequest != null) {
                this.nativeRequest.grant(this.nativeRequest.getResources());
            } else if (this.permissionsCallback != null) {
                this.permissionsCallback.invoke(this.permissionSite, this.permissionType, true);
            }
        } else if (this.nativeRequest != null) {
            this.nativeRequest.deny();
        } else if (this.permissionsCallback != null) {
            this.permissionsCallback.invoke(this.permissionSite, this.permissionType, false);
        }
    }));
    private final ActivityResultLauncher<String[]> requestMultiplePermissionLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.RequestMultiplePermissions(), isGranted -> this.runOnUiThread(() -> {
        if (isGranted.containsValue(false)) {
            if (this.nativeRequest != null) {
                this.nativeRequest.grant(this.nativeRequest.getResources());
            } else if (this.permissionsCallback != null) {
                this.permissionsCallback.invoke(this.permissionSite, this.permissionType, true);
            }
        }
    }));
    private Boolean connect = false;
    private Boolean isFullscreen = false;
    private Long enterTimestamp;
    private ContentLoadingProgressBar loadingView;
    private LiveCloudLogger logger;

    public static void launch(Context context, String url, boolean isLive, boolean isGrantedPermission, boolean isVideoProtect, String options) {
        Intent intent = new Intent(context, LiveCloudActivity.class);
        intent.putExtra("url", url);
        intent.putExtra("isLive", isLive);
        intent.putExtra("isGrantedPermission", isGrantedPermission);
        intent.putExtra("isVideoProtect", isVideoProtect);
        Map<String, Object> jwt = LiveCloudUtils.parseJwt(url);
        String roomId = String.valueOf(jwt.get("rid"));
        String accessKey = String.valueOf(jwt.get("kid"));
        intent.putExtra("roomId", roomId);
        if (options != null) {
            intent.putExtra("options", options);
        }
        LiveCloudActivity.start(context, isLive, intent, roomId, accessKey);
    }

    public static void launchOffline(Context context, String url, String roomId, String userId, String userName, boolean isVideoProtect) {
        Intent intent = new Intent(context, LiveCloudActivity.class);
        intent.putExtra("url", url);
        intent.putExtra("roomId", roomId);
        intent.putExtra("userId", userId);
        intent.putExtra("userName", userName);
        intent.putExtra("isVideoProtect", isVideoProtect);
        LiveCloudActivity.start(context, false, intent, roomId, "");
    }

    public static void start(Context context, boolean isLive, Intent intent, String roomId, String accessKey) {
        LiveCloudActivity.initTbs(context);
        if (intent.getBooleanExtra("testUrl", false)) {
            intent.putExtra("disableX5", intent.getBooleanExtra("disableX5", false));
            context.startActivity(intent);
            return;
        }
        if (intent.getBooleanExtra("disableX5", false)) {
            intent.putExtra("disableX5", true);
            context.startActivity(intent);
            return;
        }
        int x5Ver = QbSdk.getTbsVersion((Context)context);
        if (x5Ver > 0 && (!isLive && x5Ver < 45613 || isLive && x5Ver < 45000)) {
            intent.putExtra("disableX5", true);
            context.startActivity(intent);
            return;
        }
        String blacklistUrl = "https://livecloud-storage-sh.edusoho.net/metas/feature-config.json?ts=" + System.currentTimeMillis();
        LiveCloudHttpClient.get(blacklistUrl, 3000, (arg_0, arg_1) -> LiveCloudActivity.lambda$start$4(context, isLive, accessKey, intent, roomId, arg_0, arg_1));
    }

    private static void initTbs(Context context) {
        LiveCloudUtils.checkClearCaches(context);
        QbSdk.setDownloadWithoutWifi((boolean)true);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("use_speedy_classloader", true);
        map.put("use_dexloader_service", true);
        QbSdk.initTbsSettings(map);
        QbSdk.initX5Environment((Context)context, null);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        CloudOptions cloudOptions;
        super.onCreate(savedInstanceState);
        this.setTheme(R.style.LiveCloudTheme);
        this.setContentView(R.layout.activity_live_cloud);
        this.getWindow().setFormat(-3);
        this.getWindow().addFlags(128);
        this.isVideoProtect = this.getIntent().getBooleanExtra("isVideoProtect", false);
        this.url = this.getIntent().getStringExtra("url");
        this.isLive = this.getIntent().getBooleanExtra("isLive", false);
        this.optionsJsonStr = this.getIntent().getStringExtra("options");
        if (this.isVideoProtect) {
            this.getWindow().setFlags(8192, 8192);
        }
        if ((cloudOptions = (CloudOptions)GsonUtils.fromJson((String)this.optionsJsonStr, CloudOptions.class)) != null) {
            this.logUrl = cloudOptions.getLogUrl();
            this.disableX5 = cloudOptions.isDisableX5();
            this.testUrl = cloudOptions.isTestUrl();
        }
        this.roomId = this.getIntent().getStringExtra("roomId");
        this.loadingView = (ContentLoadingProgressBar)this.findViewById(R.id.loadingView);
        this.loadingView.show();
        String x5Downloaded = LiveCloudUtils.getX5Downloaded((Context)this);
        this.disableX5 = x5Downloaded != null && x5Downloaded.equals("true") ? false : !this.checkX5Downloaded();
        this.createWebView();
        this.loadRoomURL();
        this.enterTimestamp = System.currentTimeMillis();
        String userId = this.getIntent().getStringExtra("userId");
        String userName = this.getIntent().getStringExtra("userName");
        this.logger = null != userId ? LiveCloudLogger.getInstance(Long.parseLong(this.roomId), Long.parseLong(userId), userName, this.logUrl) : LiveCloudLogger.getInstance(this.logUrl, this.url);
        this.logger.info("SDK.Enter", new JSONObject(this.deviceInfoMap()).toString(), (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("device", LiveCloudActivity.this.deviceInfoMap());
            }
        });
        if (!this.getIntent().getBooleanExtra("isGrantedPermission", true)) {
            this.logger.debug("SDK.PermissionDeny", null, null);
        }
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        if (hasFocus) {
            new KeyboardHeightProvider((Activity)this).init().setHeightListener((height, density, cutout) -> {
                this.evalJs("liveCloudNativeEventCallback({name:'keyboardHeight', payload:{height:" + (int)((float)height / density) + "}})");
                if (cutout != null) {
                    ArrayList<String> rects = new ArrayList<String>();
                    for (Rect c : cutout) {
                        StringBuilder sb = new StringBuilder(32);
                        sb.append("[");
                        sb.append(c.left);
                        sb.append(",");
                        sb.append(c.top);
                        sb.append(",");
                        sb.append(c.right);
                        sb.append(",");
                        sb.append(c.bottom);
                        sb.append("]");
                        rects.add(sb.toString());
                    }
                    this.evalJs("liveCloudNativeEventCallback({name:'DisplayCutout', payload:{cutout:" + Arrays.deepToString(rects.toArray()) + "}})");
                }
                if (this.isFullscreen.booleanValue()) {
                    LiveCloudUtils.hideNavigationBar(this);
                }
            });
        }
    }

    public void onBackPressed() {
        if (this.connect.booleanValue()) {
            this.evalJs("liveCloudNativeEventCallback({name:'back'})");
        } else {
            if (this.enterDurationSecond() >= 10L) {
                int times = LiveCloudUtils.connectTimeout((Context)this, this.roomId);
                LiveCloudUtils.deleteCache((Context)this);
                this.logger.warn("SDK.ConnectTimeout", this.roomId + "=" + times, null);
            } else {
                this.logger.warn("SDK.NotConnect", null, null);
            }
            super.onBackPressed();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        FrameLayout rootLayout = (FrameLayout)this.findViewById(R.id.viewLayout);
        rootLayout.removeAllViews();
        if (this.x5WebView != null) {
            this.x5WebView.removeJavascriptInterface(JSInterface);
            this.x5WebView.setWebViewClient(null);
            this.x5WebView.setWebChromeClient(null);
            this.x5WebView.loadDataWithBaseURL(null, "", "text/html", "utf-8", null);
            this.x5WebView.clearHistory();
            this.x5WebView.destroy();
            this.x5WebView = null;
        }
        if (this.nativeWebView != null) {
            this.nativeWebView.removeJavascriptInterface(JSInterface);
            this.nativeWebView.setWebViewClient(null);
            this.nativeWebView.setWebChromeClient(null);
            this.nativeWebView.loadDataWithBaseURL(null, "", "text/html", "utf-8", null);
            this.nativeWebView.clearHistory();
            this.nativeWebView.destroy();
            this.nativeWebView = null;
        }
        if (this.x5DownloadView != null) {
            this.x5DownloadView.removeJavascriptInterface(JSInterface);
            this.x5DownloadView.setWebViewClient(null);
            this.x5DownloadView.setWebChromeClient(null);
            this.x5DownloadView.loadDataWithBaseURL(null, "", "text/html", "utf-8", null);
            this.x5DownloadView.clearHistory();
            this.x5DownloadView.destroy();
            this.x5DownloadView = null;
        }
        HttpServerFactory.getInstance().stop();
    }

    private void loadRoomURL() {
        if (this.testUrl) {
            if (this.x5WebView != null) {
                this.x5WebView.loadUrl(this.url);
            } else {
                this.nativeWebView.loadUrl(this.url);
            }
            return;
        }
        byte[] infoByte = new JSONObject(this.deviceInfoMap()).toString().getBytes(StandardCharsets.UTF_8);
        String base64String = Build.VERSION.SDK_INT >= 26 ? Base64.getUrlEncoder().withoutPadding().encodeToString(infoByte) : android.util.Base64.encodeToString((byte[])infoByte, (int)11);
        if (this.x5WebView != null) {
            this.x5WebView.loadUrl(this.url + "&device=" + base64String);
        } else {
            this.nativeWebView.loadUrl(this.url + "&device=" + base64String);
        }
    }

    private boolean checkX5Downloaded() {
        this.x5DownloadView = this.createX5WebView(true);
        FrameLayout rootLayout = (FrameLayout)this.findViewById(R.id.viewLayout);
        rootLayout.addView((View)this.x5DownloadView);
        this.x5DownloadView.setVisibility(4);
        this.x5DownloadView.loadUrl("https://debugtbs.qq.com");
        boolean loaded = this.x5DownloadView.getX5WebViewExtension() != null;
        LiveCloudUtils.setX5Downloaded((Context)this, loaded);
        if (loaded) {
            rootLayout.removeView((View)this.x5DownloadView);
            this.x5DownloadView.removeJavascriptInterface(JSInterface);
            this.x5DownloadView.setWebViewClient(null);
            this.x5DownloadView.setWebChromeClient(null);
            this.x5DownloadView.loadDataWithBaseURL(null, "", "text/html", "utf-8", null);
            this.x5DownloadView.clearHistory();
            this.x5DownloadView.destroy();
            this.x5DownloadView = null;
        }
        return loaded;
    }

    private void createWebView() {
        if (this.disableX5) {
            FrameLayout rootLayout = (FrameLayout)this.findViewById(R.id.viewLayout);
            if (this.x5DownloadView == null) {
                this.x5DownloadView = this.createX5WebView(true);
                rootLayout.addView((View)this.x5DownloadView);
                this.x5DownloadView.setVisibility(4);
                this.x5DownloadView.loadUrl("https://debugtbs.qq.com");
            }
            this.nativeWebView = new ReplayWebView((Context)this);
            this.nativeWebView.setWebViewClient(this.createNativeClient());
            this.nativeWebView.setWebChromeClient(this.createNativeChromeClient());
            this.nativeWebView.addJavascriptInterface((Object)this, JSInterface);
            rootLayout.addView((View)this.nativeWebView);
            return;
        }
        this.x5WebView = this.createX5WebView(false);
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "JavascriptInterface"})
    private WebView createX5WebView(boolean hide) {
        QbSdk.setTbsListener((TbsListener)new TbsListener(){

            public void onDownloadFinish(int errCode) {
                if (LiveCloudActivity.this.logger != null) {
                    LiveCloudActivity.this.logger.info("SDK.X5DownloadFinish", String.valueOf(errCode), null);
                }
            }

            public void onInstallFinish(int errCode) {
                if (LiveCloudActivity.this.logger != null) {
                    LiveCloudActivity.this.logger.info("SDK.X5Installed", String.valueOf(errCode), null);
                }
            }

            public void onDownloadProgress(int progress) {
                if (LiveCloudActivity.this.logger != null) {
                    LiveCloudActivity.this.logger.info("SDK.X5Downloading", String.valueOf(progress), null);
                }
            }
        });
        WebView webView = hide ? new WebView(this.getApplicationContext()) : (WebView)this.findViewById(R.id.xWebView);
        webView.setWebViewClient(this.createX5Client());
        webView.setWebChromeClient(this.createX5ChromeClient());
        webView.setWebChromeClientExtension(this.createX5Extension());
        webView.addJavascriptInterface((Object)this, JSInterface);
        WebSettings webSettings = webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setUseWideViewPort(true);
        webSettings.setLoadWithOverviewMode(true);
        webSettings.setCacheMode(-1);
        webSettings.setDefaultTextEncodingName("utf-8");
        webSettings.setDomStorageEnabled(true);
        webSettings.setMixedContentMode(0);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        webSettings.setMediaPlaybackRequiresUserGesture(false);
        return webView;
    }

    private WebViewClient createX5Client() {
        return new WebViewClient(){

            public void onPageFinished(WebView webView, String s) {
                super.onPageFinished(webView, s);
                LiveCloudActivity.this.loadingView.hide();
            }

            public void onReceivedError(WebView view, com.tencent.smtt.export.external.interfaces.WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                LiveCloudActivity.this.logger.debug("SDK.WebViewError", "WebResourceError: " + error.getErrorCode() + " " + error.getDescription(), null);
            }

            public void onReceivedSslError(WebView webView, SslErrorHandler sslErrorHandler, SslError sslError) {
                sslErrorHandler.proceed();
                LiveCloudActivity.this.logger.debug("SDK.WebViewError", "sslError: " + sslError.getPrimaryError() + " " + sslError.getUrl(), null);
            }

            public void onReceivedHttpError(WebView webView, com.tencent.smtt.export.external.interfaces.WebResourceRequest webResourceRequest, com.tencent.smtt.export.external.interfaces.WebResourceResponse webResourceResponse) {
                super.onReceivedHttpError(webView, webResourceRequest, webResourceResponse);
                LiveCloudActivity.this.logger.debug("SDK.WebViewError", "httpError: " + webResourceResponse.getStatusCode() + " " + webResourceResponse.getReasonPhrase(), null);
            }

            public void onReceivedError(WebView webView, int i, String s, String s1) {
                super.onReceivedError(webView, i, s, s1);
                LiveCloudActivity.this.logger.debug("SDK.WebViewError", "WebResourceError: " + i + " " + s + " " + s1, null);
            }
        };
    }

    private android.webkit.WebViewClient createNativeClient() {
        return new android.webkit.WebViewClient(){

            public void onPageFinished(android.webkit.WebView view, String url) {
                super.onPageFinished(view, url);
                LiveCloudActivity.this.loadingView.hide();
            }

            public void onReceivedError(android.webkit.WebView view, int errorCode, String description, String failingUrl) {
                super.onReceivedError(view, errorCode, description, failingUrl);
                LiveCloudActivity.this.logger.debug("SDK.WebViewError", "WebResourceError: " + errorCode + " " + description + " " + failingUrl, null);
            }

            public void onReceivedSslError(android.webkit.WebView view, android.webkit.SslErrorHandler handler, android.net.http.SslError error) {
                super.onReceivedSslError(view, handler, error);
                LiveCloudActivity.this.logger.debug("SDK.WebViewError", "sslError: " + error.getPrimaryError() + " " + error.getUrl(), null);
            }

            public void onReceivedHttpError(android.webkit.WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
                super.onReceivedHttpError(view, request, errorResponse);
                LiveCloudActivity.this.logger.debug("SDK.WebViewError", "httpError: " + errorResponse.getStatusCode() + " " + errorResponse.getReasonPhrase(), null);
            }
        };
    }

    private IX5WebChromeClientExtension createX5Extension() {
        return new IX5WebChromeClientExtension(){

            public Object getX5WebChromeClientInstance() {
                return null;
            }

            public View getVideoLoadingProgressView() {
                return null;
            }

            public void onAllMetaDataFinished(IX5WebViewExtension ix5WebViewExtension, HashMap<String, String> hashMap) {
            }

            public void onBackforwardFinished(int i) {
            }

            public void onHitTestResultForPluginFinished(IX5WebViewExtension ix5WebViewExtension, IX5WebViewBase.HitTestResult hitTestResult, Bundle bundle) {
            }

            public void onHitTestResultFinished(IX5WebViewExtension ix5WebViewExtension, IX5WebViewBase.HitTestResult hitTestResult) {
            }

            public void onPromptScaleSaved(IX5WebViewExtension ix5WebViewExtension) {
            }

            public void onPromptNotScalable(IX5WebViewExtension ix5WebViewExtension) {
            }

            public boolean onAddFavorite(IX5WebViewExtension ix5WebViewExtension, String s, String s1, com.tencent.smtt.export.external.interfaces.JsResult jsResult) {
                return false;
            }

            public void onPrepareX5ReadPageDataFinished(IX5WebViewExtension ix5WebViewExtension, HashMap<String, String> hashMap) {
            }

            public boolean onSavePassword(String s, String s1, String s2, boolean b, Message message) {
                return false;
            }

            public boolean onSavePassword(ValueCallback<String> valueCallback, String s, String s1, String s2, String s3, String s4, boolean b) {
                return false;
            }

            public void onX5ReadModeAvailableChecked(HashMap<String, String> hashMap) {
            }

            public void addFlashView(View view, ViewGroup.LayoutParams layoutParams) {
            }

            public void h5videoRequestFullScreen(String s) {
            }

            public void h5videoExitFullScreen(String s) {
            }

            public void requestFullScreenFlash() {
            }

            public void exitFullScreenFlash() {
            }

            public void jsRequestFullScreen() {
            }

            public void jsExitFullScreen() {
            }

            public void acquireWakeLock() {
            }

            public void releaseWakeLock() {
            }

            public Context getApplicationContex() {
                return null;
            }

            public boolean onPageNotResponding(Runnable runnable) {
                return false;
            }

            public Object onMiscCallBack(String s, Bundle bundle) {
                return null;
            }

            public void openFileChooser(ValueCallback<Uri[]> valueCallback, String s, String s1) {
            }

            public void onPrintPage() {
            }

            public void onColorModeChanged(long l) {
            }

            public boolean onPermissionRequest(String s, long l, MediaAccessPermissionsCallback mediaAccessPermissionsCallback) {
                LiveCloudActivity.this.permissionSite = s;
                LiveCloudActivity.this.permissionType = l;
                LiveCloudActivity.this.permissionsCallback = mediaAccessPermissionsCallback;
                if ((l & 4L) != 0L) {
                    LiveCloudActivity.this.requestPermissionLauncher.launch((Object)"android.permission.RECORD_AUDIO");
                } else if ((l & 2L) != 0L) {
                    LiveCloudActivity.this.requestPermissionLauncher.launch((Object)"android.permission.CAMERA");
                }
                return true;
            }
        };
    }

    private com.tencent.smtt.sdk.WebChromeClient createX5ChromeClient() {
        return new com.tencent.smtt.sdk.WebChromeClient(){

            public boolean onJsPrompt(WebView webView, String s, String s1, String s2, JsPromptResult jsPromptResult) {
                jsPromptResult.cancel();
                return true;
            }

            public boolean onJsConfirm(WebView webView, String s, String s1, com.tencent.smtt.export.external.interfaces.JsResult jsResult) {
                jsResult.cancel();
                return true;
            }

            public boolean onJsAlert(WebView webView, String s, String s1, com.tencent.smtt.export.external.interfaces.JsResult jsResult) {
                jsResult.cancel();
                return true;
            }

            public boolean onJsBeforeUnload(WebView webView, String s, String s1, com.tencent.smtt.export.external.interfaces.JsResult jsResult) {
                jsResult.cancel();
                return true;
            }

            public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
                return super.onConsoleMessage(consoleMessage);
            }
        };
    }

    private WebChromeClient createNativeChromeClient() {
        return new WebChromeClient(){

            public void onPermissionRequest(PermissionRequest request) {
                LiveCloudActivity.this.runOnUiThread(() -> {
                    LiveCloudActivity.this.nativeRequest = request;
                    String[] res = request.getResources();
                    if (res.length > 1) {
                        LiveCloudActivity.this.requestMultiplePermissionLauncher.launch((Object)request.getResources());
                    } else {
                        String[] stringArray = request.getResources();
                        int n = stringArray.length;
                        block8: for (int i = 0; i < n; ++i) {
                            String permission2;
                            switch (permission2 = stringArray[i]) {
                                case "android.webkit.resource.AUDIO_CAPTURE": {
                                    LiveCloudActivity.this.requestPermissionLauncher.launch((Object)"android.permission.RECORD_AUDIO");
                                    continue block8;
                                }
                                case "android.webkit.resource.VIDEO_CAPTURE": {
                                    LiveCloudActivity.this.requestPermissionLauncher.launch((Object)"android.permission.CAMERA");
                                }
                            }
                        }
                    }
                });
            }

            public boolean onJsPrompt(android.webkit.WebView view, String url, String message, String defaultValue, android.webkit.JsPromptResult result) {
                result.cancel();
                return true;
            }

            public boolean onJsConfirm(android.webkit.WebView view, String url, String message, JsResult result) {
                result.cancel();
                return true;
            }

            public boolean onJsAlert(android.webkit.WebView view, String url, String message, JsResult result) {
                result.cancel();
                return true;
            }

            public boolean onJsBeforeUnload(android.webkit.WebView view, String url, String message, JsResult result) {
                result.cancel();
                return true;
            }
        };
    }

    @JavascriptInterface
    public void connect() {
        this.connect = true;
        LiveCloudUtils.clearTimeoutTimes((Context)this, this.roomId);
        this.runOnUiThread(() -> this.evalJs("liveCloudNativeEventCallback({name:'options', payload:" + this.optionsJsonStr + "})"));
    }

    @JavascriptInterface
    public void fullscreen() {
        this.runOnUiThread(() -> {
            this.isFullscreen = this.isFullscreen == false;
            if (this.isFullscreen.booleanValue()) {
                this.setWindowFullScreen();
            } else {
                this.setWindowShrinkScreen();
            }
        });
    }

    @JavascriptInterface
    public String getDeviceInfo() {
        Map<String, Object> info = LiveCloudUtils.deviceInfo((Context)this);
        return new JSONObject(info).toString();
    }

    @JavascriptInterface
    public void exit() {
        this.runOnUiThread(() -> ((LiveCloudActivity)this).finish());
    }

    private Map<String, Object> deviceInfoMap() {
        HashMap<String, Object> info = new HashMap<String, Object>(LiveCloudUtils.deviceInfo((Context)this));
        info.put("x5Version", QbSdk.getTbsVersion((Context)this));
        info.put("disableX5", this.disableX5);
        info.put("x5Loaded", this.x5WebView != null && this.x5WebView.getX5WebViewExtension() != null);
        info.put("storagePermission", this.getIntent().getBooleanExtra("isGrantedPermission", false));
        return info;
    }

    private void setWindowFullScreen() {
        this.setRequestedOrientation(0);
        LiveCloudUtils.fullScreen(this, true);
    }

    private void setWindowShrinkScreen() {
        this.setRequestedOrientation(1);
        LiveCloudUtils.fullScreen(this, false);
    }

    private long enterDurationSecond() {
        return (System.currentTimeMillis() - this.enterTimestamp) / 1000L;
    }

    private void evalJs(String js) {
        if (this.x5WebView != null) {
            this.x5WebView.evaluateJavascript(js, null);
        } else if (this.nativeWebView != null) {
            this.nativeWebView.evaluateJavascript(js, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ void lambda$start$4(Context context, boolean isLive, String accessKey, Intent intent, String roomId, String successMsg, String errorMsg) {
        disableX5 = false;
        if (successMsg != null) {
            version = String.valueOf(QbSdk.getTbsVersion((Context)context));
            try {
                msg = new JSONObject(successMsg);
                if (!isLive) {
                    if (!msg.getBoolean("replayX5")) {
                        disableX5 = true;
                    } else {
                        schoolList = msg.getJSONArray("replayX5SchoolBlacklist");
                        for (i = 0; i < schoolList.length(); ++i) {
                            if (!schoolList.getString(i).equals(accessKey)) continue;
                            disableX5 = true;
                            break;
                        }
                    }
                }
                if (disableX5) ** GOTO lbl30
                versionList = msg.getJSONArray(isLive != false ? "liveX5VersionBlacklist" : "replayX5VersionBlacklist");
                for (i = 0; i < versionList.length(); ++i) {
                    if (!versionList.getString(i).equals(version)) continue;
                    disableX5 = true;
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
                intent.putExtra("disableX5", true);
                context.startActivity(intent);
                return;
            }
        } else if (!isLive) {
            disableX5 = true;
        }
lbl30:
        // 6 sources

        if (disableX5) {
            intent.putExtra("disableX5", true);
            context.startActivity(intent);
            return;
        }
        if (LiveCloudUtils.getTimeoutTimes(context, roomId) > 2) {
            disableX5 = true;
            LiveCloudUtils.disableX5(context, roomId);
        }
        intent.putExtra("disableX5", disableX5);
        context.startActivity(intent);
    }
}

