/*
 * Decompiled with CFR 0.152.
 */
package com.codeages.eslivesdk.cache;

import com.codeages.eslivesdk.cache.CacheServer;
import com.codeages.eslivesdk.cache.FileHandler;
import java.util.concurrent.atomic.AtomicInteger;

public class CacheServerFactory {
    private static CacheServerFactory INSTANCE;
    private final AtomicInteger mRefCount = new AtomicInteger(0);
    private CacheServer mCacheServer;

    private CacheServerFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CacheServerFactory getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<CacheServerFactory> clazz = CacheServerFactory.class;
        synchronized (CacheServerFactory.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new CacheServerFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void start(int roomId) {
        this.mRefCount.incrementAndGet();
        this.mCacheServer = this.createServer(roomId);
        this.mCacheServer.start();
    }

    public void stop() {
        this.mRefCount.decrementAndGet();
        if (this.mRefCount.get() <= 0) {
            if (this.mCacheServer != null) {
                this.mCacheServer.close();
            }
            this.mRefCount.set(0);
        }
    }

    public void resume() {
        if (this.mCacheServer != null) {
            this.mCacheServer.keepOn();
        }
    }

    public void pause() {
        if (this.mCacheServer != null) {
            this.mCacheServer.pause();
        }
    }

    private CacheServer createServer(int roomId) {
        return new CacheServer.Builder().setFilter("*").setHandler(new FileHandler(roomId)).build();
    }
}

