/*
 * Decompiled with CFR 0.152.
 */
package com.codeages.eslivesdk.http;

import java.io.IOException;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public class RequestInterceptor
implements Interceptor {
    private Map<String, String> mHeaderMaps;

    public RequestInterceptor(Map<String, String> headerMaps) {
        this.mHeaderMaps = headerMaps;
    }

    @NotNull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request.Builder builder = chain.request().newBuilder();
        if (this.mHeaderMaps != null && this.mHeaderMaps.size() > 0) {
            for (Map.Entry<String, String> entry : this.mHeaderMaps.entrySet()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return chain.proceed(builder.build());
    }
}

