package com.edusoho.aiassistant.entity;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.blankj.utilcode.util.StringUtils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

//{
//  "signal": "message.unread",
//  "data": {
//    "total": 5,  //总未读数量
//    "counters": [
//      {"domainId": "d1", "threadId": "xxxx", "count": 2},
//      {"domainId": "d2", "threadId": "xxxx", "count": 3}
//    ]
//  }
//}
public class AISocketMessage {
    private int                     total;
    private List<SocketMessageData> counters;

    public int getTotal() {
        return total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public List<SocketMessageData> getCounters() {
        if (counters == null) counters = new ArrayList<>();
        return counters;
    }

    public void setCounters(List<SocketMessageData> counters) {
        this.counters = counters;
    }

    @Nullable
    public SocketMessageData getMessageDataByDomainId(String domainId) {
        if (counters != null && !counters.isEmpty()) {
            for (SocketMessageData messageData : counters) {
                if (StringUtils.equals(domainId, messageData.getDomainId())) {
                    return messageData;
                }
            }
        }
        return null;
    }

    public void removeRead(String domainId) {
        Iterator<SocketMessageData> iterator = counters.iterator();
        while (iterator.hasNext()) {
            AISocketMessage.SocketMessageData data = iterator.next();
            if (StringUtils.equals(data.getDomainId(), domainId)) {
                iterator.remove();
            }
        }
    }

    public static class SocketMessageData {
        private String domainId;
        private String threadId;
        private int    count;

        public String getDomainId() {
            return domainId;
        }

        public void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        public String getThreadId() {
            return threadId;
        }

        public void setThreadId(String threadId) {
            this.threadId = threadId;
        }

        public int getCount() {
            return count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        @NonNull
        @Override
        public String toString() {
            return "SocketMessageData{" +
                    ", threadId='" + (threadId != null ? threadId : "null") + '\'' +
                    ", domainId='" + (domainId != null ? domainId : "null") + '\'' +
                    '}';
        }

    }

    @NonNull
    @Override
    public String toString() {
        return "AISocketMessage{" +
                "total=" + total +
                ", messages=" + (counters != null ? counters : "null") +
                '}';
    }
}
