package com.edusoho.aiassistant.entity;

import com.blankj.utilcode.util.GsonUtils;
import com.edusoho.aiassistant.AIConst;
import com.edusoho.aiassistant.AISDKParams;

import java.io.Serializable;
import java.util.List;

import okhttp3.RequestBody;

public class WorkflowRequest implements Serializable {
    private String workflow;
    private Input  inputs;

    public String getWorkflow() {
        return workflow;
    }

    public void setWorkflow(String workflow) {
        this.workflow = workflow;
    }

    public Input getInputs() {
        return inputs;
    }

    public void setInputs(Input inputs) {
        this.inputs = inputs;
    }

    public void setWorkflow(String workflow, int courseId) {
        this.workflow = workflow;
        if (inputs == null) {
            inputs = new Input();
        }
        inputs.setCourseId(courseId);
    }

    public void setGeneratedPlanConfig(String workflow, int courseId, String startDate, String endDate, String dailyLearnDuration, List<Integer> weekDays) {
        setWorkflow(workflow, courseId);
        inputs.setWorkerUrl(AISDKParams.SCHOOL_URL + "/" + AISDKParams.AGENT_WORKER + "?token=" + AISDKParams.AI_AGENT_TOKEN);
        inputs.setStartDate(startDate);
        inputs.setEndDate(endDate);
        inputs.setDailyLearnDuration(dailyLearnDuration);
        inputs.setWeekDays(weekDays);
    }

    public void setQuestionAnalysis(String workflow, String domainId, String question) {
        this.workflow = workflow;
        if (inputs == null) inputs = new Input();
        inputs.setDomainId(domainId);
        inputs.setQuestion(question);
    }

    public void setPreviewPlan(String workflow, int courseId, String startDate, String endDate, List<Integer> weekDays, String dailyLearnDuration) {
        setWorkflow(workflow, courseId);
//        inputs.setWorkerUrl(AISDKParams.SCHOOL_URL + "/" + AISDKParams.AGENT_WORKER + "?token=" + AISDKParams.AI_AGENT_TOKEN);
        inputs.setStartDate(startDate);
        inputs.setEndDate(endDate);
        inputs.setWeekDays(weekDays);
        inputs.setDailyLearnDuration(dailyLearnDuration);
    }

    public static class Input implements Serializable {
        private int           courseId;
        private String        domainId;
        private String        workerUrl;
        private String        startDate;
        private String        endDate;
        private List<Integer> weekDays;
        private String        question;
        private String        dailyLearnDuration;

        public int getCourseId() {
            return courseId;
        }

        public void setCourseId(int courseId) {
            this.courseId = courseId;
        }

        public String getDomainId() {
            return domainId;
        }

        public void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        public String getWorkerUrl() {
            return workerUrl;
        }

        public void setWorkerUrl(String workerUrl) {
            this.workerUrl = workerUrl;
        }

        public String getStartDate() {
            return startDate;
        }

        public void setStartDate(String startDate) {
            this.startDate = startDate;
        }

        public String getEndDate() {
            return endDate;
        }

        public void setEndDate(String endDate) {
            this.endDate = endDate;
        }

        public List<Integer> getWeekDays() {
            return weekDays;
        }

        public void setWeekDays(List<Integer> weekDays) {
            this.weekDays = weekDays;
        }

        public String getQuestion() {
            return question;
        }

        public void setQuestion(String question) {
            this.question = question;
        }

        public String getDailyLearnDuration() {
            return dailyLearnDuration;
        }

        public void setDailyLearnDuration(String dailyLearnDuration) {
            this.dailyLearnDuration = dailyLearnDuration;
        }
    }

    public RequestBody toRequestBody() {
        String json = GsonUtils.toJson(this);
        return RequestBody.create(json, AIConst.JSON);
    }
}
