package com.edusoho.aiassistant.http;

import com.blankj.utilcode.util.GsonUtils;
import com.blankj.utilcode.util.StringUtils;
import com.edusoho.aiassistant.AIConst;
import com.edusoho.aiassistant.AISDKParams;
import com.edusoho.aiassistant.entity.AIFeedback;
import com.edusoho.aiassistant.entity.AIMessage;
import com.edusoho.aiassistant.entity.AudioTokenData;
import com.edusoho.aiassistant.entity.WorkflowRequest;
import com.edusoho.aiassistant.entity.WorkflowResult;
import com.edusoho.aiassistant.util.AIMessageCache;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import okhttp3.RequestBody;
import rx.Observable;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public class APIRequest {

    /**
     * 获取 Message list
     */
    public Observable<List<AIMessage>> getMessageList(String domainId) {
        //如果本地没有，获取网络
        if (AIMessageCache.get(domainId).isEmpty()) {
            Map<String, String> params = new HashMap<>();
            params.put("domainId", domainId);
            params.put("limit", String.valueOf(AIConst.DEFAULT_LIMIT));
            return HttpClient.getInstance()
                    .create(AIServiceAPI.class)
                    .getMessageList(params)
                    .doOnNext(new Action1<List<AIMessage>>() {
                        @Override
                        public void call(List<AIMessage> aiMessages) {
                            AIMessageCache.push(domainId, aiMessages);
                        }
                    })
                    .subscribeOn(Schedulers.io())
                    .observeOn(AndroidSchedulers.mainThread());
        } else {
            return Observable.just(AIMessageCache.get(domainId));
        }
    }

    public Observable<List<AIMessage>> getMessageListFromNet(String domainId) {
        Map<String, String> params = new HashMap<>();
        params.put("domainId", domainId);
        params.put("limit", String.valueOf(AIConst.DEFAULT_LIMIT));
        return HttpClient.getInstance()
                .create(AIServiceAPI.class)
                .getMessageList(params)
                .doOnNext(new Action1<List<AIMessage>>() {
                    @Override
                    public void call(List<AIMessage> aiMessages) {
                        AIMessageCache.push(domainId, aiMessages);
                    }
                })
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread());
    }

    public Observable<List<AIMessage>> getMessageListByIds(String domainId, String unreadMessages) {
        return HttpClient.getInstance()
                .create(AIServiceAPI.class)
                .getMessageListByIds(domainId, unreadMessages)
//                .flatMap(new Func1<List<AIMessage>, Observable<List<AIMessage>>>() {
//                    @Override
//                    public Observable<List<AIMessage>> call(List<AIMessage> list) {
//                        AIMessageCache.add(domainId, list);
//                        return Observable.just(AIMessageCache.get(domainId));
//                    }
//                })
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread());
    }

    public Observable<List<AIMessage>> getPullUnread(String domainId) {
        return HttpClient.getInstance()
                .create(AIServiceAPI.class)
                .getPullUnread(domainId)
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread());
    }

    /**
     * 增量获取 Message list
     */
    public Observable<List<AIMessage>> getMessageListDelta(String domainId, String beforeMessageId, String afterMessageId) {
        Map<String, String> params = new HashMap<>();
        params.put("domainId", domainId);
        if (!StringUtils.isEmpty(beforeMessageId)) {
            params.put("before", beforeMessageId);
        }
        if (!StringUtils.isEmpty(afterMessageId)) {
            params.put("after", afterMessageId);
        }
        params.put("limit", String.valueOf(AIConst.DEFAULT_LIMIT));
        return HttpClient.getInstance()
                .create(AIServiceAPI.class)
                .getMessageList(params)
                .doOnNext(new Action1<List<AIMessage>>() {
                    @Override
                    public void call(List<AIMessage> aiMessages) {
                        if (!StringUtils.isEmpty(beforeMessageId)) {
                            AIMessageCache.push(domainId, aiMessages);
                        }
                    }
                })
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread());
    }

    public Observable<Boolean> feedback(AIFeedback feedback) {
        return HttpClient.getInstance()
                .create(AIServiceAPI.class)
                .feedback(feedback.toRequestBody())
                .flatMap(new Func1<Map<String, Boolean>, Observable<Boolean>>() {
                    @Override
                    public Observable<Boolean> call(Map<String, Boolean> map) {
                        if (map != null && map.containsKey("ok")) {
                            return Observable.just(map.get("ok"));
                        } else {
                            return Observable.just(false);
                        }
                    }
                })
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread());
    }

    public Observable<WorkflowResult> getWorkflow(WorkflowRequest workflowRequest) {
        return HttpClient.getInstance()
                .create(AIServiceAPI.class)
                .getWorkflowRequest(AISDKParams.SCHOOL_URL + "/" + AISDKParams.AGENT_WORKER, workflowRequest.toRequestBody())
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread());
    }

    public Observable<AudioTokenData> getAsrToken() {
        return HttpClient.getInstance()
                .create(AIServiceAPI.class)
                .getAsrToken()
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread());
    }
}
