package com.edusoho.aiassistant.http;

import androidx.annotation.NonNull;

import com.blankj.utilcode.util.StringUtils;
import com.edusoho.aiassistant.AIConst;
import com.edusoho.aiassistant.AISDKParams;

import java.io.IOException;

import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class RequestInterceptor implements Interceptor {

    private static final String HEADER_LOGIN = "isLogin";

    @NonNull
    @Override
    public Response intercept(@NonNull Chain chain) throws IOException {
        Request.Builder request = chain.request().newBuilder();
        String isLogin = chain.request().header(HEADER_LOGIN);
        if (StringUtils.equals(isLogin, "1")) {
            request.removeHeader(HEADER_LOGIN);
            request.header("Authorization", "Bearer " + AISDKParams.AI_AGENT_TOKEN);
        }
        return chain.proceed(request.build());
    }
}
