package com.edusoho.aiassistant.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.widget.LinearLayout;

import androidx.annotation.Nullable;

import com.edusoho.aiassistant.R;
import com.edusoho.aiassistant.databinding.ItemFeedbackBinding;

public class AIFeedbackItem extends LinearLayout {
    private ItemFeedbackBinding binding;

    public AIFeedbackItem(Context context) {
        super(context);
        init(context, null);
    }

    public AIFeedbackItem(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init(context, attrs);
    }

    public AIFeedbackItem(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context, attrs);
    }

    public AIFeedbackItem(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        init(context, attrs);
    }

    private void init(Context context, @Nullable AttributeSet attrs) {
        setOrientation(LinearLayout.VERTICAL);
        setGravity(Gravity.CENTER_HORIZONTAL);
        binding = ItemFeedbackBinding.inflate(LayoutInflater.from(context), this);
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.AIFeedbackItem);
            try {
                int resIcon = typedArray.getResourceId(R.styleable.AIFeedbackItem_feedback_icon, R.drawable.ai_feedback_good);
                binding.ivFace.setImageResource(resIcon);
                String text = typedArray.getString(R.styleable.AIFeedbackItem_feedback_text);
                binding.tvItemText.setText(text);
            } finally {
                typedArray.recycle();
            }
        }
    }
}
