package com.edusoho.aiassistant.widget;

import android.content.Context;
import android.util.AttributeSet;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatTextView;

import com.blankj.utilcode.util.ColorUtils;
import com.edusoho.aiassistant.R;

public class ScheduleCreateTextView extends AppCompatTextView {
    public ScheduleCreateTextView(@NonNull Context context) {
        super(context);
        init();
    }

    public ScheduleCreateTextView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public ScheduleCreateTextView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        setTextColor(enabled ? ColorUtils.getColor(android.R.color.white) : ColorUtils.getColor(R.color.color_C0C0C2));
    }

    private void init() {
        setTextColor(isEnabled() ? ColorUtils.getColor(android.R.color.white) : ColorUtils.getColor(R.color.color_C0C0C2));
    }
}
