/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.aiassistant.adpter;

import android.content.Context;
import android.os.Build;
import android.text.Spanned;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.LineHeightSpan;
import android.util.Log;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.recyclerview.widget.LinearLayoutManager;
import com.blankj.utilcode.util.ConvertUtils;
import com.blankj.utilcode.util.LogUtils;
import com.blankj.utilcode.util.StringUtils;
import com.bumptech.glide.Glide;
import com.chad.library.adapter.base.BaseMultiItemQuickAdapter;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.module.BaseLoadMoreModule;
import com.chad.library.adapter.base.module.BaseUpFetchModule;
import com.chad.library.adapter.base.module.LoadMoreModule;
import com.chad.library.adapter.base.module.UpFetchModule;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.edusoho.aiassistant.R;
import com.edusoho.aiassistant.entity.AIMessage;
import com.edusoho.aiassistant.util.KLatexNormalizer;
import com.edusoho.aiassistant.util.MarkwonUtil;
import com.edusoho.aiassistant.widget.AIRatePanel;
import com.edusoho.aiassistant.widget.BottomMarginSpan;
import io.noties.markwon.AbstractMarkwonPlugin;
import io.noties.markwon.Markwon;
import io.noties.markwon.MarkwonConfiguration;
import io.noties.markwon.MarkwonPlugin;
import io.noties.markwon.MarkwonSpansFactory;
import io.noties.markwon.RenderProps;
import io.noties.markwon.SpanFactory;
import io.noties.markwon.core.CoreProps;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.commonmark.node.Heading;

public class AIMessageAdapter
extends BaseMultiItemQuickAdapter<AIMessage, BaseViewHolder>
implements LoadMoreModule,
UpFetchModule {
    private static final String TAG = "AIMessageAdapter";
    private Markwon markwonStudyPlan;
    private Markwon markwonNormalStyle;

    public AIMessageAdapter() {
        this.addItemType(0, R.layout.item_loading_message);
        this.addItemType(1, R.layout.item_received_text_message);
        this.addItemType(2, R.layout.item_received_answer_card_message);
        this.addItemType(3, R.layout.item_received_push_card_message);
        this.addItemType(4, R.layout.item_send_message);
    }

    public void addSendMessage(AIMessage message) {
        this.addData(message);
    }

    public void addData(@NonNull AIMessage data) {
        super.addData((Object)data);
        LinearLayoutManager layoutManager = (LinearLayoutManager)this.getRecyclerView().getLayoutManager();
        if (layoutManager != null) {
            layoutManager.setStackFromEnd(true);
            layoutManager.scrollToPositionWithOffset(this.getData().size() - 1, 0);
        }
    }

    public void addReceivedMessage(AIMessage message) {
        block8: {
            block11: {
                block10: {
                    block9: {
                        block7: {
                            if (!StringUtils.equals((CharSequence)message.getEvent(), (CharSequence)"message.loading")) break block7;
                            this.addData(message);
                            break block8;
                        }
                        if (!StringUtils.equals((CharSequence)message.getEvent(), (CharSequence)"chat.started")) break block9;
                        for (int i = this.getData().size() - 1; i >= 0; --i) {
                            AIMessage searchMessage = (AIMessage)this.getData().get(i);
                            if (!StringUtils.equals((CharSequence)searchMessage.getEvent(), (CharSequence)"message.loading")) continue;
                            searchMessage.setId(message.getId());
                            searchMessage.setChatId(message.getChatId());
                            searchMessage.setEvent("chat.started");
                            this.notifyItemChanged(i);
                            return;
                        }
                        break block8;
                    }
                    if (!StringUtils.equals((CharSequence)message.getEvent(), (CharSequence)"message.delta")) break block10;
                    for (int i = this.getData().size() - 1; i >= 0; --i) {
                        AIMessage searchMessage = (AIMessage)this.getData().get(i);
                        if (StringUtils.equals((CharSequence)searchMessage.getEvent(), (CharSequence)"chat.started") && StringUtils.equals((CharSequence)searchMessage.getId(), (CharSequence)message.getChatId())) {
                            searchMessage.copyFromDeltaMessage(message);
                            Log.i((String)TAG, (String)"MESSAGE_DELTA - CHAT_CREATED:");
                            this.notifyItemChanged(i, searchMessage);
                            return;
                        }
                        if (!StringUtils.equals((CharSequence)searchMessage.getId(), (CharSequence)message.getId())) continue;
                        searchMessage.copyFromDeltaMessage(message);
                        Log.i((String)TAG, (String)"MESSAGE_DELTA : getId == getId");
                        this.notifyItemChanged(i, searchMessage);
                        return;
                    }
                    this.addData(message);
                    break block8;
                }
                if (!StringUtils.equals((CharSequence)message.getEvent(), (CharSequence)"message.completed")) break block11;
                for (int i = this.getData().size() - 1; i >= 0; --i) {
                    AIMessage searchMessage = (AIMessage)this.getData().get(i);
                    if (StringUtils.equals((CharSequence)searchMessage.getEvent(), (CharSequence)"chat.started") && StringUtils.equals((CharSequence)searchMessage.getId(), (CharSequence)message.getChatId())) {
                        searchMessage.copyFromCompletedMessage(message);
                        this.notifyItemChanged(i, searchMessage);
                        return;
                    }
                    if (!StringUtils.equals((CharSequence)searchMessage.getId(), (CharSequence)message.getId())) continue;
                    searchMessage.copyFromCompletedMessage(message);
                    Log.i((String)TAG, (String)"MESSAGE_DELTA : getId == getId");
                    this.notifyItemChanged(i, searchMessage);
                    return;
                }
                this.addData(message);
                break block8;
            }
            if (!StringUtils.equals((CharSequence)message.getEvent(), (CharSequence)"chat.failed")) break block8;
            for (int i = this.getData().size() - 1; i >= 0; --i) {
                AIMessage searchMessage = (AIMessage)this.getData().get(i);
                if (StringUtils.equals((CharSequence)searchMessage.getEvent(), (CharSequence)"chat.started") && StringUtils.equals((CharSequence)searchMessage.getId(), (CharSequence)message.getChatId())) {
                    message.setContent("\n\n\u670d\u52a1\u5668\u751f\u6210\u6d88\u606f\u5931\u8d25");
                    searchMessage.copyFromDeltaMessage(message);
                    return;
                }
                if (!StringUtils.equals((CharSequence)searchMessage.getEvent(), (CharSequence)"message.delta") || !StringUtils.equals((CharSequence)searchMessage.getId(), (CharSequence)message.getId()) || !StringUtils.equals((CharSequence)searchMessage.getChatId(), (CharSequence)message.getChatId())) continue;
                message.setContent("\n\n\u670d\u52a1\u5668\u751f\u6210\u6d88\u606f\u5931\u8d25");
                searchMessage.copyFromDeltaMessage(message);
                return;
            }
        }
    }

    public void stopAnswer() {
        for (int i = this.getData().size() - 1; i >= 0; --i) {
            AIMessage targetMessage = (AIMessage)this.getData().get(i);
            if (!StringUtils.equals((CharSequence)targetMessage.getRole(), (CharSequence)"assistant") || !StringUtils.equals((CharSequence)targetMessage.getEvent(), (CharSequence)"message.loading") && !StringUtils.equals((CharSequence)targetMessage.getEvent(), (CharSequence)"chat.started") && !StringUtils.equals((CharSequence)targetMessage.getEvent(), (CharSequence)"message.delta")) continue;
            if (StringUtils.isEmpty((CharSequence)targetMessage.getContentType())) {
                targetMessage.setContentType("text");
            }
            targetMessage.setEvent("message.completed");
            targetMessage.setContent(targetMessage.getTextContent() + "\n\n**\u5df2\u505c\u6b62\u56de\u7b54**");
            this.notifyItemChanged(i, targetMessage);
            break;
        }
    }

    public void updateChatException(String clientId, String exceptionText) {
        try {
            for (int i = this.getData().size() - 1; i >= 0; --i) {
                AIMessage targetMessage = (AIMessage)this.getData().get(i);
                if (!StringUtils.equals((CharSequence)targetMessage.getClientId(), (CharSequence)clientId) || !StringUtils.equals((CharSequence)targetMessage.getRole(), (CharSequence)"assistant") || !StringUtils.equals((CharSequence)targetMessage.getEvent(), (CharSequence)"message.loading") && !StringUtils.equals((CharSequence)targetMessage.getEvent(), (CharSequence)"chat.started") && !StringUtils.equals((CharSequence)targetMessage.getEvent(), (CharSequence)"message.delta")) continue;
                if (StringUtils.isEmpty((CharSequence)targetMessage.getContentType())) {
                    targetMessage.setContentType("text");
                }
                targetMessage.setEvent("message.completed");
                targetMessage.setContent(targetMessage.getTextContent() + exceptionText);
                this.notifyItemChanged(i, targetMessage);
                break;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
    }

    protected void convert(@NonNull BaseViewHolder holder, AIMessage message, @NonNull List<?> payloads) {
        if (payloads.isEmpty()) {
            this.convert(holder, message);
        } else if (holder.getItemViewType() == 1) {
            for (Object payload : payloads) {
                if (!(payload instanceof AIMessage)) continue;
                AIMessage item = (AIMessage)payload;
                this.renderReceiveMarkdown((TextView)holder.getView(R.id.tv_content), item.getTextContent(), StringUtils.equals((CharSequence)"message.completed", (CharSequence)message.getEvent()));
                if (StringUtils.equals((CharSequence)item.getEvent(), (CharSequence)"message.completed") || item.isFromList()) {
                    holder.setVisible(R.id.ll_function_panel, true);
                    AIRatePanel aiRatePanel = (AIRatePanel)holder.getView(R.id.ai_rate_penal);
                    this.renderFunctionPanel(aiRatePanel, item);
                    continue;
                }
                holder.setGone(R.id.ll_function_panel, true);
            }
        }
    }

    protected void convert(@NonNull BaseViewHolder holder, AIMessage message) {
        if (holder.getItemViewType() == 1) {
            this.renderReceiveMarkdown((TextView)holder.getView(R.id.tv_content), message.getTextContent(), StringUtils.equals((CharSequence)"message.completed", (CharSequence)message.getEvent()));
            if (StringUtils.equals((CharSequence)message.getEvent(), (CharSequence)"message.completed") || message.isFromList()) {
                holder.setVisible(R.id.ll_function_panel, true);
                AIRatePanel aiRatePanel = (AIRatePanel)holder.getView(R.id.ai_rate_penal);
                this.renderFunctionPanel(aiRatePanel, message);
            } else {
                holder.setGone(R.id.ll_function_panel, true);
            }
        } else if (holder.getItemViewType() == 2) {
            holder.setText(R.id.tv_card_title, (CharSequence)message.getCardContent().getTitle());
            holder.setText(R.id.tv_card_content, (CharSequence)message.getCardContent().getDescription());
        } else if (holder.getItemViewType() == 3) {
            holder.setText(R.id.tv_card_title, (CharSequence)message.getCardContent().getTitle());
            holder.setText(R.id.tv_card_content, (CharSequence)message.getCardContent().getDescription());
            AppCompatImageView imageView = (AppCompatImageView)holder.getView(R.id.iv_image);
            if (StringUtils.isEmpty((CharSequence)message.getCardContent().getImage())) {
                imageView.setVisibility(8);
            } else {
                imageView.setVisibility(0);
                Glide.with((Context)this.getContext()).load(message.getCardContent().getImage()).into((ImageView)imageView);
            }
        } else if (holder.getItemViewType() == 4) {
            this.renderUserMarkdown((TextView)holder.getView(R.id.tv_content), message.getTextContent());
        } else if (holder.getItemViewType() == 0) {
            holder.getView(R.id.iv_audio_animation).setPadding(-120, -120, -120, -120);
        }
    }

    private void renderFunctionPanel(AIRatePanel aiRatePanel, AIMessage message) {
        String rate;
        switch (rate = StringUtils.isEmpty((CharSequence)message.getRating()) ? "" : message.getRating()) {
            case "good": {
                aiRatePanel.setRate(1);
                break;
            }
            case "bad": {
                aiRatePanel.setRate(2);
                break;
            }
            default: {
                aiRatePanel.setRate(0);
            }
        }
    }

    @NonNull
    public BaseLoadMoreModule addLoadMoreModule(@NonNull BaseQuickAdapter<?, ?> baseQuickAdapter) {
        return new BaseLoadMoreModule((BaseQuickAdapter)this);
    }

    @NonNull
    public BaseUpFetchModule addUpFetchModule(@NonNull BaseQuickAdapter<?, ?> baseQuickAdapter) {
        return new BaseUpFetchModule((BaseQuickAdapter)this);
    }

    private void renderUserMarkdown(TextView textView, String content) {
        if (content == null) {
            textView.setText((CharSequence)"");
        } else {
            Markwon markwon = Markwon.builder((Context)this.getContext()).usePlugin((MarkwonPlugin)new AbstractMarkwonPlugin(){

                public void configureSpansFactory(@NonNull MarkwonSpansFactory.Builder builder) {
                    builder.appendFactory(Heading.class, new SpanFactory(){

                        @Nullable
                        public Object getSpans(@NonNull MarkwonConfiguration configuration, @NonNull RenderProps props) {
                            Integer level = (Integer)CoreProps.HEADING_LEVEL.get(props);
                            if (level == 3 && Build.VERSION.SDK_INT >= 29) {
                                return new Object[]{new AbsoluteSizeSpan(ConvertUtils.dp2px((float)16.0f)), new LineHeightSpan.Standard(10), new BottomMarginSpan(-38)};
                            }
                            return null;
                        }
                    });
                }
            }).build();
            markwon.setMarkdown(textView, content);
        }
    }

    private void renderReceiveMarkdown(TextView textView, String content, boolean isComplete) {
        if (content == null) {
            textView.setText((CharSequence)"");
        } else {
            if (isComplete || content.contains("\u94fe\u63a5\u76f4\u8fbe\u4efb\u52a1") || this.isCourseLessonLink(content)) {
                if (this.markwonStudyPlan == null) {
                    this.markwonStudyPlan = MarkwonUtil.createStudyPlanStyle(this.getContext());
                }
            } else if (this.markwonNormalStyle == null) {
                this.markwonNormalStyle = MarkwonUtil.createNormalStyle(this.getContext(), textView);
            }
            String it = KLatexNormalizer.INSTANCE.normalizeLatex(content);
            Spanned spanned = this.markwonNormalStyle.render(this.markwonNormalStyle.parse(it));
            LogUtils.d((Object[])new Object[]{spanned.toString()});
            this.markwonNormalStyle.setParsedMarkdown(textView, spanned);
        }
    }

    private boolean isCourseLessonLink(String link) {
        String regex = "course/\\d+/task/\\d+";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(link);
        return matcher.find();
    }
}

