/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.aiassistant.entity;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.blankj.utilcode.util.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AISocketMessage {
    private int total;
    private List<SocketMessageData> counters;

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public List<SocketMessageData> getCounters() {
        if (this.counters == null) {
            this.counters = new ArrayList<SocketMessageData>();
        }
        return this.counters;
    }

    public void setCounters(List<SocketMessageData> counters) {
        this.counters = counters;
    }

    @Nullable
    public SocketMessageData getMessageDataByDomainId(String domainId) {
        if (this.counters != null && !this.counters.isEmpty()) {
            for (SocketMessageData messageData : this.counters) {
                if (!StringUtils.equals((CharSequence)domainId, (CharSequence)messageData.getDomainId())) continue;
                return messageData;
            }
        }
        return null;
    }

    public void removeRead(String domainId) {
        Iterator<SocketMessageData> iterator = this.counters.iterator();
        while (iterator.hasNext()) {
            SocketMessageData data = iterator.next();
            if (!StringUtils.equals((CharSequence)data.getDomainId(), (CharSequence)domainId)) continue;
            iterator.remove();
        }
    }

    @NonNull
    public String toString() {
        return "AISocketMessage{total=" + this.total + ", messages=" + (this.counters != null ? this.counters : "null") + '}';
    }

    public static class SocketMessageData {
        private String domainId;
        private String threadId;
        private int count;

        public String getDomainId() {
            return this.domainId;
        }

        public void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        public String getThreadId() {
            return this.threadId;
        }

        public void setThreadId(String threadId) {
            this.threadId = threadId;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        @NonNull
        public String toString() {
            return "SocketMessageData{, threadId='" + (this.threadId != null ? this.threadId : "null") + '\'' + ", domainId='" + (this.domainId != null ? this.domainId : "null") + '\'' + '}';
        }
    }
}

