/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.aiassistant.http;

import com.blankj.utilcode.util.StringUtils;
import com.edusoho.aiassistant.AISDKParams;
import com.edusoho.aiassistant.entity.AIFeedback;
import com.edusoho.aiassistant.entity.AIMessage;
import com.edusoho.aiassistant.entity.AudioTokenData;
import com.edusoho.aiassistant.entity.WorkflowRequest;
import com.edusoho.aiassistant.entity.WorkflowResult;
import com.edusoho.aiassistant.http.AIServiceAPI;
import com.edusoho.aiassistant.http.HttpClient;
import com.edusoho.aiassistant.util.AIMessageCache;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rx.Observable;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public class APIRequest {
    public Observable<List<AIMessage>> getMessageList(final String domainId) {
        if (AIMessageCache.get(domainId).isEmpty()) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("domainId", domainId);
            params.put("limit", String.valueOf(20));
            return ((AIServiceAPI)HttpClient.getInstance().create(AIServiceAPI.class)).getMessageList(params).doOnNext((Action1)new Action1<List<AIMessage>>(){

                public void call(List<AIMessage> aiMessages) {
                    AIMessageCache.push(domainId, aiMessages);
                }
            }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
        }
        return Observable.just(AIMessageCache.get(domainId));
    }

    public Observable<List<AIMessage>> getMessageListFromNet(final String domainId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("domainId", domainId);
        params.put("limit", String.valueOf(20));
        return ((AIServiceAPI)HttpClient.getInstance().create(AIServiceAPI.class)).getMessageList(params).doOnNext((Action1)new Action1<List<AIMessage>>(){

            public void call(List<AIMessage> aiMessages) {
                AIMessageCache.push(domainId, aiMessages);
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    public Observable<List<AIMessage>> getMessageListByIds(String domainId, String unreadMessages) {
        return ((AIServiceAPI)HttpClient.getInstance().create(AIServiceAPI.class)).getMessageListByIds(domainId, unreadMessages).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    public Observable<List<AIMessage>> getPullUnread(String domainId) {
        return ((AIServiceAPI)HttpClient.getInstance().create(AIServiceAPI.class)).getPullUnread(domainId).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    public Observable<List<AIMessage>> getMessageListDelta(final String domainId, final String beforeMessageId, String afterMessageId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("domainId", domainId);
        if (!StringUtils.isEmpty((CharSequence)beforeMessageId)) {
            params.put("before", beforeMessageId);
        }
        if (!StringUtils.isEmpty((CharSequence)afterMessageId)) {
            params.put("after", afterMessageId);
        }
        params.put("limit", String.valueOf(20));
        return ((AIServiceAPI)HttpClient.getInstance().create(AIServiceAPI.class)).getMessageList(params).doOnNext((Action1)new Action1<List<AIMessage>>(){

            public void call(List<AIMessage> aiMessages) {
                if (!StringUtils.isEmpty((CharSequence)beforeMessageId)) {
                    AIMessageCache.push(domainId, aiMessages);
                }
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    public Observable<Boolean> feedback(AIFeedback feedback) {
        return ((AIServiceAPI)HttpClient.getInstance().create(AIServiceAPI.class)).feedback(feedback.toRequestBody()).flatMap((Func1)new Func1<Map<String, Boolean>, Observable<Boolean>>(){

            public Observable<Boolean> call(Map<String, Boolean> map) {
                if (map != null && map.containsKey("ok")) {
                    return Observable.just((Object)map.get("ok"));
                }
                return Observable.just((Object)false);
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    public Observable<WorkflowResult> getWorkflow(WorkflowRequest workflowRequest) {
        return ((AIServiceAPI)HttpClient.getInstance().create(AIServiceAPI.class)).getWorkflowRequest(AISDKParams.SCHOOL_URL + "/" + "agent_worker", workflowRequest.toRequestBody()).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    public Observable<AudioTokenData> getAsrToken() {
        return ((AIServiceAPI)HttpClient.getInstance().create(AIServiceAPI.class)).getAsrToken().subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }
}

