/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.aiassistant.speech;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import com.blankj.utilcode.util.PermissionUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.bytedance.speech.speechengine.SpeechEngine;
import com.edusoho.aiassistant.speech.AsrUtil;
import com.edusoho.aiassistant.speech.SpeechEngineAdapter;
import java.util.List;

public class BytedanceSpeechEngineAdapter
implements SpeechEngineAdapter {
    private static final String TAG = "BytedanceSpeechEngineAdapter";

    @Override
    public void startRecording(Context context, final Runnable onError) {
        Log.i((String)TAG, (String)"\u914d\u7f6e\u542f\u52a8\u53c2\u6570.");
        AsrUtil.configOptionalParams();
        AsrUtil.getSpeechEngine().setOptionBoolean("asr_auto_stop", false);
        Log.i((String)TAG, (String)"\u5173\u95ed\u5f15\u64ce\uff08\u540c\u6b65\uff09");
        Log.i((String)TAG, (String)"Directive: DIRECTIVE_SYNC_STOP_ENGINE");
        int ret = AsrUtil.getSpeechEngine().sendDirective(2001, "");
        if (ret != 0) {
            Log.e((String)TAG, (String)("send directive syncstop failed, " + ret));
            if (onError != null) {
                onError.run();
            }
            return;
        }
        Log.i((String)TAG, (String)"\u542f\u52a8\u5f15\u64ce");
        Log.i((String)TAG, (String)"Directive: DIRECTIVE_START_ENGINE");
        ret = AsrUtil.getSpeechEngine().sendDirective(1000, "");
        if (ret == -700) {
            PermissionUtils.permission((String[])new String[]{"android.permission.RECORD_AUDIO"}).callback(new PermissionUtils.FullCallback(){

                public void onGranted(@NonNull List<String> granted) {
                }

                public void onDenied(@NonNull List<String> deniedForever, @NonNull List<String> denied) {
                    ToastUtils.showShort((CharSequence)"\u5f55\u97f3\u6743\u9650\u88ab\u62d2\u7edd");
                    if (onError != null) {
                        onError.run();
                    }
                }
            }).request();
        } else if (ret != 0) {
            Log.e((String)TAG, (String)("send directive start failed, " + ret));
            if (onError != null) {
                onError.run();
            }
        }
    }

    @Override
    public void stopRecording(boolean isSend) {
        Log.i((String)TAG, (String)"AsrTouch: Finish");
        Log.i((String)TAG, (String)"Directive: DIRECTIVE_FINISH_TALKING");
        AsrUtil.getSpeechEngine().sendDirective(1100, "");
        if (isSend) {
            AsrUtil.getSpeechEngine().sendDirective(1100, "");
        } else {
            AsrUtil.getSpeechEngine().sendDirective(2001, "");
        }
        AsrUtil.getStreamRecorder().Stop();
    }

    @Override
    public SpeechEngine getSpeechEngine() {
        return AsrUtil.getSpeechEngine();
    }

    @Override
    public void setAsrResultListener(SpeechEngineAdapter.AsrResultListener listener) {
    }
}

