/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.aiassistant.speech;

import android.content.Context;
import android.media.AudioRecord;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresPermission;
import com.blankj.utilcode.util.ActivityUtils;
import com.blankj.utilcode.util.PermissionUtils;
import com.bytedance.speech.speechengine.SpeechEngine;
import com.edusoho.aiassistant.entity.AudioTokenData;
import com.edusoho.aiassistant.http.APIRequest;
import com.edusoho.aiassistant.http.SingleObserver;
import com.edusoho.aiassistant.speech.SpeechEngineAdapter;
import com.edusoho.aiassistant.util.SSLSocketClient;
import java.util.List;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import rx.Subscriber;

public class FunAsrEngineAdapter
implements SpeechEngineAdapter {
    private static final String TAG = "FunAsrEngineAdapter";
    private static final String DEFAULT_HOST = "wss://funasr.edusoho.cn?token=";
    private static final String MODE = "2pass";
    private static final String CHUNK_SIZE = "5, 10, 5";
    private static final int CHUNK_INTERVAL = 10;
    private static final int SEND_SIZE = 1920;
    private static final int SAMPLE_RATE = 16000;
    private static final int CHANNEL = 16;
    private static final int AUDIO_FORMAT = 2;
    private AudioRecord audioRecord;
    private boolean isRecording = false;
    private String ASR_HOST = "";
    private String hotWords = "\u963f\u91cc\u5df4\u5df4 20\n\u8fbe\u6469\u9662 20\n\u591c\u96e8\u98d8\u96f6 20\n";
    private WebSocket webSocket;
    private String allAsrText = "";
    private String asrText = "";
    private SpeechEngineAdapter.AsrResultListener asrResultListener;
    private final APIRequest apiRequest = new APIRequest();
    private long mAudioStartTime;
    private long mAudioDuration;

    public FunAsrEngineAdapter(Context context) {
        this.apiRequest.getAsrToken().subscribe((Subscriber)new SingleObserver<AudioTokenData>(){

            @Override
            public void onNext(AudioTokenData tokenData) {
                if (tokenData != null) {
                    FunAsrEngineAdapter.this.ASR_HOST = String.format("%s?token=%s", tokenData.getServer(), tokenData.getToken());
                }
            }
        });
    }

    @Override
    public void startRecording(Context context, final Runnable onError) {
        block2: {
            this.isRecording = true;
            try {
                PermissionUtils.permissionGroup((String[])new String[]{"MICROPHONE", "STORAGE"}).callback(new PermissionUtils.FullCallback(){

                    @RequiresPermission(value="android.permission.RECORD_AUDIO")
                    public void onGranted(@NonNull List<String> granted) {
                        FunAsrEngineAdapter.this.allAsrText = "";
                        FunAsrEngineAdapter.this.asrText = "";
                        FunAsrEngineAdapter.this.audioRecord = new AudioRecord(1, 16000, 16, 2, 1920);
                        Thread recordingAudioThread = new Thread(() -> {
                            block2: {
                                try {
                                    FunAsrEngineAdapter.this.setAudioData();
                                }
                                catch (Exception e) {
                                    Log.e((String)FunAsrEngineAdapter.TAG, (String)"Error in setAudioData", (Throwable)e);
                                    if (onError == null) break block2;
                                    ActivityUtils.getTopActivity().runOnUiThread(onError);
                                }
                            }
                        });
                        FunAsrEngineAdapter.this.mAudioStartTime = System.currentTimeMillis();
                        recordingAudioThread.start();
                        FunAsrEngineAdapter.this.audioRecord.startRecording();
                    }

                    public void onDenied(@NonNull List<String> deniedForever, @NonNull List<String> denied) {
                        if (onError != null) {
                            onError.run();
                        }
                    }
                }).request();
            }
            catch (IllegalStateException e) {
                Log.e((String)TAG, (String)"Failed to initialize AudioRecord", (Throwable)e);
                if (onError == null) break block2;
                onError.run();
            }
        }
    }

    @Override
    public void stopRecording(boolean isSend) {
        this.isRecording = false;
        if (this.audioRecord != null) {
            this.audioRecord.stop();
            this.audioRecord.release();
            this.audioRecord = null;
        }
    }

    @Override
    public SpeechEngine getSpeechEngine() {
        return null;
    }

    @Override
    public void setAsrResultListener(SpeechEngineAdapter.AsrResultListener listener) {
        this.asrResultListener = listener;
    }

    private void setAudioData() throws Exception {
        OkHttpClient client = new OkHttpClient.Builder().sslSocketFactory(SSLSocketClient.getSSLSocketFactory(), SSLSocketClient.getX509TrustManager()).hostnameVerifier(SSLSocketClient.getHostnameVerifier()).build();
        Request request = new Request.Builder().url(this.ASR_HOST).build();
        this.webSocket = client.newWebSocket(request, new WebSocketListener(){

            public void onOpen(@NonNull WebSocket webSocket, @NonNull Response response) {
                Log.d((String)FunAsrEngineAdapter.TAG, (String)"WebSocket\u8fde\u63a5\u6210\u529f");
            }

            public void onMessage(@NonNull WebSocket webSocket, @NonNull String text) {
                Log.d((String)FunAsrEngineAdapter.TAG, (String)("WebSocket\u63a5\u6536\u5230\u6d88\u606f: " + text));
                try {
                    JSONObject jsonObject = new JSONObject(text);
                    String t = jsonObject.getString("text");
                    boolean isFinal = jsonObject.getBoolean("is_final");
                    if (!t.isEmpty()) {
                        String mode = jsonObject.getString("mode");
                        if (mode.equals("2pass-offline")) {
                            FunAsrEngineAdapter.this.asrText = "";
                            FunAsrEngineAdapter.this.allAsrText = FunAsrEngineAdapter.this.allAsrText + t;
                        } else {
                            FunAsrEngineAdapter.this.asrText = FunAsrEngineAdapter.this.asrText + t;
                        }
                        Log.d((String)FunAsrEngineAdapter.TAG, (String)("\u8bed\u97f3\u3010\u8fde\u7eed\u3011\u8bc6\u522b\u7ed3\u679c: " + FunAsrEngineAdapter.this.allAsrText + FunAsrEngineAdapter.this.asrText));
                        if (isFinal && FunAsrEngineAdapter.this.asrResultListener != null) {
                            FunAsrEngineAdapter.this.asrResultListener.onAsrResult(FunAsrEngineAdapter.this.allAsrText + FunAsrEngineAdapter.this.asrText, FunAsrEngineAdapter.this.mAudioDuration);
                            Log.d((String)FunAsrEngineAdapter.TAG, (String)("\u8bed\u97f3\u3010\u6700\u7ec8\u3011\u8bc6\u522b\u7ed3\u679c: " + FunAsrEngineAdapter.this.allAsrText + FunAsrEngineAdapter.this.asrText));
                        }
                    }
                    if (isFinal) {
                        webSocket.close(1000, "\u5173\u95edWebSocket\u8fde\u63a5");
                    }
                }
                catch (JSONException e) {
                    Log.e((String)FunAsrEngineAdapter.TAG, (String)"Error parsing message", (Throwable)e);
                }
            }

            public void onClosing(@NonNull WebSocket webSocket, int code, @NonNull String reason) {
                Log.d((String)FunAsrEngineAdapter.TAG, (String)("WebSocket\u5173\u95ed\u8fde\u63a5: " + reason));
            }

            public void onFailure(@NonNull WebSocket webSocket, @NonNull Throwable t, Response response) {
                Log.d((String)FunAsrEngineAdapter.TAG, (String)("WebSocket\u8fde\u63a5\u5931\u8d25: " + t.getMessage()));
            }
        });
        String message = this.getMessage(true);
        Log.d((String)TAG, (String)("WebSocket\u53d1\u9001\u6d88\u606f: " + message));
        this.webSocket.send(message);
        this.audioRecord.startRecording();
        byte[] bytes = new byte[1920];
        while (this.isRecording && this.audioRecord != null) {
            int readSize = this.audioRecord.read(bytes, 0, 1920);
            if (readSize <= 0) continue;
            ByteString byteString = ByteString.of((byte[])bytes);
            this.webSocket.send(byteString);
        }
        this.mAudioDuration = System.currentTimeMillis() - this.mAudioStartTime;
        JSONObject obj = new JSONObject();
        obj.put("is_speaking", false);
        this.webSocket.send(obj.toString());
    }

    private String getMessage(boolean isSpeaking) {
        try {
            String[] chunkList;
            JSONObject obj = new JSONObject();
            obj.put("mode", (Object)MODE);
            JSONArray array = new JSONArray();
            for (String s : chunkList = CHUNK_SIZE.split(",")) {
                array.put((Object)Integer.valueOf(s.trim()));
            }
            obj.put("chunk_size", (Object)array);
            obj.put("chunk_interval", 10);
            obj.put("wav_name", (Object)"default");
            if (!this.hotWords.isEmpty()) {
                String[] hotWordsList;
                JSONObject hotwordsJSON = new JSONObject();
                for (String s : hotWordsList = this.hotWords.split("\n")) {
                    if (s.isEmpty()) {
                        Log.w((String)TAG, (String)"hotWords\u4e3a\u7a7a");
                        continue;
                    }
                    String[] hotWordsArray = s.split(" ");
                    if (hotWordsArray.length != 2) {
                        Log.w((String)TAG, (String)"hotWords\u683c\u5f0f\u4e0d\u6b63\u786e");
                        continue;
                    }
                    hotwordsJSON.put(hotWordsArray[0], (Object)Integer.valueOf(hotWordsArray[1]));
                }
                obj.put("hotwords", (Object)hotwordsJSON.toString());
            }
            obj.put("wav_format", (Object)"pcm");
            obj.put("is_speaking", isSpeaking);
            return obj.toString();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error creating message", (Throwable)e);
            return "";
        }
    }
}

