/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.aiassistant.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatTextView;

public class AISpeakButton
extends AppCompatTextView {
    private boolean isRecording = false;
    private boolean isEnoughDistance = false;
    private float initialY = 0.0f;
    private final float SLIDE_THRESHOLD = 50.0f;
    private boolean isSlided = false;
    private boolean lastSlided = false;
    private static final long AUTO_SEND_DELAY = 30000L;
    private final Handler autoSendHandler = new Handler(Looper.getMainLooper());
    private VoiceButtonListener listener;
    private Context mContext;
    private final Runnable autoSendRunnable = new Runnable(){

        @Override
        public void run() {
            if (AISpeakButton.this.isRecording) {
                AISpeakButton.this.isRecording = false;
                if (AISpeakButton.this.listener != null) {
                    AISpeakButton.this.listener.onRecordStop(true);
                }
            }
        }
    };

    public AISpeakButton(@NonNull Context context) {
        super(context);
        this.mContext = context;
        this.init();
    }

    public AISpeakButton(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.init();
    }

    public AISpeakButton(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.init();
    }

    public void setVoiceButtonListener(VoiceButtonListener listener) {
        this.listener = listener;
    }

    private void triggerStrongVibration() {
        this.performHapticFeedback(0);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void init() {
        this.setOnTouchListener((v, event) -> {
            switch (event.getAction()) {
                case 0: {
                    this.isRecording = true;
                    this.initialY = event.getRawY();
                    this.isSlided = false;
                    this.lastSlided = false;
                    this.autoSendHandler.postDelayed(this.autoSendRunnable, 30000L);
                    if (this.listener != null) {
                        this.listener.onRecordStart();
                    }
                    this.triggerStrongVibration();
                    return true;
                }
                case 2: {
                    if (this.isRecording) {
                        float distance = this.initialY - event.getRawY();
                        boolean bl = this.isSlided = distance > 50.0f;
                        if (this.isSlided != this.lastSlided) {
                            this.triggerStrongVibration();
                            this.lastSlided = this.isSlided;
                        }
                        if (this.listener != null) {
                            this.listener.onRecordSlide(this.isSlided);
                        }
                    }
                    return true;
                }
                case 1: {
                    this.handleActionUp();
                    return true;
                }
            }
            return false;
        });
    }

    private void handleActionUp() {
        if (this.isRecording) {
            this.autoSendHandler.removeCallbacks(this.autoSendRunnable);
            this.isRecording = false;
            if (this.listener != null) {
                this.listener.onRecordStop(!this.isSlided);
            }
        }
    }

    public static interface VoiceButtonListener {
        public void onRecordStart();

        public void onRecordSlide(boolean var1);

        public void onRecordStop(boolean var1);
    }
}

