package com.edusoho.aiassistant.entity;

import androidx.annotation.NonNull;

import com.blankj.utilcode.util.GsonUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class WorkflowResult implements Serializable {
    private boolean ok;
    private Output  outputs;

    public boolean isOk() {
        return ok;
    }

    public void setOk(boolean ok) {
        this.ok = ok;
    }

    public Output getOutputs() {
        if (outputs == null) outputs = new Output();
        return outputs;
    }

    public void setOutputs(Output outputs) {
        this.outputs = outputs;
    }

    public static class Output {
        private List<String> deadlines;
        private List<AIStudyScheduleItem> tasks;

        public List<String> getDeadlines() {
            if (deadlines == null) deadlines = new ArrayList<>();
            return deadlines;
        }

        public void setDeadlines(List<String> deadlines) {
            this.deadlines = deadlines;
        }

        public List<AIStudyScheduleItem> getTasks() {
            return tasks;
        }

        public void setTasks(List<AIStudyScheduleItem> tasks) {
            this.tasks = tasks;
        }
    }

    @NonNull
    @Override
    public String toString() {
        return GsonUtils.toJson(this);
    }
}
