package com.edusoho.aiassistant.http;

import com.edusoho.aiassistant.entity.AIMessage;
import com.edusoho.aiassistant.entity.AudioTokenData;
import com.edusoho.aiassistant.entity.WorkflowResult;

import java.util.List;
import java.util.Map;

import okhttp3.RequestBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;
import retrofit2.http.Url;
import rx.Observable;

public interface AIServiceAPI {

    @Headers("isLogin:1")
    @GET("agent/message/list")
    Observable<List<AIMessage>> getMessageList(@QueryMap Map<String, String> params);

    @Headers("isLogin:1")
    @GET("agent/message/listByIds")
    Observable<List<AIMessage>> getMessageListByIds(@Query("domainId") String domainId, @Query("ids") String ids);

    @Headers("isLogin:1")
    @GET("/agent/message/pullUnread")
    Observable<List<AIMessage>> getPullUnread(@Query("domainId") String domainId);

    @Headers("isLogin:1")
    @POST("agent/message/clearUnreadCount")
    Observable<Map<String, Boolean>> clearUnreadCount(@Body RequestBody requestBody);

    @Headers("isLogin:1")
    @POST("agent/chat/feedback")
    Observable<Map<String, Boolean>> feedback(@Body RequestBody requestBody);

    @Headers("isLogin:1")
    @POST
    Observable<WorkflowResult> getWorkflowRequest(@Url String url, @Body RequestBody requestBody);

    @Headers("isLogin:1")
    @POST("agent/audio/asr/token")
    Observable<AudioTokenData> getAsrToken();
}
