package com.edusoho.aiassistant.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.HapticFeedbackConstants;
import android.view.MotionEvent;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatTextView;

public class AISpeakButton extends AppCompatTextView {

    // 状态变量
    private              boolean             isRecording      = false;
    private              boolean             isEnoughDistance = false;
    private              float               initialY         = 0f;
    private final        float               SLIDE_THRESHOLD  = 50f;
    private              boolean             isSlided         = false; // 是否已滑动超过阈值
    private              boolean             lastSlided       = false; // 是否已因超过阈值震动过
    // 新增自动发送时间
    private static final long                AUTO_SEND_DELAY  = 30000; // 30秒
    private final        Handler             autoSendHandler  = new Handler(Looper.getMainLooper());
    private              VoiceButtonListener listener;
    private              Context             mContext;

    private final Runnable autoSendRunnable = new Runnable() {
        @Override
        public void run() {
            if (isRecording) {
                isRecording = false;
                if (listener != null) {
                    // 参数true表示自动触发停止
                    listener.onRecordStop(true);
                }
            }
        }
    };


    public AISpeakButton(@NonNull Context context) {
        super(context);
        mContext = context;
        init();
    }

    public AISpeakButton(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        mContext = context;
        init();
    }

    public AISpeakButton(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        mContext = context;
        init();
    }

    public void setVoiceButtonListener(VoiceButtonListener listener) {
        this.listener = listener;
    }

    private void triggerStrongVibration() {
        performHapticFeedback(HapticFeedbackConstants.LONG_PRESS);
//        Vibrator vibrator = (Vibrator) mContext.getSystemService(Context.VIBRATOR_SERVICE);
//        if (vibrator.hasVibrator()) { // 检查设备是否支持震动
//            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.O) {
//                // Android 8.0 (API 26) 及以上，使用 VibrationEffect
//                VibrationEffect effect = VibrationEffect.createOneShot(200, VibrationEffect.DEFAULT_AMPLITUDE);
//                vibrator.vibrate(effect);
//            } else {
//                // 低于 API 26，使用旧 API
//                vibrator.vibrate(200); // 震动 500 毫秒
//            }
//        }
    }

    @SuppressLint("ClickableViewAccessibility")
    private void init() {
        setOnTouchListener((v, event) -> {
            switch (event.getAction()) {
                case MotionEvent.ACTION_DOWN:
                    isRecording = true;
                    initialY = event.getRawY();
                    isSlided = false;
                    lastSlided = false; // 初始化上一次状态

                    // 启动自动发送定时器
                    autoSendHandler.postDelayed(autoSendRunnable, AUTO_SEND_DELAY);

                    if (listener != null) listener.onRecordStart();
                    triggerStrongVibration();
                    return true;

                case MotionEvent.ACTION_MOVE:
                    if (isRecording) {
                        float distance = initialY - event.getRawY();
                        isSlided = distance > SLIDE_THRESHOLD; // 手指向上滑动足够距离

                        // 检测状态变化并触发震动
                        if (isSlided != lastSlided) {
                            triggerStrongVibration();
                            lastSlided = isSlided; // 更新上一次状态
                        }
                        if (listener != null) listener.onRecordSlide(isSlided); //
                    }
                    return true;

                case MotionEvent.ACTION_UP:
                    handleActionUp();
                    return true;

                default:
                    return false;
            }
        });
    }

    private void handleActionUp() {
        if (isRecording) {
            // 取消自动发送定时器
            autoSendHandler.removeCallbacks(autoSendRunnable);
            isRecording = false;
            if (listener != null) {
                // 参数false表示手动触发停止
                listener.onRecordStop(!isSlided);
            }
        }
    }

    // 回调接口
    public interface VoiceButtonListener {
        void onRecordStart();

        void onRecordSlide(boolean isSlided);

        void onRecordStop(boolean isRecord);
    }
}
