package com.edusoho.aiassistant.widget;

import android.content.Context;
import android.util.AttributeSet;

import androidx.appcompat.widget.AppCompatTextView;
import androidx.core.content.ContextCompat;

import com.edusoho.aiassistant.R;

public class WeekDayTextView extends AppCompatTextView {
    private boolean isSelected;

    public WeekDayTextView(Context context) {
        super(context);
        init();
    }

    public WeekDayTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public WeekDayTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    private void init() {
        // 设置默认字体颜色和背景
        setTextColor(ContextCompat.getColor(getContext(), R.color.color_37393D));
        setBackgroundResource(R.drawable.bg_schedule_weekday_normal);
    }

    public void setSelected(boolean selected) {
        isSelected = selected;
        updateAppearance();
    }

    public boolean isSelected() {
        return isSelected;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        updateAppearance();
    }

    private void updateAppearance() {
        if (isEnabled()) {
            if (isSelected) {
                setTextColor(ContextCompat.getColor(getContext(), R.color.color_165DFF));
                setBackgroundResource(R.drawable.bg_schedule_weekday_pressed);
            } else {
                setTextColor(ContextCompat.getColor(getContext(), R.color.color_37393D));
                setBackgroundResource(R.drawable.bg_schedule_weekday_normal);
            }
        } else {
            setTextColor(ContextCompat.getColor(getContext(), R.color.color_C0C0C2));
            setBackgroundResource(R.drawable.bg_schedule_weekday_disabled);
        }
    }
}
