/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.aiassistant;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.RelativeLayout;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.blankj.utilcode.util.ActivityUtils;
import com.blankj.utilcode.util.ClipboardUtils;
import com.blankj.utilcode.util.ColorUtils;
import com.blankj.utilcode.util.ConvertUtils;
import com.blankj.utilcode.util.GsonUtils;
import com.blankj.utilcode.util.NetworkUtils;
import com.blankj.utilcode.util.StringUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.chad.library.adapter.base.listener.OnUpFetchListener;
import com.edusoho.aiassistant.AIAssistantConfig;
import com.edusoho.aiassistant.AIEventSourceListener;
import com.edusoho.aiassistant.R;
import com.edusoho.aiassistant.StudyScheduleActivity;
import com.edusoho.aiassistant.adpter.AIMessageAdapter;
import com.edusoho.aiassistant.databinding.ActivityAiMessageListBinding;
import com.edusoho.aiassistant.entity.AIFeedback;
import com.edusoho.aiassistant.entity.AIMessage;
import com.edusoho.aiassistant.entity.AISendMessage;
import com.edusoho.aiassistant.entity.AISocketMessage;
import com.edusoho.aiassistant.entity.AudioTokenData;
import com.edusoho.aiassistant.entity.WorkflowRequest;
import com.edusoho.aiassistant.http.APIRequest;
import com.edusoho.aiassistant.http.SSEClient;
import com.edusoho.aiassistant.http.SingleObserver;
import com.edusoho.aiassistant.speech.AsrUtil;
import com.edusoho.aiassistant.speech.BytedanceSpeechEngineAdapter;
import com.edusoho.aiassistant.speech.FunAsrEngineAdapter;
import com.edusoho.aiassistant.speech.SpeechEngineAdapter;
import com.edusoho.aiassistant.speech.SpeechEngineSDK;
import com.edusoho.aiassistant.util.AIMessageCache;
import com.edusoho.aiassistant.util.AIUnreadMessageCache;
import com.edusoho.aiassistant.util.AIUtil;
import com.edusoho.aiassistant.util.MessageDeserializer;
import com.edusoho.aiassistant.viewmodel.AIViewModel;
import com.edusoho.aiassistant.widget.AIRatePanel;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Serializable;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import rx.Observable;
import rx.Subscriber;

public class AIMessageListActivity
extends AppCompatActivity {
    private static final String TAG = "AIMessageListActivity";
    private static final int AI_FEEDBACK_DELAY = 10000;
    private final Handler mUIHandler = new Handler(Looper.getMainLooper());
    private final APIRequest mAPIRequest = new APIRequest();
    private ActivityAiMessageListBinding binding;
    private AIMessageAdapter mMessageAdapter;
    private LinearLayoutManager mLayoutManager;
    private AIViewModel mAIViewModel;
    private Observer<AISocketMessage> mObserver;
    private AIAssistantConfig mConfig;
    private ActivityResultLauncher<Intent> launcher;
    private SpeechEngineAdapter mSpeechEngineAdapter;

    public static void launch(AIAssistantConfig config) {
        Activity currActivity = ActivityUtils.getTopActivity();
        Intent intent = new Intent((Context)currActivity, AIMessageListActivity.class);
        intent.putExtra("ai_config", (Serializable)config);
        ActivityUtils.startActivity((Intent)intent);
    }

    private void changeStatusBar() {
        Window window = this.getWindow();
        window.addFlags(Integer.MIN_VALUE);
        window.clearFlags(0x4000000);
        window.setStatusBarColor(ColorUtils.getColor((int)R.color.color_F5F5F7));
        if (Build.VERSION.SDK_INT >= 23) {
            window.getDecorView().setSystemUiVisibility(8192);
        }
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityAiMessageListBinding.inflate(LayoutInflater.from((Context)this));
        this.setContentView((View)this.binding.getRoot());
        this.changeStatusBar();
        this.launcher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), (ActivityResultCallback)new ActivityResultCallback<ActivityResult>(){

            public void onActivityResult(ActivityResult result) {
                Intent data = result.getData();
                if (data != null) {
                    String startDate = data.getStringExtra("startDate");
                    String endDate = data.getStringExtra("endDate");
                    TreeSet weekDays = (TreeSet)data.getSerializableExtra("weekDays");
                    String dailyLearnDuration = data.getStringExtra("dailyLearnDuration");
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    if (weekDays != null) {
                        list.addAll(weekDays);
                    }
                    String content = AIUtil.formatStudyTime1(startDate, endDate, list, dailyLearnDuration);
                    AISendMessage aiSendMessage = AIUtil.createGeneratedPlanMessage(startDate, endDate, dailyLearnDuration, list, content, AIMessageListActivity.this.mConfig.getDomainId(), AIMessageListActivity.this.mConfig.getMetaData());
                    AIMessageListActivity.this.sendMessage(aiSendMessage);
                }
            }
        });
        this.initIntentData();
        this.initViews();
        this.initData();
        this.initSpeechEngine();
        this.initViewModel();
    }

    protected void onDestroy() {
        AsrUtil.releaseEngine();
        super.onDestroy();
        this.mUIHandler.removeCallbacksAndMessages(null);
        this.clearViewModel();
    }

    private AIEventSourceListener createEventSourceListener(String uuid) {
        return new AIEventSourceListener(uuid){

            public void onOpen(@NonNull EventSource eventSource, @NonNull Response response) {
                Log.i((String)AIMessageListActivity.TAG, (String)"Connection opened");
            }

            public void onEvent(@NonNull EventSource eventSource, String id2, String type, @NonNull String data) {
                Log.i((String)AIMessageListActivity.TAG, (String)("Received event: ID=" + id2 + ", Type=" + type + ", Data=" + data));
                switch (type) {
                    case "chat.started": {
                        AIMessage chatCreatedMessage = (AIMessage)GsonUtils.fromJson((String)data, AIMessage.class);
                        chatCreatedMessage.setRole("assistant");
                        chatCreatedMessage.setEvent(type);
                        AIMessageListActivity.this.mUIHandler.post(() -> AIMessageListActivity.this.mMessageAdapter.addReceivedMessage(chatCreatedMessage));
                        Log.i((String)AIMessageListActivity.TAG, (String)("onEvent chat.created: " + chatCreatedMessage));
                        break;
                    }
                    case "message.delta": {
                        AIMessage deltaMessage = (AIMessage)GsonUtils.fromJson((String)data, AIMessage.class);
                        deltaMessage.setEvent(type);
                        AIMessageListActivity.this.mUIHandler.post(() -> AIMessageListActivity.this.mMessageAdapter.addReceivedMessage(deltaMessage));
                        Log.i((String)AIMessageListActivity.TAG, (String)("onEvent message. delta: " + deltaMessage));
                        break;
                    }
                    case "message.completed": {
                        Gson gson = new GsonBuilder().registerTypeAdapter(AIMessage.class, (Object)new MessageDeserializer()).create();
                        AIMessage completeMessage = (AIMessage)GsonUtils.fromJson((Gson)gson, (String)data, AIMessage.class);
                        if (StringUtils.equals((CharSequence)"feedback", (CharSequence)completeMessage.getType())) {
                            AIMessageListActivity.this.mUIHandler.postDelayed(() -> AIMessageListActivity.this.showFeedback(completeMessage.getChatId()), 10000L);
                        } else if (StringUtils.equals((CharSequence)"answer", (CharSequence)completeMessage.getType())) {
                            completeMessage.setEvent(type);
                            AIMessageCache.add(AIMessageListActivity.this.mConfig.getDomainId(), completeMessage);
                            AIMessageListActivity.this.mUIHandler.post(() -> AIMessageListActivity.this.mMessageAdapter.addReceivedMessage(completeMessage));
                        }
                        Log.i((String)AIMessageListActivity.TAG, (String)("onEvent message. completed: " + completeMessage));
                        break;
                    }
                    case "chat.failed": {
                        AIMessage failedMessage = (AIMessage)GsonUtils.fromJson((String)data, AIMessage.class);
                        failedMessage.setEvent(type);
                        AIMessageListActivity.this.mUIHandler.post(() -> AIMessageListActivity.this.mMessageAdapter.addReceivedMessage(failedMessage));
                        Log.i((String)AIMessageListActivity.TAG, (String)("onEvent message. failed: " + failedMessage));
                        break;
                    }
                    case "chat.completed": {
                        Log.i((String)AIMessageListActivity.TAG, (String)"onEvent message. done. ");
                        AIMessageListActivity.this.mUIHandler.post(() -> AIMessageListActivity.this.binding.aiMessageBox.setTextInputMode());
                    }
                }
            }

            public void onClosed(@NonNull EventSource eventSource) {
                Log.i((String)AIMessageListActivity.TAG, (String)"Connection closed");
            }

            public void onFailure(@NonNull EventSource eventSource, Throwable t, Response response) {
                try {
                    if (!NetworkUtils.isConnected()) {
                        AIMessageListActivity.this.mUIHandler.post(() -> AIMessageListActivity.this.mMessageAdapter.updateChatException(this.mClientId, "\n\n**\u65e0\u6cd5\u8fde\u63a5\u5230\u7f51\u7edc**"));
                        Log.i((String)AIMessageListActivity.TAG, (String)"-\u7f51\u7edc\u65e0\u6cd5\u8fde\u63a5");
                    } else if (t instanceof SocketException) {
                        Log.i((String)AIMessageListActivity.TAG, (String)"-\u65ad\u5f00\u8fde\u63a5");
                        AIMessageListActivity.this.mUIHandler.post(() -> AIMessageListActivity.this.mMessageAdapter.updateChatException(this.mClientId, "\n\n**\u7f51\u7edc\u8fde\u63a5\u5df2\u65ad\u5f00**"));
                    }
                    AIMessageListActivity.this.mUIHandler.post(() -> AIMessageListActivity.this.binding.aiMessageBox.setTextInputMode());
                }
                catch (Exception e) {
                    Log.e((String)AIMessageListActivity.TAG, (String)e.getMessage());
                }
            }
        };
    }

    private void initIntentData() {
        this.mConfig = (AIAssistantConfig)this.getIntent().getSerializableExtra("ai_config");
    }

    private void initViews() {
        this.mMessageAdapter = new AIMessageAdapter();
        this.mMessageAdapter.addChildClickViewIds(new int[]{R.id.iv_like, R.id.iv_dislike, R.id.iv_clipboard});
        this.mMessageAdapter.setOnItemClickListener((adapter, view, position) -> {
            try {
                AIMessage message = (AIMessage)((AIMessageAdapter)adapter).getItem(position);
                if (message.getItemType() == 2) {
                    StudyScheduleActivity.launch(this.launcher, this.mConfig.getMetaData().getCourseId());
                } else if (message.getItemType() == 3) {
                    AIUtil.openNews(message.getCardContent().getData().getUrl());
                }
            }
            catch (Exception e) {
                Log.d((String)TAG, (String)("click card :" + e.getMessage()));
            }
        });
        this.mMessageAdapter.setOnItemChildClickListener((adapter, view, position) -> {
            AIMessage message = (AIMessage)((AIMessageAdapter)adapter).getItem(position);
            if (view.getId() == R.id.iv_like) {
                this.pressRating((AIRatePanel)view.getParent(), message, "good");
            } else if (view.getId() == R.id.iv_dislike) {
                this.pressRating((AIRatePanel)view.getParent(), message, "bad");
            } else if (view.getId() == R.id.iv_clipboard) {
                ClipboardUtils.copyText((CharSequence)message.getTextContent());
                ToastUtils.showShort((CharSequence)"\u590d\u5236\u6210\u529f");
            }
        });
        this.mMessageAdapter.getUpFetchModule().setUpFetchEnable(true);
        this.mMessageAdapter.getUpFetchModule().setOnUpFetchListener(new OnUpFetchListener(){

            public void onUpFetch() {
                AIMessageListActivity.this.mMessageAdapter.getUpFetchModule().setUpFetching(true);
                String beforeMessageId = ((AIMessage)AIMessageListActivity.this.mMessageAdapter.getData().get(0)).getId();
                AIMessageListActivity.this.getNetMessageList(AIMessageListActivity.this.mConfig.getDomainId(), beforeMessageId);
            }
        });
        this.mLayoutManager = new LinearLayoutManager((Context)this);
        this.binding.rvMessageList.setLayoutManager((RecyclerView.LayoutManager)this.mLayoutManager);
        this.binding.rvMessageList.setAdapter((RecyclerView.Adapter)this.mMessageAdapter);
        this.binding.ivClose.setOnClickListener(v -> this.finish());
        this.binding.aiMessageBox.setListener((msg, audio, audioDuration) -> {
            this.binding.aiMessageBox.stopAnswer();
            this.mMessageAdapter.stopAnswer();
            if (audio) {
                this.sendMessage(AIUtil.createAudioTextMessage(msg, this.mConfig.getDomainId(), true, audioDuration, this.mConfig.getMetaData()));
            } else {
                this.sendMessage(AIUtil.createTextMessage(msg, this.mConfig.getDomainId(), this.mConfig.getMetaData()));
            }
        });
        this.initAccessibleLayout();
    }

    private void initAccessibleLayout() {
        this.binding.btnGeneratePlan.setOnClickListener(v -> {
            this.binding.aiMessageBox.stopAnswer();
            this.mMessageAdapter.stopAnswer();
            String msg = this.binding.btnGeneratePlan.getText();
            this.sendMessage(AIUtil.createTextMessage(msg, this.mConfig.getDomainId(), this.mConfig.getMetaData()));
        });
        this.binding.btnCheckPlan.setOnClickListener(v -> {
            this.binding.aiMessageBox.stopAnswer();
            this.mMessageAdapter.stopAnswer();
            String msg = this.binding.btnCheckPlan.getText();
            this.sendMessage(AIUtil.createTextMessage(msg, this.mConfig.getDomainId(), this.mConfig.getMetaData()));
        });
        this.binding.btnRegeneratePlan.setOnClickListener(v -> {
            this.binding.aiMessageBox.stopAnswer();
            this.mMessageAdapter.stopAnswer();
            String msg = this.binding.btnRegeneratePlan.getText();
            this.sendMessage(AIUtil.createTextMessage(msg, this.mConfig.getDomainId(), this.mConfig.getMetaData()));
        });
        if (this.mConfig.isShowAccessible()) {
            if (this.mConfig.isGeneratedStudyPlan()) {
                this.binding.btnGeneratePlan.setVisibility(8);
                this.binding.btnCheckPlan.setVisibility(0);
                this.binding.btnRegeneratePlan.setVisibility(0);
            } else {
                this.binding.btnGeneratePlan.setVisibility(0);
                this.binding.btnCheckPlan.setVisibility(8);
                this.binding.btnRegeneratePlan.setVisibility(8);
            }
        } else {
            this.binding.llAccessibleLayout.setVisibility(8);
        }
    }

    private void sendMessage(AISendMessage aiSendMessage) {
        AIMessage userSendMessage = this.createUserSendMessage(aiSendMessage.getContent());
        AIMessageCache.add(this.mConfig.getDomainId(), userSendMessage);
        this.mUIHandler.post(() -> this.mMessageAdapter.addSendMessage(userSendMessage));
        AIMessage placeholderMessage = this.createPlaceholderMessage();
        placeholderMessage.setEvent("message.loading");
        this.mUIHandler.post(() -> this.mMessageAdapter.addReceivedMessage(placeholderMessage));
        SSEClient sseClient = new SSEClient();
        sseClient.send(aiSendMessage, this.createEventSourceListener(placeholderMessage.getClientId()));
        this.binding.aiMessageBox.setCurrentSSEClient(sseClient);
    }

    private void pressRating(final AIRatePanel aiRatePanel, final AIMessage message, final String rating) {
        this.mAPIRequest.feedback(new AIFeedback(message.getId(), rating)).subscribe((Subscriber)new SingleObserver<Boolean>(){

            @Override
            public void onNext(Boolean result) {
                if (result.booleanValue()) {
                    ToastUtils.showShort((CharSequence)"\u64cd\u4f5c\u6210\u529f");
                    aiRatePanel.setRate(StringUtils.equals((CharSequence)"good", (CharSequence)rating) ? 1 : 2);
                    message.setRating(rating);
                }
            }

            @Override
            public void onError(Throwable e) {
                ToastUtils.showShort((CharSequence)e.getMessage());
            }
        });
    }

    private void initData() {
        if (AIUnreadMessageCache.getTotalUnread() > 0) {
            this.mAPIRequest.getPullUnread(this.mConfig.getDomainId()).subscribe((Subscriber)new SingleObserver<List<AIMessage>>(){

                @Override
                public void onNext(List<AIMessage> list) {
                    AIUnreadMessageCache.removeUnread(AIMessageListActivity.this.mConfig.getDomainId());
                }
            });
        }
        Observable<List<AIMessage>> observable = this.mAPIRequest.getMessageListFromNet(this.mConfig.getDomainId());
        observable.subscribe((Subscriber)new SingleObserver<List<AIMessage>>(){

            @Override
            public void onNext(List<AIMessage> deltaMessageList) {
                AIUtil.filterContentTypeNull(deltaMessageList);
                AIMessageListActivity.this.mMessageAdapter.setList(deltaMessageList);
                AIMessageListActivity.this.mLayoutManager.setStackFromEnd(true);
                AIMessageListActivity.this.binding.rvMessageList.scrollToPosition(deltaMessageList.size() - 1);
                AIMessageListActivity.this.mMessageAdapter.getUpFetchModule().setUpFetching(false);
                AIMessageListActivity.this.initPreSendMessage();
            }

            @Override
            public void onError(Throwable e) {
                super.onError(e);
                super.onError(e);
                AIMessageListActivity.this.mMessageAdapter.getUpFetchModule().setUpFetching(false);
            }
        });
        if (this.mConfig.isShowAccessible()) {
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.binding.rvMessageList.getLayoutParams();
            layoutParams.setMargins(0, ConvertUtils.dp2px((float)56.0f), 0, ConvertUtils.dp2px((float)118.0f));
            this.binding.rvMessageList.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    private void initPreSendMessage() {
        if (!StringUtils.isEmpty((CharSequence)this.mConfig.getPreSendMessage()) && !StringUtils.isEmpty((CharSequence)this.mConfig.getPreMessageType())) {
            if (StringUtils.equals((CharSequence)this.mConfig.getPreMessageType(), (CharSequence)"text")) {
                this.sendMessage(AIUtil.createTextMessage(this.mConfig.getPreSendMessage(), this.mConfig.getDomainId(), this.mConfig.getMetaData()));
            } else if (StringUtils.equals((CharSequence)this.mConfig.getPreMessageType(), (CharSequence)"analysis")) {
                WorkflowRequest workflowRequest = new WorkflowRequest();
                workflowRequest.setQuestionAnalysis("teacher.question.analysis", this.mConfig.getDomainId(), this.mConfig.getPreSendMessage());
                this.sendMessage(AIUtil.createQuestionAnalysisMessage(this.mConfig.getPreSendMessage(), this.mConfig.getQuestion(), this.mConfig.getDomainId(), this.mConfig.getMetaData()));
            } else if (StringUtils.equals((CharSequence)this.mConfig.getPreMessageType(), (CharSequence)"idea")) {
                WorkflowRequest workflowRequest = new WorkflowRequest();
                workflowRequest.setQuestionAnalysis("teacher.question.idea", this.mConfig.getDomainId(), this.mConfig.getPreSendMessage());
                this.sendMessage(AIUtil.createQuestionAnalysisMessage(this.mConfig.getPreSendMessage(), this.mConfig.getQuestion(), this.mConfig.getDomainId(), this.mConfig.getMetaData()));
            }
        }
    }

    private void initSpeechEngine() {
        this.mAPIRequest.getAsrToken().subscribe((Subscriber)new SingleObserver<AudioTokenData>(){

            @Override
            public void onNext(AudioTokenData audioTokenData) {
                if (StringUtils.equals((CharSequence)"fun", (CharSequence)audioTokenData.getEngine())) {
                    AIMessageListActivity.this.mSpeechEngineAdapter = new FunAsrEngineAdapter((Context)AIMessageListActivity.this);
                    AIMessageListActivity.this.binding.aiMessageBox.setSpeechEngineAdapter(AIMessageListActivity.this.mSpeechEngineAdapter);
                } else if (StringUtils.equals((CharSequence)"volcengine", (CharSequence)audioTokenData.getEngine())) {
                    SpeechEngineSDK.init((Context)AIMessageListActivity.this);
                    AsrUtil.createStreamRecorder();
                    AsrUtil.createSpeechEngine();
                    AsrUtil.configInitParams();
                    AsrUtil.initEngine(AIMessageListActivity.this.binding.aiMessageBox);
                    AIMessageListActivity.this.mSpeechEngineAdapter = new BytedanceSpeechEngineAdapter();
                    AIMessageListActivity.this.binding.aiMessageBox.setSpeechEngineAdapter(AIMessageListActivity.this.mSpeechEngineAdapter);
                } else {
                    ToastUtils.showShort((CharSequence)"\u672a\u9002\u914d\u8bed\u97f3\u5f15\u64ce");
                }
            }

            @Override
            public void onError(Throwable e) {
                ToastUtils.showShort((CharSequence)("\u8bed\u97f3\u5f15\u64ce\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\uff1a" + e.getMessage()));
            }
        });
    }

    private void initViewModel() {
        if (this.mAIViewModel == null) {
            this.mAIViewModel = (AIViewModel)new ViewModelProvider((ViewModelStoreOwner)this).get(AIViewModel.class);
        }
        if (this.mObserver == null) {
            this.mObserver = aiSocketMessage -> {
                try {
                    if (aiSocketMessage.getTotal() > 0) {
                        AIUnreadMessageCache.replace(aiSocketMessage);
                        for (final AISocketMessage.SocketMessageData message : aiSocketMessage.getCounters()) {
                            if (!StringUtils.equals((CharSequence)message.getDomainId(), (CharSequence)this.mConfig.getDomainId())) continue;
                            this.mAPIRequest.getPullUnread(this.mConfig.getDomainId()).subscribe((Subscriber)new SingleObserver<List<AIMessage>>(){

                                @Override
                                public void onNext(List<AIMessage> list) {
                                    for (AIMessage aiMessage : list) {
                                        aiMessage.setEvent("message.completed");
                                        AIMessageListActivity.this.mMessageAdapter.addData(aiMessage);
                                    }
                                    AIUnreadMessageCache.removeUnread(message.getDomainId());
                                }
                            });
                        }
                    }
                }
                catch (Exception ex) {
                    Log.d((String)"AIUnreadMessageCache", (String)"getUnreadMessagesByDomainId: ");
                }
            };
        }
        this.mAIViewModel.getMessageLiveData().observe((LifecycleOwner)this, this.mObserver);
    }

    private void clearViewModel() {
        if (this.mAIViewModel != null) {
            this.mAIViewModel.getMessageLiveData().removeObservers((LifecycleOwner)this);
        }
        this.mAIViewModel = null;
        this.mObserver = null;
    }

    private void showFeedback(String chatId) {
        this.binding.includeFeedback.getRoot().setVisibility(0);
        this.binding.includeFeedback.ivClose.setOnClickListener(v -> this.binding.includeFeedback.getRoot().setVisibility(8));
        this.binding.includeFeedback.feedbackGood.setOnClickListener(v -> {
            AIFeedback aiFeedback = new AIFeedback(chatId, "good");
            this.mAPIRequest.feedback(aiFeedback).subscribe();
            ToastUtils.showShort((int)R.string.toast_feedback);
            this.binding.includeFeedback.getRoot().setVisibility(8);
        });
        this.binding.includeFeedback.feedbackNormal.setOnClickListener(v -> {
            AIFeedback aiFeedback = new AIFeedback(chatId, "normal");
            this.mAPIRequest.feedback(aiFeedback).subscribe();
            ToastUtils.showShort((int)R.string.toast_feedback);
            this.binding.includeFeedback.getRoot().setVisibility(8);
        });
        this.binding.includeFeedback.feedbackBad.setOnClickListener(v -> {
            AIFeedback aiFeedback = new AIFeedback(chatId, "bad");
            this.mAPIRequest.feedback(aiFeedback).subscribe();
            ToastUtils.showShort((int)R.string.toast_feedback);
            this.binding.includeFeedback.getRoot().setVisibility(8);
        });
    }

    private void getNetMessageList(String domainId, String beforeMessageId) {
        this.mAPIRequest.getMessageListDelta(domainId, beforeMessageId, null).subscribe((Subscriber)new SingleObserver<List<AIMessage>>(){

            @Override
            public void onNext(List<AIMessage> deltaMessageList) {
                if (deltaMessageList != null) {
                    AIUtil.filterContentTypeNull(deltaMessageList);
                    AIMessageListActivity.this.mMessageAdapter.addData(0, deltaMessageList);
                }
                AIMessageListActivity.this.mMessageAdapter.getUpFetchModule().setUpFetching(false);
            }

            @Override
            public void onError(Throwable e) {
                ToastUtils.showShort((CharSequence)("\u6d88\u606f\u52a0\u8f7d\u5931\u8d25:" + e.getMessage()));
                AIMessageListActivity.this.mMessageAdapter.getUpFetchModule().setUpFetching(false);
            }
        });
    }

    private AIMessage createUserSendMessage(String content) {
        AIMessage userSendMessage = new AIMessage();
        userSendMessage.setRole("user");
        userSendMessage.setContent(content);
        return userSendMessage;
    }

    private AIMessage createPlaceholderMessage() {
        AIMessage message = new AIMessage();
        message.setContent("");
        message.setRole("assistant");
        message.setEvent("message.loading");
        return message;
    }
}

