/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.aiassistant;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import androidx.activity.result.ActivityResultLauncher;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import com.applandeo.materialcalendarview.DatePicker;
import com.applandeo.materialcalendarview.builders.DatePickerBuilder;
import com.applandeo.materialcalendarview.listeners.OnSelectDateListener;
import com.blankj.utilcode.util.ActivityUtils;
import com.blankj.utilcode.util.ColorUtils;
import com.blankj.utilcode.util.StringUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.edusoho.aiassistant.R;
import com.edusoho.aiassistant.databinding.ActivityLearningScheduleBinding;
import com.edusoho.aiassistant.entity.WorkflowRequest;
import com.edusoho.aiassistant.entity.WorkflowResult;
import com.edusoho.aiassistant.http.APIRequest;
import com.edusoho.aiassistant.http.SingleObserver;
import com.edusoho.aiassistant.widget.WeekDayTextView;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import rx.Subscriber;

public class LearningScheduleActivity
extends AppCompatActivity {
    private APIRequest mAPIRequest = new APIRequest();
    private List<String> mDeadlines = new ArrayList<String>();
    private ActivityLearningScheduleBinding binding;
    private String mTodayDate = new SimpleDateFormat("yyyy-MM-dd").format(Calendar.getInstance().getTime());
    private String mStartTime;
    private String mEndTime;
    private List<Integer> mAvailableWeekdays = new ArrayList<Integer>();
    private TreeSet<Integer> mResultWeekdays = new TreeSet();

    public static void launch(ActivityResultLauncher<Intent> launcher) {
        Activity currActivity = ActivityUtils.getTopActivity();
        launcher.launch((Object)new Intent((Context)currActivity, LearningScheduleActivity.class));
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityLearningScheduleBinding.inflate(LayoutInflater.from((Context)this));
        this.setContentView((View)this.binding.getRoot());
        this.binding.ivBack.setOnClickListener(v -> this.finish());
        this.initViews();
        this.requestData();
    }

    private void initViews() {
        this.renderStepTitle(this.getString(R.string.schedule_time_duration_text), (TextView)this.binding.tvStepTitle1);
        this.renderStepTitle(this.getString(R.string.schedule_weekly_text), (TextView)this.binding.tvStepTitle2);
    }

    private void requestData() {
        WorkflowRequest workflowRequest = new WorkflowRequest();
        workflowRequest.setWorkflow("plan.getGenerateConfig", 1271);
        this.mAPIRequest.getWorkflow(workflowRequest).subscribe((Subscriber)new SingleObserver<WorkflowResult>(){

            @Override
            public void onNext(WorkflowResult workflowResult) {
                LearningScheduleActivity.this.mDeadlines = workflowResult.getOutputs().getDeadlines();
                LearningScheduleActivity.this.initPlanViews();
            }

            @Override
            public void onError(Throwable e) {
                super.onError(e);
            }
        });
    }

    private void initPlanViews() {
        this.binding.tvStartTime.setOnClickListener(v -> this.showDateDialog(this.getStartDateListener()));
        this.binding.tvEndTime.setOnClickListener(v -> {
            if (this.mDeadlines.isEmpty()) {
                this.showDateDialog(this.getEndDateListener());
            } else {
                this.showDeadlinesDialog();
            }
        });
        this.binding.tvNext.setOnClickListener(v -> {
            if (this.isStartTimeLaterThanEndTime(this.mStartTime, this.mEndTime)) {
                ToastUtils.showLong((CharSequence)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65f6\u95f4");
            } else {
                this.binding.llDateSelect.setVisibility(8);
                this.binding.llWeekdaySelect.setVisibility(0);
                this.setWeekdays(this.mStartTime, this.mEndTime);
                this.renderWeekdays(this.mAvailableWeekdays);
            }
        });
        this.binding.tvPrev.setOnClickListener(v -> {
            this.binding.llDateSelect.setVisibility(0);
            this.binding.llWeekdaySelect.setVisibility(8);
        });
        for (int i = 0; i < this.binding.clWeekdays.getChildCount(); ++i) {
            WeekDayTextView weekDayTextView = (WeekDayTextView)this.binding.clWeekdays.getChildAt(i);
            if (weekDayTextView.getTag() == null) continue;
            weekDayTextView.setOnClickListener(v -> {
                if (v.isEnabled()) {
                    if (v.isSelected()) {
                        v.setSelected(false);
                        this.mResultWeekdays.remove(Integer.parseInt(v.getTag().toString()));
                    } else {
                        v.setSelected(true);
                        this.mResultWeekdays.add(Integer.parseInt(v.getTag().toString()));
                    }
                }
                this.checkCreateButton();
            });
        }
        this.binding.tvCreate.setOnClickListener(v -> {
            Intent intent = new Intent().putExtra("startDate", this.mStartTime).putExtra("endDate", this.mEndTime).putExtra("weekDays", this.mResultWeekdays);
            this.setResult(-1, intent);
            this.finish();
        });
    }

    private void renderStepTitle(String title, TextView textView) {
        StringBuffer stringBuffer = new StringBuffer(title);
        SpannableString spannableString = new SpannableString((CharSequence)stringBuffer);
        spannableString.setSpan((Object)new StyleSpan(1), 0, 1, 18);
        spannableString.setSpan((Object)new AbsoluteSizeSpan(24, true), 0, 1, 18);
        spannableString.setSpan((Object)new ForegroundColorSpan(ColorUtils.getColor((int)R.color.color_165DFF)), 0, 1, 18);
        textView.setText((CharSequence)spannableString);
    }

    private void checkCreateButton() {
        this.binding.tvCreate.setEnabled(!this.mResultWeekdays.isEmpty());
    }

    private void renderWeekdays(List<Integer> availableWeekdays) {
        for (int i = 0; i < this.binding.clWeekdays.getChildCount(); ++i) {
            WeekDayTextView weekDayTextView = (WeekDayTextView)this.binding.clWeekdays.getChildAt(i);
            if (weekDayTextView.getTag() == null) continue;
            if (availableWeekdays.contains(Integer.parseInt(weekDayTextView.getTag().toString()))) {
                weekDayTextView.setEnabled(true);
                continue;
            }
            weekDayTextView.setEnabled(false);
            this.mResultWeekdays.remove(Integer.parseInt(weekDayTextView.getTag().toString()));
        }
        this.checkCreateButton();
    }

    private boolean isStartTimeLaterThanEndTime(String startTime, String endTime) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date start = sdf.parse(startTime);
            Date end = sdf.parse(endTime);
            return start.after(end);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean isNextEnabled() {
        return !StringUtils.isEmpty((CharSequence)this.binding.tvStartTime.getText().toString()) && !StringUtils.isEmpty((CharSequence)this.binding.tvEndTime.getText().toString());
    }

    private void showDateDialog(OnSelectDateListener listener) {
        Calendar minDate = Calendar.getInstance();
        minDate.set(11, 0);
        minDate.set(12, 0);
        minDate.set(13, 0);
        minDate.set(14, 0);
        Calendar maxDate = Calendar.getInstance();
        maxDate.set(1, 2100);
        maxDate.set(2, 11);
        maxDate.set(5, 31);
        DatePickerBuilder builder = new DatePickerBuilder((Context)this, listener).pickerType(1).minimumDate(minDate).maximumDate(maxDate).date(this.getSelectedDate(this.mTodayDate));
        DatePicker datePicker = builder.build();
        datePicker.show();
    }

    private OnSelectDateListener getStartDateListener() {
        return list -> {
            if (!list.isEmpty()) {
                Calendar selectedDate = (Calendar)list.get(0);
                String selectedDateStr = new SimpleDateFormat("yyyy-MM-dd").format(selectedDate.getTime());
                this.binding.tvStartTime.setText((CharSequence)selectedDateStr);
                this.mStartTime = selectedDateStr;
                this.binding.tvNext.setEnabled(this.isNextEnabled());
            }
        };
    }

    private OnSelectDateListener getEndDateListener() {
        return list -> {
            Calendar selectedDate = (Calendar)list.get(0);
            String selectedDateStr = new SimpleDateFormat("yyyy-MM-dd").format(selectedDate.getTime());
            this.binding.tvEndTime.setText((CharSequence)selectedDateStr);
            this.mEndTime = selectedDateStr;
            this.binding.tvNext.setEnabled(this.isNextEnabled());
        };
    }

    private void showDeadlinesDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setTitle((CharSequence)"\u9009\u62e9\u622a\u6b62\u65e5\u671f");
        CharSequence[] deadlineArray = this.mDeadlines.toArray(new String[0]);
        builder.setSingleChoiceItems(deadlineArray, -1, new DialogInterface.OnClickListener(){
            final /* synthetic */ String[] val$deadlineArray;
            {
                this.val$deadlineArray = stringArray;
            }

            public void onClick(DialogInterface dialog, int which) {
                LearningScheduleActivity.this.binding.tvEndTime.setText((CharSequence)this.val$deadlineArray[which]);
                LearningScheduleActivity.this.mEndTime = this.val$deadlineArray[which];
                LearningScheduleActivity.this.binding.tvNext.setEnabled(LearningScheduleActivity.this.isNextEnabled());
                dialog.dismiss();
            }
        });
        builder.setNegativeButton((CharSequence)"\u53d6\u6d88", null);
        AlertDialog dialog = builder.create();
        dialog.show();
    }

    private Calendar getSelectedDate(String selectedDate) {
        if (!TextUtils.isEmpty((CharSequence)selectedDate)) {
            try {
                Date date = new SimpleDateFormat("yyyy-MM-dd").parse(selectedDate);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                return calendar;
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setWeekdays(String startDateStr, String endDateStr) {
        this.mAvailableWeekdays.clear();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date startDate = sdf.parse(startDateStr);
            Date endDate = sdf.parse(endDateStr);
            Calendar startCal = Calendar.getInstance();
            startCal.setTime(startDate);
            Calendar endCal = Calendar.getInstance();
            endCal.setTime(endDate);
            TreeSet<Integer> weekdaySet = new TreeSet<Integer>();
            while (!startCal.getTime().after(endCal.getTime())) {
                int dayOfWeek = startCal.get(7);
                int weekday = (dayOfWeek + 5) % 7 + 1;
                weekdaySet.add(weekday);
                startCal.add(5, 1);
            }
            this.mAvailableWeekdays.addAll(weekdaySet);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

