/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.aiassistant;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import androidx.activity.result.ActivityResultLauncher;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.applandeo.materialcalendarview.DatePicker;
import com.applandeo.materialcalendarview.builders.DatePickerBuilder;
import com.applandeo.materialcalendarview.listeners.OnSelectDateListener;
import com.blankj.utilcode.util.ActivityUtils;
import com.blankj.utilcode.util.ColorUtils;
import com.blankj.utilcode.util.StringUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.edusoho.aiassistant.R;
import com.edusoho.aiassistant.adpter.AIStudyScheduleAdapter;
import com.edusoho.aiassistant.databinding.ActivityStudyScheduleBinding;
import com.edusoho.aiassistant.entity.AIStudyScheduleItem;
import com.edusoho.aiassistant.entity.WorkflowRequest;
import com.edusoho.aiassistant.entity.WorkflowResult;
import com.edusoho.aiassistant.http.APIRequest;
import com.edusoho.aiassistant.http.SingleObserver;
import com.edusoho.aiassistant.widget.AIWeekDayWidget;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;

public class StudyScheduleActivity
extends AppCompatActivity
implements View.OnClickListener {
    private static final String COURSE_ID = "course_id";
    private static final String LEARNING_FINISH = "\u5b66\u5b8c\u5373\u6b62";
    private static final String TAG = "StudyScheduleActivity";
    private final APIRequest mAPIRequest = new APIRequest();
    private List<String> mDeadlines = new ArrayList<String>();
    private String mTodayDate = new SimpleDateFormat("yyyy-MM-dd").format(Calendar.getInstance().getTime());
    private String mStartTime;
    private String mEndTime;
    private int mCourseId;
    private ActivityStudyScheduleBinding binding;
    private static final int[] WEEK_DAYS = new int[]{1, 2, 3, 4, 5, 6, 7};
    private TreeSet<Integer> mWeekDays = new TreeSet();
    private double currentTime = 2.0;
    private static final double TIME_STEP = 0.5;
    private static final double MIN_TIME = 0.5;
    private static final double MAX_TIME = 24.0;
    private AIStudyScheduleAdapter mAdapter;

    public static void launch(ActivityResultLauncher<Intent> launcher, int courseId) {
        Activity currActivity = ActivityUtils.getTopActivity();
        Intent intent = new Intent((Context)currActivity, StudyScheduleActivity.class);
        intent.putExtra(COURSE_ID, courseId);
        launcher.launch((Object)intent);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityStudyScheduleBinding.inflate(LayoutInflater.from((Context)this));
        this.setContentView((View)this.binding.getRoot());
        this.changeStatusBar();
        this.initViews();
        this.initData();
    }

    public void onClick(View v) {
        AIWeekDayWidget widget = (AIWeekDayWidget)v;
        int selectedCount = 0;
        for (int i = 0; i < this.binding.llWeekdaySelect.getChildCount(); ++i) {
            AIWeekDayWidget w = (AIWeekDayWidget)this.binding.llWeekdaySelect.getChildAt(i);
            if (!w.isSelected()) continue;
            ++selectedCount;
        }
        if (selectedCount == 1 && widget.isSelected()) {
            ToastUtils.showShort((CharSequence)"\u5fc5\u987b\u81f3\u5c11\u9009\u62e9\u4e00\u5929");
            return;
        }
        widget.toggleState();
        int weekDay = Integer.parseInt(v.getTag().toString());
        StudyScheduleActivity.WEEK_DAYS[weekDay - 1] = v.isSelected() ? weekDay : 0;
        this.requestData();
    }

    private void changeStatusBar() {
        Window window = this.getWindow();
        window.addFlags(Integer.MIN_VALUE);
        window.clearFlags(0x4000000);
        window.setStatusBarColor(ColorUtils.getColor((int)17170443));
        if (Build.VERSION.SDK_INT >= 23) {
            window.getDecorView().setSystemUiVisibility(8192);
        }
    }

    private void initViews() {
        this.binding.ivBack.setOnClickListener(v -> this.finish());
        this.binding.tvStartTime.setOnClickListener(v -> this.showDateDialog(false, this.getStartDateListener()));
        this.binding.tvEndTime.setOnClickListener(v -> {
            if (this.mDeadlines.isEmpty()) {
                this.showDateDialog(true, this.getEndDateListener());
            } else {
                this.showDeadlinesDialog();
            }
        });
        this.binding.tvDay1.setOnClickListener(this);
        this.binding.tvDay2.setOnClickListener(this);
        this.binding.tvDay3.setOnClickListener(this);
        this.binding.tvDay4.setOnClickListener(this);
        this.binding.tvDay5.setOnClickListener(this);
        this.binding.tvDay6.setOnClickListener(this);
        this.binding.tvDay7.setOnClickListener(this);
        this.setupEditText();
        this.binding.ivIncrease.setOnClickListener(v -> {
            if (this.currentTime < 24.0) {
                this.currentTime += 0.5;
                this.requestData();
                this.updateTimeDisplay();
            }
        });
        this.binding.ivDecrease.setOnClickListener(v -> {
            if (this.currentTime > 0.5) {
                this.currentTime -= 0.5;
                this.requestData();
                this.updateTimeDisplay();
            }
        });
        this.binding.tvCreate.setOnClickListener(v -> {
            Intent intent = new Intent().putExtra("startDate", this.mStartTime).putExtra("endDate", StringUtils.equals((CharSequence)this.mEndTime, (CharSequence)LEARNING_FINISH) ? null : this.mEndTime).putExtra("weekDays", this.mWeekDays).putExtra("dailyLearnDuration", String.valueOf(this.currentTime));
            this.setResult(-1, intent);
            this.finish();
        });
        this.mAdapter = new AIStudyScheduleAdapter();
        this.binding.rvStudyList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.binding.rvStudyList.setHasFixedSize(true);
        this.binding.rvStudyList.setAdapter((RecyclerView.Adapter)this.mAdapter);
    }

    private void updateTimeDisplay() {
        if (this.currentTime == (double)((int)this.currentTime)) {
            this.binding.etLearnTime.setText((CharSequence)String.format("%d", (int)this.currentTime));
        } else {
            this.binding.etLearnTime.setText((CharSequence)String.format("%.1f", this.currentTime));
        }
    }

    private void setupEditText() {
        this.binding.etLearnTime.setInputType(8194);
        this.binding.etLearnTime.setFilters(new InputFilter[]{new InputFilter(){

            public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
                String input = dest.toString() + source.toString();
                if (input.isEmpty()) {
                    return null;
                }
                if (!input.matches("\\d*\\.?\\d*")) {
                    return "";
                }
                return null;
            }
        }});
        this.binding.etLearnTime.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                String input = s.toString();
                if (input.isEmpty()) {
                    return;
                }
                try {
                    double value = Double.parseDouble(input);
                    if (value % 0.5 != 0.0) {
                        ToastUtils.showShort((CharSequence)"\u8bf7\u8f93\u51650.5\u7684\u500d\u6570");
                        StudyScheduleActivity.this.updateTimeDisplay();
                        return;
                    }
                    if (value < 0.5 || value > 24.0) {
                        ToastUtils.showShort((CharSequence)"\u8bf7\u8f93\u51650.5\u523024\u4e4b\u95f4\u7684\u503c");
                        StudyScheduleActivity.this.updateTimeDisplay();
                        return;
                    }
                    StudyScheduleActivity.this.currentTime = value;
                }
                catch (NumberFormatException e) {
                    ToastUtils.showShort((CharSequence)"\u8bf7\u8f93\u5165\u6709\u6548\u7684\u6570\u5b57");
                    StudyScheduleActivity.this.updateTimeDisplay();
                }
            }
        });
    }

    private void initData() {
        for (int weekDay : WEEK_DAYS) {
            this.mWeekDays.add(weekDay);
        }
        this.mCourseId = this.getIntent().getIntExtra(COURSE_ID, 0);
        WorkflowRequest workflowRequest = new WorkflowRequest();
        workflowRequest.setWorkflow("plan.getGenerateConfig", this.mCourseId);
        this.mAPIRequest.getWorkflow(workflowRequest).flatMap((Func1)new Func1<WorkflowResult, Observable<WorkflowResult>>(){

            public Observable<WorkflowResult> call(WorkflowResult workflowResult) {
                StudyScheduleActivity.this.mDeadlines = workflowResult.getOutputs().getDeadlines();
                if (!StudyScheduleActivity.this.mDeadlines.isEmpty()) {
                    StudyScheduleActivity.this.mDeadlines.add(0, StudyScheduleActivity.LEARNING_FINISH);
                }
                ArrayList<Integer> weekDays = new ArrayList<Integer>();
                for (int weekDay : WEEK_DAYS) {
                    if (weekDay == 0) continue;
                    weekDays.add(weekDay);
                }
                WorkflowRequest workflowRequest = new WorkflowRequest();
                workflowRequest.setPreviewPlan("plan.preview", StudyScheduleActivity.this.mCourseId, StudyScheduleActivity.this.mStartTime, StudyScheduleActivity.this.mEndTime, weekDays, String.valueOf(StudyScheduleActivity.this.currentTime));
                return StudyScheduleActivity.this.mAPIRequest.getWorkflow(workflowRequest);
            }
        }).subscribe((Subscriber)new SingleObserver<WorkflowResult>(){

            @Override
            public void onNext(WorkflowResult result) {
                StudyScheduleActivity.this.renderList(StudyScheduleActivity.this.processScheduleList(result.getOutputs().getTasks()));
            }
        });
    }

    private void renderList(List<AIStudyScheduleItem> list) {
        if (list == null || list.isEmpty()) {
            this.mAdapter.getData().clear();
            this.mAdapter.setEmptyView(R.layout.empty_study_schedule);
            this.binding.tvCreate.setBackgroundResource(R.drawable.bg_generated_study_schedule_button_disabled);
            this.binding.tvCreate.setTextColor(ColorUtils.getColor((int)R.color.color_C0C0C2));
            this.binding.tvCreate.setEnabled(false);
            return;
        }
        this.mAdapter.setList(list);
        this.binding.tvCreate.setBackgroundResource(R.drawable.bg_generated_study_schedule_button);
        this.binding.tvCreate.setTextColor(ColorUtils.getColor((int)17170443));
        this.binding.tvCreate.setEnabled(true);
    }

    private void showDateDialog(boolean isShowEndTime, OnSelectDateListener listener) {
        try {
            Calendar minDate = Calendar.getInstance();
            minDate.set(11, 0);
            minDate.set(12, 0);
            minDate.set(13, 0);
            minDate.set(14, 0);
            Calendar maxDate = Calendar.getInstance();
            maxDate.set(1, 2025);
            maxDate.set(2, 11);
            maxDate.set(5, 31);
            DatePickerBuilder builder = new DatePickerBuilder((Context)this, listener).todayButtonVisibility(isShowEndTime ? 0 : 8).dialogTodayButtonColor(17170443).todayClickListener(dialog -> {
                dialog.dismiss();
                this.mEndTime = LEARNING_FINISH;
                this.binding.tvEndTime.setText((CharSequence)this.mEndTime);
                this.setLearningTimeEveryDay(this.mEndTime);
                if (!this.checkDateWarning(this.mStartTime, this.mEndTime)) {
                    this.requestData();
                }
            }).pickerType(1).minimumDate(minDate).maximumDate(maxDate);
            if (StringUtils.equals((CharSequence)LEARNING_FINISH, (CharSequence)this.binding.tvEndTime.getText().toString())) {
                builder.date(this.getSelectedDate(this.mTodayDate));
            } else {
                builder.date(this.getSelectedDate(this.binding.tvEndTime.getText().toString()));
            }
            DatePicker datePicker = builder.build();
            datePicker.show();
        }
        catch (Exception ex) {
            Log.d((String)TAG, (String)("showDateDialog: " + ex.getMessage()));
        }
    }

    private Calendar getSelectedDate(String selectedDate) {
        if (!TextUtils.isEmpty((CharSequence)selectedDate)) {
            try {
                Date date = new SimpleDateFormat("yyyy-MM-dd").parse(selectedDate);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                return calendar;
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private OnSelectDateListener getStartDateListener() {
        return list -> {
            if (!list.isEmpty()) {
                Calendar selectedDate = (Calendar)list.get(0);
                String selectedDateStr = new SimpleDateFormat("yyyy-MM-dd").format(selectedDate.getTime());
                this.binding.tvStartTime.setText((CharSequence)selectedDateStr);
                this.mStartTime = selectedDateStr;
                if (!this.checkDateWarning(this.mStartTime, this.mEndTime)) {
                    this.requestData();
                }
            }
        };
    }

    private OnSelectDateListener getEndDateListener() {
        return list -> {
            Calendar selectedDate = (Calendar)list.get(0);
            String selectedDateStr = new SimpleDateFormat("yyyy-MM-dd").format(selectedDate.getTime());
            this.binding.tvEndTime.setText((CharSequence)selectedDateStr);
            this.mEndTime = selectedDateStr;
            this.setLearningTimeEveryDay(this.mEndTime);
            if (!this.checkDateWarning(this.mStartTime, this.mEndTime)) {
                this.requestData();
            }
        };
    }

    private void showDeadlinesDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setTitle((CharSequence)"\u9009\u62e9\u622a\u6b62\u65e5\u671f");
        CharSequence[] deadlineArray = this.mDeadlines.toArray(new String[0]);
        builder.setSingleChoiceItems(deadlineArray, -1, new DialogInterface.OnClickListener(){
            final /* synthetic */ String[] val$deadlineArray;
            {
                this.val$deadlineArray = stringArray;
            }

            public void onClick(DialogInterface dialog, int which) {
                StudyScheduleActivity.this.binding.tvEndTime.setText((CharSequence)this.val$deadlineArray[which]);
                StudyScheduleActivity.this.mEndTime = this.val$deadlineArray[which];
                StudyScheduleActivity.this.setLearningTimeEveryDay(StudyScheduleActivity.this.mEndTime);
                if (!StudyScheduleActivity.this.checkDateWarning(StudyScheduleActivity.this.mStartTime, StudyScheduleActivity.this.mEndTime)) {
                    StudyScheduleActivity.this.requestData();
                }
                dialog.dismiss();
            }
        });
        builder.setNegativeButton((CharSequence)"\u53d6\u6d88", null);
        AlertDialog dialog = builder.create();
        dialog.show();
    }

    private void setLearningTimeEveryDay(String endTime) {
        if (StringUtils.equals((CharSequence)endTime, (CharSequence)LEARNING_FINISH)) {
            this.binding.tvWeekLearnDuration.setVisibility(0);
            this.binding.llLearnDuration.setVisibility(0);
        } else {
            this.binding.tvWeekLearnDuration.setVisibility(8);
            this.binding.llLearnDuration.setVisibility(8);
        }
    }

    private void requestData() {
        this.mWeekDays.clear();
        for (int weekDay : WEEK_DAYS) {
            if (weekDay == 0) continue;
            this.mWeekDays.add(weekDay);
        }
        WorkflowRequest workflowRequest = new WorkflowRequest();
        if (StringUtils.equals((CharSequence)this.mEndTime, (CharSequence)LEARNING_FINISH)) {
            workflowRequest.setPreviewPlan("plan.preview", this.mCourseId, this.mStartTime, null, new ArrayList<Integer>(this.mWeekDays), String.valueOf(this.currentTime));
        } else {
            workflowRequest.setPreviewPlan("plan.preview", this.mCourseId, this.mStartTime, this.mEndTime, new ArrayList<Integer>(this.mWeekDays), null);
        }
        this.mAPIRequest.getWorkflow(workflowRequest).subscribe((Subscriber)new SingleObserver<WorkflowResult>(){

            @Override
            public void onNext(WorkflowResult workflowResult) {
                if (workflowResult != null && workflowResult.getOutputs() != null && workflowResult.getOutputs().getTasks() != null) {
                    StudyScheduleActivity.this.renderList(StudyScheduleActivity.this.processScheduleList(workflowResult.getOutputs().getTasks()));
                }
            }

            @Override
            public void onError(Throwable e) {
                super.onError(e);
            }
        });
    }

    public List<AIStudyScheduleItem> processScheduleList(List<AIStudyScheduleItem> originalList) {
        if (originalList == null || originalList.isEmpty()) {
            return new ArrayList<AIStudyScheduleItem>();
        }
        ArrayList<String> uniqueDates = new ArrayList<String>();
        HashSet<String> seenDates = new HashSet<String>();
        for (AIStudyScheduleItem item : originalList) {
            String date = item.getDate();
            if (seenDates.contains(date)) continue;
            seenDates.add(date);
            uniqueDates.add(date);
        }
        ArrayList<AIStudyScheduleItem> resultList = new ArrayList<AIStudyScheduleItem>();
        for (String date : uniqueDates) {
            AIStudyScheduleItem dateItem = new AIStudyScheduleItem();
            dateItem.setType(0);
            dateItem.setDate(date);
            resultList.add(dateItem);
            ArrayList<AIStudyScheduleItem> dateItems = new ArrayList<AIStudyScheduleItem>();
            for (AIStudyScheduleItem item : originalList) {
                if (!item.getDate().equals(date)) continue;
                dateItems.add(item);
            }
            for (int i = 0; i < dateItems.size(); ++i) {
                if (i == dateItems.size() - 1) {
                    ((AIStudyScheduleItem)dateItems.get(i)).setLast(true);
                } else {
                    ((AIStudyScheduleItem)dateItems.get(i)).setLast(false);
                }
                resultList.add((AIStudyScheduleItem)dateItems.get(i));
            }
        }
        return resultList;
    }

    private boolean checkDateWarning(String startTime, String endTime) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        try {
            Date startDate = dateFormat.parse(startTime);
            Date endDate = dateFormat.parse(endTime);
            boolean isWarning = startDate.after(endDate);
            if (isWarning) {
                Animation shake = AnimationUtils.loadAnimation((Context)this, (int)R.anim.shake);
                this.binding.tvDateWarning.setVisibility(0);
                this.binding.tvDateWarning.startAnimation(shake);
                this.binding.tvCreate.setBackgroundResource(R.drawable.bg_generated_study_schedule_button_disabled);
                this.binding.tvCreate.setTextColor(ColorUtils.getColor((int)R.color.color_C0C0C2));
                this.binding.tvCreate.setEnabled(false);
                return true;
            }
            this.binding.tvCreate.setBackgroundResource(R.drawable.bg_generated_study_schedule_button);
            this.binding.tvCreate.setTextColor(ColorUtils.getColor((int)17170443));
            this.binding.tvDateWarning.setVisibility(8);
            this.binding.tvCreate.setEnabled(true);
        }
        catch (Exception e) {
            this.binding.tvDateWarning.setVisibility(8);
            this.binding.tvCreate.setBackgroundResource(R.drawable.bg_generated_study_schedule_button);
            this.binding.tvCreate.setTextColor(ColorUtils.getColor((int)17170443));
            this.binding.tvCreate.setEnabled(true);
            return false;
        }
        this.binding.tvDateWarning.setVisibility(8);
        this.binding.tvCreate.setBackgroundResource(R.drawable.bg_generated_study_schedule_button);
        this.binding.tvCreate.setTextColor(ColorUtils.getColor((int)17170443));
        this.binding.tvCreate.setEnabled(true);
        return false;
    }
}

