/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.aiassistant.entity;

import com.blankj.utilcode.util.GsonUtils;
import com.edusoho.aiassistant.AIConst;
import com.edusoho.aiassistant.AISDKParams;
import java.io.Serializable;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.RequestBody;

public class WorkflowRequest
implements Serializable {
    private String workflow;
    private Input inputs;

    public String getWorkflow() {
        return this.workflow;
    }

    public void setWorkflow(String workflow) {
        this.workflow = workflow;
    }

    public Input getInputs() {
        return this.inputs;
    }

    public void setInputs(Input inputs) {
        this.inputs = inputs;
    }

    public void setWorkflow(String workflow, int courseId) {
        this.workflow = workflow;
        if (this.inputs == null) {
            this.inputs = new Input();
        }
        this.inputs.setCourseId(courseId);
    }

    public void setGeneratedPlanConfig(String workflow, int courseId, String startDate, String endDate, String dailyLearnDuration, List<Integer> weekDays) {
        this.setWorkflow(workflow, courseId);
        this.inputs.setWorkerUrl(AISDKParams.SCHOOL_URL + "/" + "agent_worker" + "?token=" + AISDKParams.AI_AGENT_TOKEN);
        this.inputs.setStartDate(startDate);
        this.inputs.setEndDate(endDate);
        this.inputs.setDailyLearnDuration(dailyLearnDuration);
        this.inputs.setWeekDays(weekDays);
    }

    public void setQuestionAnalysis(String workflow, String domainId, String question) {
        this.workflow = workflow;
        if (this.inputs == null) {
            this.inputs = new Input();
        }
        this.inputs.setDomainId(domainId);
        this.inputs.setQuestion(question);
    }

    public void setPreviewPlan(String workflow, int courseId, String startDate, String endDate, List<Integer> weekDays, String dailyLearnDuration) {
        this.setWorkflow(workflow, courseId);
        this.inputs.setStartDate(startDate);
        this.inputs.setEndDate(endDate);
        this.inputs.setWeekDays(weekDays);
        this.inputs.setDailyLearnDuration(dailyLearnDuration);
    }

    public RequestBody toRequestBody() {
        String json = GsonUtils.toJson((Object)this);
        return RequestBody.create((String)json, (MediaType)AIConst.JSON);
    }

    public static class Input
    implements Serializable {
        private int courseId;
        private String domainId;
        private String workerUrl;
        private String startDate;
        private String endDate;
        private List<Integer> weekDays;
        private String question;
        private String dailyLearnDuration;

        public int getCourseId() {
            return this.courseId;
        }

        public void setCourseId(int courseId) {
            this.courseId = courseId;
        }

        public String getDomainId() {
            return this.domainId;
        }

        public void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        public String getWorkerUrl() {
            return this.workerUrl;
        }

        public void setWorkerUrl(String workerUrl) {
            this.workerUrl = workerUrl;
        }

        public String getStartDate() {
            return this.startDate;
        }

        public void setStartDate(String startDate) {
            this.startDate = startDate;
        }

        public String getEndDate() {
            return this.endDate;
        }

        public void setEndDate(String endDate) {
            this.endDate = endDate;
        }

        public List<Integer> getWeekDays() {
            return this.weekDays;
        }

        public void setWeekDays(List<Integer> weekDays) {
            this.weekDays = weekDays;
        }

        public String getQuestion() {
            return this.question;
        }

        public void setQuestion(String question) {
            this.question = question;
        }

        public String getDailyLearnDuration() {
            return this.dailyLearnDuration;
        }

        public void setDailyLearnDuration(String dailyLearnDuration) {
            this.dailyLearnDuration = dailyLearnDuration;
        }
    }
}

