/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.aiassistant.speech;

import android.content.Context;
import android.util.Log;
import com.blankj.utilcode.util.Utils;
import com.bytedance.speech.speechengine.SpeechEngine;
import com.bytedance.speech.speechengine.SpeechEngineGenerator;
import com.edusoho.aiassistant.speech.SpeechStreamRecorder;

public class AsrUtil {
    private static final String TAG = "AsrUtil";
    private static SpeechStreamRecorder mStreamRecorder = null;
    private static SpeechEngine mSpeechEngine;

    public static void createSpeechEngine() {
        mSpeechEngine = SpeechEngineGenerator.getInstance();
        mSpeechEngine.createEngine();
        mSpeechEngine.setContext((Context)Utils.getApp());
    }

    public static void configInitParams() {
        mSpeechEngine.setOptionString("engine_name", "asr");
        mSpeechEngine.setOptionString("recorder_data_source_type", "Recorder");
        String address = "wss://openspeech.bytedance.com";
        Log.i((String)TAG, (String)("Current address: " + address));
        mSpeechEngine.setOptionString("asr_address", address);
        String uri = "/api/v3/sauc/bigmodel";
        Log.i((String)TAG, (String)("Current uri: " + uri));
        mSpeechEngine.setOptionString("asr_uri", uri);
        String appid = "7662504681";
        mSpeechEngine.setOptionString("appid", appid);
        String token = "Bearer; N4UxfXbY4NZafOVlfxOV77mFoqz8vzLq";
        mSpeechEngine.setOptionString("token", token);
        Log.i((String)TAG, (String)("token: " + token));
        mSpeechEngine.setOptionString("resource_id", "volc.bigasr.sauc.duration");
        mSpeechEngine.setOptionInt("protocol_type", 1);
    }

    public static void configOptionalParams() {
        mSpeechEngine.setOptionBoolean("asr_enable_ddc", false);
        mSpeechEngine.setOptionBoolean("asr_enable_itn", false);
        mSpeechEngine.setOptionBoolean("asr_show_nlu_punctuation", true);
        mSpeechEngine.setOptionBoolean("asr_auto_stop", false);
        mSpeechEngine.setOptionBoolean("asr_disable_end_punc", false);
        mSpeechEngine.setOptionString("asr_result_type", "full");
        mSpeechEngine.setOptionInt("asr_vad_start_silence_time", 0);
        mSpeechEngine.setOptionInt("asr_vad_end_silence_time", 0);
        mSpeechEngine.setOptionString("asr_vad_mode", "");
        mSpeechEngine.setOptionInt("vad_max_speech_duration", 60000);
        mSpeechEngine.setOptionBoolean("enable_get_volume", false);
    }

    public static void initEngine(SpeechEngine.SpeechListener listener) {
        int ret = mSpeechEngine.initEngine();
        if (ret != 0) {
            String errMessage = "\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8fd4\u56de\u503c: " + ret;
            Log.e((String)TAG, (String)errMessage);
            Log.e((String)TAG, (String)("\u5f15\u64ce\u521d\u59cb\u5316\u5931\u8d25: " + errMessage));
        }
        mSpeechEngine.setListener(listener);
        AsrUtil.speechEnginInitSucceeded();
    }

    public static void releaseEngine() {
        if (mSpeechEngine != null) {
            mSpeechEngine.destroyEngine();
            mSpeechEngine = null;
        }
    }

    public static void createStreamRecorder() {
        if (mStreamRecorder == null) {
            mStreamRecorder = new SpeechStreamRecorder();
        }
    }

    public static SpeechStreamRecorder getStreamRecorder() {
        return mStreamRecorder;
    }

    public static SpeechEngine getSpeechEngine() {
        return mSpeechEngine;
    }

    private static void speechEnginInitSucceeded() {
        mStreamRecorder.SetSpeechEngine("ASR", mSpeechEngine);
    }
}

