/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.aiassistant.util;

import android.util.Log;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/edusoho/aiassistant/util/KLatexNormalizer;", "", "<init>", "()V", "INLINE_LATEX", "Lkotlin/text/Regex;", "BLOCK_LATEX", "FENCED_LATEX", "INLINE_DOLLAR", "SINGLELINE_DOUBLE_DOLLAR", "normalizeLatex", "", "raw", "AIAssistant_release"})
public final class KLatexNormalizer {
    @NotNull
    public static final KLatexNormalizer INSTANCE = new KLatexNormalizer();
    @NotNull
    private static final Regex INLINE_LATEX = new Regex("\\\\\\((.+?)\\\\\\)");
    @NotNull
    private static final Regex BLOCK_LATEX = new Regex("\\\\\\[(.+?)\\\\\\]", SetsKt.setOf((Object)RegexOption.DOT_MATCHES_ALL));
    @NotNull
    private static final Regex FENCED_LATEX = new Regex("```latex([\\s\\S]+?)```", RegexOption.MULTILINE);
    @NotNull
    private static final Regex INLINE_DOLLAR = new Regex("\\$(?!\\$)([^$\\n]*?)\\$(?!\\$)");
    @NotNull
    private static final Regex SINGLELINE_DOUBLE_DOLLAR = new Regex("\\$\\$(?!\\s*\\n)(.+?)(?<!\\n)\\$\\$");

    private KLatexNormalizer() {
    }

    @NotNull
    public final String normalizeLatex(@Nullable String raw) {
        CharSequence charSequence = raw;
        if (charSequence == null || charSequence.length() == 0) {
            return "";
        }
        try {
            String text = INLINE_LATEX.replace((CharSequence)raw, KLatexNormalizer::normalizeLatex$lambda$0);
            text = BLOCK_LATEX.replace((CharSequence)text, KLatexNormalizer::normalizeLatex$lambda$1);
            String normalized = FENCED_LATEX.replace((CharSequence)text, KLatexNormalizer::normalizeLatex$lambda$3);
            normalized = INLINE_LATEX.replace((CharSequence)normalized, KLatexNormalizer::normalizeLatex$lambda$4);
            normalized = BLOCK_LATEX.replace((CharSequence)normalized, KLatexNormalizer::normalizeLatex$lambda$5);
            normalized = INLINE_DOLLAR.replace((CharSequence)normalized, KLatexNormalizer::normalizeLatex$lambda$6);
            normalized = SINGLELINE_DOUBLE_DOLLAR.replace((CharSequence)normalized, KLatexNormalizer::normalizeLatex$lambda$7);
            CharSequence charSequence2 = normalized;
            Regex regex = new Regex("(?m)^\\$\\$\\s*\\n\\$\\$\\s*$");
            String string = "$$";
            charSequence2 = regex.replace(charSequence2, string);
            regex = new Regex("(?m)^\\$\\$\\s*\\n\\s*\\n\\$\\$\\s*$");
            string = "$$";
            normalized = regex.replace(charSequence2, string);
            Log.i((String)"SSE", (String)("normalizeLatex: " + normalized));
            charSequence = normalized;
        }
        catch (Exception ex) {
            Log.e((String)"SSE", (String)("normalizeLatex error: " + ex.getMessage()));
            charSequence = raw;
        }
        return charSequence;
    }

    private static final CharSequence normalizeLatex$lambda$0(MatchResult mr) {
        Intrinsics.checkNotNullParameter((Object)mr, (String)"mr");
        return "\\( " + ((Object)StringsKt.trim((CharSequence)((String)mr.getGroupValues().get(1)))).toString() + " \\)";
    }

    private static final CharSequence normalizeLatex$lambda$1(MatchResult mr) {
        Intrinsics.checkNotNullParameter((Object)mr, (String)"mr");
        return "\\[ " + ((Object)StringsKt.trim((CharSequence)((String)mr.getGroupValues().get(1)))).toString() + " \\]";
    }

    private static final CharSequence normalizeLatex$lambda$3$lambda$2(MatchResult m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        return "\\( " + ((Object)StringsKt.trim((CharSequence)((String)m.getGroupValues().get(1)))).toString() + " \\)";
    }

    private static final CharSequence normalizeLatex$lambda$3(MatchResult mr) {
        Intrinsics.checkNotNullParameter((Object)mr, (String)"mr");
        String content = ((Object)StringsKt.trim((CharSequence)((String)mr.getGroupValues().get(1)))).toString();
        CharSequence charSequence = content;
        Regex regex = new Regex("^\\s*\\\\\\\\\\[\\s*\\n?");
        String string = "";
        charSequence = regex.replace(charSequence, string);
        regex = new Regex("\\n?\\s*\\\\\\\\\\]\\s*$");
        string = "";
        String innerNoBracket = regex.replace(charSequence, string);
        String innerInlineSpaced = INLINE_LATEX.replace((CharSequence)innerNoBracket, KLatexNormalizer::normalizeLatex$lambda$3$lambda$2);
        return "\n$$\n" + ((Object)StringsKt.trim((CharSequence)innerInlineSpaced)).toString() + "\n$$\n";
    }

    private static final CharSequence normalizeLatex$lambda$4(MatchResult mr) {
        Intrinsics.checkNotNullParameter((Object)mr, (String)"mr");
        return "$" + mr.getGroupValues().get(1) + "$";
    }

    private static final CharSequence normalizeLatex$lambda$5(MatchResult mr) {
        Intrinsics.checkNotNullParameter((Object)mr, (String)"mr");
        return "$$" + mr.getGroupValues().get(1) + "$$";
    }

    private static final CharSequence normalizeLatex$lambda$6(MatchResult mr) {
        Intrinsics.checkNotNullParameter((Object)mr, (String)"mr");
        return "$ " + ((Object)StringsKt.trim((CharSequence)((String)mr.getGroupValues().get(1)))).toString() + " $";
    }

    private static final CharSequence normalizeLatex$lambda$7(MatchResult mr) {
        Intrinsics.checkNotNullParameter((Object)mr, (String)"mr");
        return "$$ " + ((Object)StringsKt.trim((CharSequence)((String)mr.getGroupValues().get(1)))).toString() + " $$";
    }
}

