/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.aiassistant.util;

import android.util.Log;
import com.blankj.utilcode.util.GsonUtils;
import com.blankj.utilcode.util.StringUtils;
import com.edusoho.aiassistant.entity.AISocketMessage;
import io.socket.client.IO;
import io.socket.client.Socket;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

public class SocketHandler {
    private static final String TAG = "SocketHandler";
    private static Socket mSocket;
    private static final String SERVER_URL = "wss://ai-signal.edusoho.net";
    private static final List<SignalListener> listeners;

    private SocketHandler() {
    }

    public static void addSignalListener(SignalListener listener) {
        listeners.add(listener);
    }

    public static void removeSignalListener(SignalListener listener) {
        listeners.remove(listener);
    }

    public static synchronized void initSocket(String agentToken) {
        try {
            IO.Options options = IO.Options.builder().setReconnection(true).setQuery("token=" + agentToken).build();
            mSocket = IO.socket((String)SERVER_URL, (IO.Options)options);
            mSocket.on("connect", args -> Log.d((String)TAG, (String)"call: Socket.EVENT_CONNECT"));
            mSocket.on("disconnect", args -> Log.d((String)TAG, (String)"call: Socket.EVENT_DISCONNECT"));
            mSocket.on("connect_error", args -> Log.d((String)TAG, (String)"call: Socket.EVENT_CONNECT_ERROR"));
            mSocket.on("signal", args -> {
                try {
                    if (StringUtils.equals((CharSequence)"signal", (CharSequence)args[0].toString())) {
                        Log.d((String)TAG, (String)("call: " + args[0].toString()));
                    } else {
                        JSONObject jsonObject = new JSONObject(args[0].toString());
                        if (!jsonObject.isNull("signal")) {
                            switch (jsonObject.get("signal").toString()) {
                                case "welcome": {
                                    Log.d((String)TAG, (String)("call: " + jsonObject.get("data")));
                                    break;
                                }
                                case "message.unread": {
                                    AISocketMessage aiSocketMessage = (AISocketMessage)GsonUtils.fromJson((String)jsonObject.get("data").toString(), AISocketMessage.class);
                                    Log.d((String)TAG, (String)("call: " + aiSocketMessage));
                                    for (SignalListener listener : listeners) {
                                        listener.onSignalReceived(aiSocketMessage);
                                    }
                                    break;
                                }
                            }
                        }
                    }
                    Log.d((String)TAG, (String)"call: signal");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            mSocket.connect();
        }
        catch (URISyntaxException e) {
            Log.e((String)TAG, (String)("setSocket: " + e.getMessage()));
        }
    }

    public static void close() {
        if (mSocket != null) {
            mSocket.close();
        }
    }

    static {
        listeners = new CopyOnWriteArrayList<SignalListener>();
    }

    public static interface SignalListener {
        public void onSignalReceived(AISocketMessage var1);
    }
}

