/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.aiassistant.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import com.edusoho.aiassistant.R;
import com.edusoho.aiassistant.databinding.AiAccessibleButtonBinding;

public class AIAccessibleButton
extends LinearLayout {
    private AiAccessibleButtonBinding binding;

    public AIAccessibleButton(Context context) {
        super(context);
        this.init(context, null);
    }

    public AIAccessibleButton(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public AIAccessibleButton(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    public AIAccessibleButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, @Nullable AttributeSet attrs) {
        this.binding = AiAccessibleButtonBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this);
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.AIAccessibleButton);
            try {
                int iconResId = typedArray.getResourceId(R.styleable.AIAccessibleButton_icon, R.drawable.ai_icon_generate_study_plan);
                this.binding.ivIcon.setImageResource(iconResId);
                String text = typedArray.getString(R.styleable.AIAccessibleButton_text);
                this.binding.tvAccessibleText.setText((CharSequence)text);
            }
            finally {
                typedArray.recycle();
            }
        }
    }

    public String getText() {
        return this.binding.tvAccessibleText.getText().toString();
    }
}

