/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.aiassistant.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.lifecycle.OnLifecycleEvent;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.blankj.utilcode.util.BarUtils;
import com.blankj.utilcode.util.StringUtils;
import com.edusoho.aiassistant.AIAssistantConfig;
import com.edusoho.aiassistant.AIAssistantSDK;
import com.edusoho.aiassistant.AIFloatWidgetButtonListener;
import com.edusoho.aiassistant.R;
import com.edusoho.aiassistant.databinding.AiFloatingWidgetLayoutBinding;
import com.edusoho.aiassistant.entity.AISocketMessage;
import com.edusoho.aiassistant.entity.MetaData;
import com.edusoho.aiassistant.util.AIUnreadMessageCache;
import com.edusoho.aiassistant.viewmodel.AIViewModel;

public class AIFloatingWidget
extends ConstraintLayout
implements LifecycleObserver {
    private static final String TAG = "AIFloatingWidget";
    private long mDelayHideAvatarDuration = 5000L;
    private AIViewModel mAIViewModel;
    private Observer<AISocketMessage> mObserver;
    private MetaData mMetadata = new MetaData(0, "", 0, "");
    private String mDomainId;
    private boolean isShowAccessible;
    private boolean isGeneratedStudyPlan;
    private float dX;
    private float dY;
    private float oX;
    private float oY;
    private AiFloatingWidgetLayoutBinding binding;
    private Handler handler;
    private Runnable hideRunnable;
    private String mFloatType;
    private boolean isAvatarMoveable = true;
    private boolean isShowPromptWithAvatar = false;
    private boolean isStillShow = true;
    private AIAssistantConfig mAIAssistantConfig;
    private AIFloatWidgetButtonListener mAIFloatWidgetButtonListener;

    public AIFloatingWidget(@NonNull Context context) {
        super(context);
        this.init(context, null);
    }

    public AIFloatingWidget(@NonNull Context context, long delayHideAvatarDuration) {
        super(context);
        this.mDelayHideAvatarDuration = delayHideAvatarDuration;
        this.init(context, null);
    }

    public AIFloatingWidget(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public AIFloatingWidget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, @Nullable AttributeSet attrs) {
        this.binding = AiFloatingWidgetLayoutBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this);
        this.handler = new Handler(Looper.getMainLooper());
        this.hideRunnable = this::hideHalfBasedOnPosition;
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.AIFloatingWidget);
            try {
                int iconResId = typedArray.getResourceId(R.styleable.AIFloatingWidget_iconSrc, R.drawable.ai_icon);
                this.setIcon(iconResId);
                boolean isShowSayHi = typedArray.getBoolean(R.styleable.AIFloatingWidget_say_hi, false);
                this.mDelayHideAvatarDuration = typedArray.getInt(R.styleable.AIFloatingWidget_delay_hide, 5000);
                this.setShowPrompt(isShowSayHi);
            }
            finally {
                typedArray.recycle();
            }
        }
        this.binding.clPrompt.setOnClickListener(null);
        this.setOnClickListener(v -> {
            this.setShowPrompt(false);
            this.clickAvatar();
        });
        this.handler.postDelayed(this.hideRunnable, this.mDelayHideAvatarDuration);
        this.binding.ivClose.setOnClickListener(v -> this.setShowPrompt(false));
        this.binding.tvSendMessageButton.setOnClickListener(v -> {
            this.setShowPrompt(false);
            this.setMessageNum(0);
            if (StringUtils.equals((CharSequence)"course", (CharSequence)this.mFloatType)) {
                AIAssistantSDK.launch(new AIAssistantConfig.Builder().metaData(this.mMetadata).isShowAccessible(this.isShowAccessible).isGeneratedStudyPlan(this.isGeneratedStudyPlan).domainId(this.mDomainId).preMessageType("text").preSendMessage("\u5236\u5b9a\u5b66\u4e60\u8ba1\u5212").build());
            } else if (StringUtils.equals((CharSequence)"question", (CharSequence)this.mFloatType) && this.mAIFloatWidgetButtonListener != null) {
                this.mAIFloatWidgetButtonListener.onButtonClick();
            }
        });
        this.initViewModel();
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public void onActivityDestroy() {
        this.clearViewModel();
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_RESUME)
    public void onActivityResume() {
        this.setMessageNum(AIUnreadMessageCache.getTotalUnread());
    }

    private void initViewModel() {
        if (this.mAIViewModel == null) {
            this.mAIViewModel = (AIViewModel)new ViewModelProvider((ViewModelStoreOwner)this.findHostActivity()).get(AIViewModel.class);
        }
        if (this.mObserver == null) {
            this.mObserver = aiSocketMessage -> {
                Log.d((String)TAG, (String)("onChanged: " + aiSocketMessage.toString()));
                if (aiSocketMessage.getTotal() > 0) {
                    this.setVisibility(0);
                    AIUnreadMessageCache.replace(aiSocketMessage);
                    this.setMessageNum(AIUnreadMessageCache.getTotalUnread());
                    this.showAvatar();
                }
            };
        }
        this.mAIViewModel.getMessageLiveData().observe((LifecycleOwner)this.findHostActivity(), this.mObserver);
    }

    private void clearViewModel() {
        if (this.mAIViewModel != null) {
            this.mAIViewModel.getMessageLiveData().removeObservers((LifecycleOwner)this.findHostActivity());
        }
        this.mAIViewModel = null;
        this.mObserver = null;
    }

    private void clickAvatar() {
        if (StringUtils.isEmpty((CharSequence)this.mDomainId)) {
            String defaultDomainId = AIUnreadMessageCache.getDefaultDomainId();
            AIAssistantSDK.launch(new AIAssistantConfig.Builder().metaData(this.mMetadata).domainId(defaultDomainId).isShowAccessible(this.isShowAccessible).isGeneratedStudyPlan(this.isGeneratedStudyPlan).build());
            if (!AIUnreadMessageCache.isAnotherDomainId(defaultDomainId)) {
                this.setVisibility(4);
            }
        } else {
            AIAssistantSDK.launch(new AIAssistantConfig.Builder().metaData(this.mMetadata).domainId(this.mDomainId).isShowAccessible(this.isShowAccessible).isGeneratedStudyPlan(this.isGeneratedStudyPlan).build());
        }
    }

    public void setStillShow(boolean isStillShow) {
        this.isStillShow = isStillShow;
    }

    private void showAvatar() {
        float targetX = this.getX() < 0.0f ? 0.0f : (float)(this.getResources().getDisplayMetrics().widthPixels - this.getWidth());
        this.animate().x(targetX).setDuration(300L).alpha(1.0f).withEndAction(() -> this.handler.postDelayed(this.hideRunnable, this.mDelayHideAvatarDuration)).start();
    }

    private FragmentActivity findHostActivity() {
        Context context = this.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof FragmentActivity) {
                return (FragmentActivity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        throw new IllegalStateException("AIFloatingWidget \u5fc5\u987b\u5d4c\u5165 FragmentActivity \u4e2d");
    }

    public void setIcon(int iconResId) {
        this.binding.ivAiAvatar.setImageResource(iconResId);
    }

    public void setAIFloatWidgetButtonListener(AIFloatWidgetButtonListener listener) {
        this.mAIFloatWidgetButtonListener = listener;
    }

    public void setShowPrompt(boolean isShow) {
        try {
            if (isShow) {
                this.binding.clPrompt.setVisibility(0);
                this.binding.vGap.setVisibility(0);
            } else {
                Log.d((String)TAG, (String)("setShowPrompt - binding: " + (this.binding == null)));
                this.binding.clPrompt.setVisibility(8);
                this.binding.vGap.setVisibility(8);
            }
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)e.getMessage());
        }
    }

    public void setDelayHideAvatar(long delayMillis) {
        this.mDelayHideAvatarDuration = delayMillis;
    }

    public void setPrompt(String title, String content, String buttonText, boolean isShowClose) {
        this.binding.tvTitle.setText(title);
        this.binding.tvTitle.setVisibility(StringUtils.isEmpty((CharSequence)title) ? 8 : 0);
        this.binding.tvContent.setText((CharSequence)content);
        this.binding.tvContent.setVisibility(StringUtils.isEmpty((CharSequence)content) ? 8 : 0);
        this.binding.tvSendMessageButton.setText((CharSequence)buttonText);
        this.binding.tvSendMessageButton.setVisibility(StringUtils.isEmpty((CharSequence)buttonText) ? 8 : 0);
        this.binding.ivClose.setVisibility(isShowClose ? 0 : 8);
    }

    public void setMessageNum(int num) {
        if (num >= 1) {
            this.binding.tvMessageNum.setVisibility(0);
            this.binding.tvMessageNum.setText((CharSequence)String.valueOf(num));
        } else {
            if (!this.isStillShow) {
                this.setVisibility(4);
            }
            this.binding.tvMessageNum.setVisibility(8);
        }
    }

    public void setAvatarMoveable(boolean isAvatarMoveable) {
        this.isAvatarMoveable = isAvatarMoveable;
    }

    public void setFloatType(String floatType) {
        this.mFloatType = floatType;
    }

    public void setMetadata(MetaData metadata) {
        this.mMetadata = metadata;
    }

    public void setDomainId(String domainId) {
        this.mDomainId = domainId;
    }

    public void setShowPromptWithAvatar(boolean isShow) {
        this.isShowPromptWithAvatar = isShow;
    }

    public void setShowAccessible(boolean isShowAccessible) {
        this.isShowAccessible = isShowAccessible;
    }

    public void isGeneratedStudyPlan(boolean isGeneratedStudyPlan) {
        this.isGeneratedStudyPlan = isGeneratedStudyPlan;
    }

    public void setDelayHidePrompt() {
        this.handler.postDelayed(() -> this.setShowPrompt(false), this.mDelayHideAvatarDuration - 500L);
    }

    public void setDelayHide() {
        this.handler.postDelayed(this.hideRunnable, this.mDelayHideAvatarDuration);
    }

    public void setAIAssistantConfig(AIAssistantConfig aiAssistantConfig) {
        this.mAIAssistantConfig = aiAssistantConfig;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.oX = this.getX();
                this.oY = this.getY();
                this.dX = this.getX() - event.getRawX();
                this.dY = this.getY() - event.getRawY();
                this.handler.removeCallbacks(this.hideRunnable);
                return true;
            }
            case 2: {
                if (this.isHalfHidden()) {
                    return true;
                }
                if (!this.isAvatarMoveable || this.isPromptVisible()) {
                    return true;
                }
                float newX = event.getRawX() + this.dX;
                float newY = event.getRawY() + this.dY;
                newX = Math.max(0.0f, Math.min(newX, (float)(this.getResources().getDisplayMetrics().widthPixels - this.getWidth())));
                newY = Math.max(0.0f, Math.min(newY, (float)(this.getResources().getDisplayMetrics().heightPixels - this.getHeight())));
                this.animate().x(newX).y(newY).setDuration(0L).start();
                return true;
            }
            case 1: {
                if (this.isHalfHidden()) {
                    float targetX = this.getX() < 0.0f ? 0.0f : (float)(this.getResources().getDisplayMetrics().widthPixels - this.getWidth());
                    this.animate().x(targetX).setDuration(300L).alpha(1.0f).withEndAction(() -> {
                        if (this.isShowPromptWithAvatar) {
                            this.setShowPrompt(true);
                            this.setDelayHidePrompt();
                        }
                        this.handler.postDelayed(this.hideRunnable, this.mDelayHideAvatarDuration);
                    }).start();
                    return true;
                }
                if (Math.abs(this.oX - this.getX()) < 10.0f && Math.abs(this.oY - this.getY()) < 10.0f) {
                    this.performClick();
                } else {
                    float targetX = this.getX() < (float)this.getResources().getDisplayMetrics().widthPixels / 2.0f ? 0.0f : (float)(this.getResources().getDisplayMetrics().widthPixels - this.getWidth());
                    this.animate().x(targetX).setDuration(300L).alpha(1.0f).withEndAction(() -> this.handler.postDelayed(this.hideRunnable, this.mDelayHideAvatarDuration)).start();
                }
                return true;
            }
        }
        return false;
    }

    private void hideHalfBasedOnPosition() {
        if (this.binding.clPrompt.getVisibility() == 0) {
            return;
        }
        float currentX = this.getX();
        if (currentX == 0.0f) {
            this.animate().x((float)(-this.getWidth()) / 2.0f).alpha(0.4f).setDuration(300L).start();
        } else if (currentX == (float)(this.getResources().getDisplayMetrics().widthPixels - this.getWidth())) {
            this.animate().x((float)this.getResources().getDisplayMetrics().widthPixels - (float)this.getWidth() / 2.0f).setDuration(300L).alpha(0.4f).start();
        }
    }

    private boolean isHalfHidden() {
        float halfHiddenLeft = (float)(-this.getWidth()) / 2.0f;
        float halfHiddenRight = (float)this.getResources().getDisplayMetrics().widthPixels - (float)this.getWidth() / 2.0f;
        float currentX = this.getX();
        return Math.abs(currentX - halfHiddenLeft) < 1.0f || Math.abs(currentX - halfHiddenRight) < 1.0f;
    }

    private boolean isPromptVisible() {
        return this.binding.clPrompt.getVisibility() == 0;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.handler.removeCallbacks(this.hideRunnable);
        this.binding = null;
        this.clearViewModel();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        int screenWidth = displayMetrics.widthPixels;
        int screenHeight = displayMetrics.heightPixels;
        int usableHeight = screenHeight - BarUtils.getStatusBarHeight() - BarUtils.getActionBarHeight() - this.getHeight() / 2;
        Log.d((String)TAG, (String)("onConfigurationChanged: screen w:" + screenWidth));
        Log.d((String)TAG, (String)("onConfigurationChanged: screen h:" + screenHeight));
        Log.d((String)TAG, (String)("Status bar height:" + BarUtils.getStatusBarHeight()));
        Log.d((String)TAG, (String)("ActionBar height:" + BarUtils.getActionBarHeight()));
        Log.d((String)TAG, (String)("Usable height:" + usableHeight));
        Log.d((String)TAG, (String)("current X:" + this.getX()));
        Log.d((String)TAG, (String)("current Y:" + this.getY()));
        float targetX = (float)screenWidth - (float)this.getWidth() / 2.0f;
        float targetY = usableHeight - this.getHeight();
        this.animate().x(targetX).y(targetY).setDuration(300L).start();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isHalfHidden()) {
            this.setX(this.getResources().getDisplayMetrics().widthPixels - this.getWidth());
            this.handler.postDelayed(this.hideRunnable, this.mDelayHideAvatarDuration);
        }
    }

    public static final class FloatType {
        public static final String COURSE = "course";
        public static final String QUESTION = "question";
    }
}

