/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.aiassistant.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.LinearLayoutCompat;
import com.edusoho.aiassistant.R;
import com.edusoho.aiassistant.databinding.AiLikePanelBinding;

public class AIRatePanel
extends LinearLayoutCompat {
    private AiLikePanelBinding binding;

    public AIRatePanel(@NonNull Context context) {
        super(context);
        this.init(context, null);
    }

    public AIRatePanel(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public AIRatePanel(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, @Nullable AttributeSet attrs) {
        this.binding = AiLikePanelBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this);
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.AILikePanel);
            try {
                int rate = typedArray.getInt(R.styleable.AILikePanel_rate, 0);
                this.setRate(rate);
            }
            finally {
                typedArray.recycle();
            }
        }
    }

    public void setRate(int rate) {
        switch (rate) {
            case 0: {
                this.binding.ivLike.setImageResource(R.drawable.ai_icon_like_normal);
                this.binding.ivDislike.setImageResource(R.drawable.ai_icon_dislike_normal);
                break;
            }
            case 1: {
                this.binding.ivLike.setImageResource(R.drawable.ai_icon_like_pressed);
                this.binding.ivLike.setEnabled(false);
                this.binding.ivDislike.setImageResource(R.drawable.ai_icon_dislike_normal);
                this.binding.ivDislike.setEnabled(true);
                break;
            }
            case 2: {
                this.binding.ivLike.setImageResource(R.drawable.ai_icon_like_normal);
                this.binding.ivLike.setEnabled(true);
                this.binding.ivDislike.setImageResource(R.drawable.ai_icon_dislike_pressed);
                this.binding.ivDislike.setEnabled(false);
            }
        }
    }
}

