/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.aiassistant.widget;

import android.content.Context;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.core.content.ContextCompat;
import com.edusoho.aiassistant.R;

public class WeekDayTextView
extends AppCompatTextView {
    private boolean isSelected;

    public WeekDayTextView(Context context) {
        super(context);
        this.init();
    }

    public WeekDayTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public WeekDayTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.color_37393D));
        this.setBackgroundResource(R.drawable.bg_schedule_weekday_normal);
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
        this.updateAppearance();
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateAppearance();
    }

    private void updateAppearance() {
        if (this.isEnabled()) {
            if (this.isSelected) {
                this.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.color_165DFF));
                this.setBackgroundResource(R.drawable.bg_schedule_weekday_pressed);
            } else {
                this.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.color_37393D));
                this.setBackgroundResource(R.drawable.bg_schedule_weekday_normal);
            }
        } else {
            this.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.color_C0C0C2));
            this.setBackgroundResource(R.drawable.bg_schedule_weekday_disabled);
        }
    }
}

