/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.image;

import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import io.noties.markwon.image.AsyncDrawable;
import io.noties.markwon.image.AsyncDrawableLoader;
import io.noties.markwon.image.AsyncDrawableLoaderBuilder;
import io.noties.markwon.image.DrawableUtils;
import io.noties.markwon.image.ImageItem;
import io.noties.markwon.image.ImagesPlugin;
import io.noties.markwon.image.MediaDecoder;
import io.noties.markwon.image.SchemeHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

class AsyncDrawableLoaderImpl
extends AsyncDrawableLoader {
    private final ExecutorService executorService;
    private final Map<String, SchemeHandler> schemeHandlers;
    private final Map<String, MediaDecoder> mediaDecoders;
    private final MediaDecoder defaultMediaDecoder;
    private final ImagesPlugin.PlaceholderProvider placeholderProvider;
    private final ImagesPlugin.ErrorHandler errorHandler;
    private final Handler handler;
    private final Map<AsyncDrawable, Future<?>> requests = new HashMap(2);

    AsyncDrawableLoaderImpl(@NonNull AsyncDrawableLoaderBuilder builder) {
        this(builder, new Handler(Looper.getMainLooper()));
    }

    @VisibleForTesting
    AsyncDrawableLoaderImpl(@NonNull AsyncDrawableLoaderBuilder builder, @NonNull Handler handler) {
        this.executorService = builder.executorService;
        this.schemeHandlers = builder.schemeHandlers;
        this.mediaDecoders = builder.mediaDecoders;
        this.defaultMediaDecoder = builder.defaultMediaDecoder;
        this.placeholderProvider = builder.placeholderProvider;
        this.errorHandler = builder.errorHandler;
        this.handler = handler;
    }

    public void load(@NonNull AsyncDrawable drawable) {
        Future<?> future = this.requests.get(drawable);
        if (future == null) {
            this.requests.put(drawable, this.execute(drawable));
        }
    }

    public void cancel(@NonNull AsyncDrawable drawable) {
        Future<?> future = this.requests.remove(drawable);
        if (future != null) {
            future.cancel(true);
        }
        this.handler.removeCallbacksAndMessages((Object)drawable);
    }

    @Nullable
    public Drawable placeholder(@NonNull AsyncDrawable drawable) {
        return this.placeholderProvider != null ? this.placeholderProvider.providePlaceholder(drawable) : null;
    }

    @NonNull
    private Future<?> execute(@NonNull AsyncDrawable asyncDrawable) {
        return this.executorService.submit(() -> this.doLoadDrawable(asyncDrawable));
    }

    @WorkerThread
    private void doLoadDrawable(@NonNull AsyncDrawable asyncDrawable) {
        String destination = asyncDrawable.getDestination();
        Uri uri = Uri.parse((String)destination);
        Drawable drawable = null;
        boolean shouldMarkRequesting = false;
        try {
            String scheme = uri.getScheme();
            if (scheme == null || scheme.isEmpty()) {
                throw new IllegalStateException("No scheme is found: " + destination);
            }
            SchemeHandler schemeHandler = this.schemeHandlers.get(scheme);
            if (schemeHandler == null) {
                throw new IllegalStateException("No scheme-handler is found: " + destination);
            }
            ImageItem imageItem = schemeHandler.prefetch(destination, uri);
            if (imageItem == null) {
                shouldMarkRequesting = true;
                imageItem = schemeHandler.handle(destination, uri, (item, success) -> {
                    if (item == null) {
                        return;
                    }
                    if (!success) {
                        return;
                    }
                    if (!item.hasDecodingNeeded()) {
                        this.doLoadDrawable(asyncDrawable);
                        return;
                    }
                    Drawable resDrawable = this.proceedAndDecodeImage(item.getAsWithDecodingNeeded(), destination);
                    if (resDrawable == null) {
                        this.handler.postAtTime(() -> this.requests.remove(asyncDrawable), (Object)asyncDrawable, SystemClock.uptimeMillis());
                        return;
                    }
                    DrawableUtils.ensureBounds((Drawable)resDrawable);
                    this.handler.postAtTime(() -> {
                        Future<?> future = this.requests.remove(asyncDrawable);
                        if (future != null && asyncDrawable.isAttached()) {
                            asyncDrawable.setResult(resDrawable);
                        }
                    }, (Object)asyncDrawable, SystemClock.uptimeMillis());
                });
            }
            if (!imageItem.hasDecodingNeeded()) {
                drawable = imageItem.getAsWithResult().result();
            } else {
                ImageItem.WithDecodingNeeded withDecodingNeeded = imageItem.getAsWithDecodingNeeded();
                drawable = withDecodingNeeded.getCachedDrawable();
            }
        }
        catch (Throwable t) {
            if (this.errorHandler != null) {
                drawable = this.errorHandler.handleError(destination, t);
            }
            Log.e((String)"MARKWON-IMAGE", (String)("Error loading image: " + destination), (Throwable)t);
        }
        Drawable out = drawable;
        if (out != null) {
            DrawableUtils.ensureBounds((Drawable)out);
        }
        if (shouldMarkRequesting) {
            return;
        }
        this.handler.postAtTime(() -> {
            Future<?> future = this.requests.remove(asyncDrawable);
            if (future != null && out != null && asyncDrawable.isAttached()) {
                asyncDrawable.setResult(out);
            }
        }, (Object)asyncDrawable, SystemClock.uptimeMillis());
    }

    private Drawable proceedAndDecodeImage(@NonNull ImageItem.WithDecodingNeeded withDecodingNeeded, String destination) {
        Drawable resDrawable;
        block11: {
            resDrawable = null;
            InputStream imgInputStream = withDecodingNeeded.inputStream();
            try (InputStream inputStream = imgInputStream;){
                if (imgInputStream == null) {
                    throw new IllegalStateException("image still in requesting: " + destination);
                }
                MediaDecoder mediaDecoder = this.mediaDecoders.get(withDecodingNeeded.contentType());
                if (mediaDecoder == null) {
                    mediaDecoder = this.defaultMediaDecoder;
                }
                if (mediaDecoder != null) {
                    resDrawable = mediaDecoder.decode(withDecodingNeeded.contentType(), imgInputStream);
                    withDecodingNeeded.setCachedDrawable(resDrawable);
                    break block11;
                }
                throw new IllegalStateException("No media-decoder is found: " + destination);
            }
            catch (IOException e) {
                Log.e((String)"MARKWON-IMAGE", (String)"Error closing inputStream", (Throwable)e);
            }
        }
        return resDrawable;
    }
}

