/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.image;

import android.graphics.drawable.Drawable;
import android.text.Spanned;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.noties.markwon.AbstractMarkwonPlugin;
import io.noties.markwon.MarkwonConfiguration;
import io.noties.markwon.MarkwonSpansFactory;
import io.noties.markwon.SpanFactory;
import io.noties.markwon.image.AsyncDrawable;
import io.noties.markwon.image.AsyncDrawableLoaderBuilder;
import io.noties.markwon.image.AsyncDrawableScheduler;
import io.noties.markwon.image.ImageSpanFactory;
import io.noties.markwon.image.MediaDecoder;
import io.noties.markwon.image.SchemeHandler;
import java.util.concurrent.ExecutorService;
import org.commonmark.node.Image;

public class ImagesPlugin
extends AbstractMarkwonPlugin {
    private final AsyncDrawableLoaderBuilder builder;

    @NonNull
    public static ImagesPlugin create() {
        return new ImagesPlugin(false);
    }

    @NonNull
    public static ImagesPlugin create(boolean asyncRequest) {
        return new ImagesPlugin(asyncRequest);
    }

    @NonNull
    public static ImagesPlugin create(@NonNull ImagesConfigure configure) {
        ImagesPlugin plugin = new ImagesPlugin(false);
        configure.configureImages(plugin);
        return plugin;
    }

    ImagesPlugin(boolean asyncRequest) {
        this(new AsyncDrawableLoaderBuilder(asyncRequest));
    }

    @VisibleForTesting
    ImagesPlugin(@NonNull AsyncDrawableLoaderBuilder builder) {
        this.builder = builder;
    }

    @NonNull
    public ImagesPlugin executorService(@NonNull ExecutorService executorService) {
        this.builder.executorService(executorService);
        return this;
    }

    @NonNull
    public ImagesPlugin addSchemeHandler(@NonNull SchemeHandler schemeHandler) {
        this.builder.addSchemeHandler(schemeHandler);
        return this;
    }

    @NonNull
    public ImagesPlugin addMediaDecoder(@NonNull MediaDecoder mediaDecoder) {
        this.builder.addMediaDecoder(mediaDecoder);
        return this;
    }

    @NonNull
    public ImagesPlugin defaultMediaDecoder(@Nullable MediaDecoder mediaDecoder) {
        this.builder.defaultMediaDecoder(mediaDecoder);
        return this;
    }

    @NonNull
    public ImagesPlugin removeSchemeHandler(@NonNull String scheme) {
        this.builder.removeSchemeHandler(scheme);
        return this;
    }

    @NonNull
    public ImagesPlugin removeMediaDecoder(@NonNull String contentType) {
        this.builder.removeMediaDecoder(contentType);
        return this;
    }

    @NonNull
    public ImagesPlugin placeholderProvider(@NonNull PlaceholderProvider placeholderProvider) {
        this.builder.placeholderProvider(placeholderProvider);
        return this;
    }

    @NonNull
    public ImagesPlugin errorHandler(@NonNull ErrorHandler errorHandler) {
        this.builder.errorHandler(errorHandler);
        return this;
    }

    public void configureConfiguration(@NonNull MarkwonConfiguration.Builder builder) {
        builder.asyncDrawableLoader(this.builder.build());
    }

    public void configureSpansFactory(@NonNull MarkwonSpansFactory.Builder builder) {
        builder.setFactory(Image.class, (SpanFactory)new ImageSpanFactory());
    }

    public void beforeSetText(@NonNull TextView textView, @NonNull Spanned markdown) {
        AsyncDrawableScheduler.unschedule((TextView)textView);
    }

    public void afterSetText(@NonNull TextView textView) {
        AsyncDrawableScheduler.schedule((TextView)textView);
    }

    public static interface ImagesConfigure {
        public void configureImages(@NonNull ImagesPlugin var1);
    }

    public static interface PlaceholderProvider {
        @Nullable
        public Drawable providePlaceholder(@NonNull AsyncDrawable var1);
    }

    public static interface ErrorHandler {
        @Nullable
        public Drawable handleError(@NonNull String var1, @NonNull Throwable var2);
    }
}

